/*
 * Decompiled with CFR 0.152.
 */
package android.support.v7.internal.view.menu;

import android.support.v4.internal.view.SupportMenuItem;
import android.support.v7.internal.view.menu.BaseWrapper;
import android.support.v7.internal.view.menu.MenuWrapperFactory;
import android.view.MenuItem;
import android.view.SubMenu;
import java.util.HashMap;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class BaseMenuWrapper<T>
extends BaseWrapper<T> {
    private HashMap<MenuItem, SupportMenuItem> mMenuItems;
    private HashMap<SubMenu, SubMenu> mSubMenus;

    BaseMenuWrapper(T object) {
        super(object);
    }

    final SupportMenuItem getMenuItemWrapper(MenuItem frameworkItem) {
        if (frameworkItem != null) {
            SupportMenuItem compatItem;
            if (this.mMenuItems == null) {
                this.mMenuItems = new HashMap();
            }
            if (null == (compatItem = this.mMenuItems.get(frameworkItem))) {
                compatItem = MenuWrapperFactory.createSupportMenuItemWrapper(frameworkItem);
                this.mMenuItems.put(frameworkItem, compatItem);
            }
            return compatItem;
        }
        return null;
    }

    final SubMenu getSubMenuWrapper(SubMenu frameworkSubMenu) {
        if (frameworkSubMenu != null) {
            SubMenu compatSubMenu;
            if (this.mSubMenus == null) {
                this.mSubMenus = new HashMap();
            }
            if (null == (compatSubMenu = this.mSubMenus.get(frameworkSubMenu))) {
                compatSubMenu = MenuWrapperFactory.createSupportSubMenuWrapper(frameworkSubMenu);
                this.mSubMenus.put(frameworkSubMenu, compatSubMenu);
            }
            return compatSubMenu;
        }
        return null;
    }

    final void internalClear() {
        if (this.mMenuItems != null) {
            this.mMenuItems.clear();
        }
        if (this.mSubMenus != null) {
            this.mSubMenus.clear();
        }
    }

    final void internalRemoveGroup(int groupId) {
        if (this.mMenuItems == null) {
            return;
        }
        Iterator<MenuItem> iterator = this.mMenuItems.keySet().iterator();
        while (iterator.hasNext()) {
            MenuItem menuItem = iterator.next();
            if (groupId != menuItem.getGroupId()) continue;
            iterator.remove();
        }
    }

    final void internalRemoveItem(int id2) {
        if (this.mMenuItems == null) {
            return;
        }
        Iterator<MenuItem> iterator = this.mMenuItems.keySet().iterator();
        while (iterator.hasNext()) {
            MenuItem menuItem = iterator.next();
            if (id2 != menuItem.getItemId()) continue;
            iterator.remove();
            break;
        }
    }
}

