/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.PendingIntent;
import android.content.Context;
import android.location.Location;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.RemoteException;
import android.util.Log;
import com.google.android.gms.common.GooglePlayServicesClient;
import com.google.android.gms.internal.db;
import com.google.android.gms.internal.de;
import com.google.android.gms.internal.dj;
import com.google.android.gms.internal.dm;
import com.google.android.gms.internal.ew;
import com.google.android.gms.internal.ex;
import com.google.android.gms.internal.ey;
import com.google.android.gms.internal.fa;
import com.google.android.gms.internal.fc;
import com.google.android.gms.location.LocationClient;
import com.google.android.gms.location.LocationListener;
import com.google.android.gms.location.LocationRequest;
import com.google.android.gms.location.LocationStatusCodes;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ez
extends de<ex> {
    private final fc<ex> oO = new c();
    private final ey oU;
    private final String oV;

    public ez(Context context, GooglePlayServicesClient.ConnectionCallbacks connectionCallbacks, GooglePlayServicesClient.OnConnectionFailedListener onConnectionFailedListener, String string2) {
        super(context, connectionCallbacks, onConnectionFailedListener, new String[0]);
        this.oU = new ey(context, this.oO);
        this.oV = string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disconnect() {
        ey ey2 = this.oU;
        synchronized (ey2) {
            if (this.isConnected()) {
                this.oU.removeAllListeners();
                this.oU.cm();
            }
            super.disconnect();
        }
    }

    @Override
    protected String ag() {
        return "com.google.android.location.internal.GoogleLocationManagerService.START";
    }

    @Override
    protected String ah() {
        return "com.google.android.gms.location.internal.IGoogleLocationManagerService";
    }

    public void requestActivityUpdates(long detectionIntervalMillis, PendingIntent callbackIntent) {
        this.bc();
        dm.e(callbackIntent);
        dm.b(detectionIntervalMillis >= 0L, "detectionIntervalMillis must be >= 0");
        try {
            ((ex)this.bd()).a(detectionIntervalMillis, true, callbackIntent);
        }
        catch (RemoteException remoteException) {
            throw new IllegalStateException(remoteException);
        }
    }

    public void removeActivityUpdates(PendingIntent callbackIntent) {
        this.bc();
        dm.e(callbackIntent);
        try {
            ((ex)this.bd()).removeActivityUpdates(callbackIntent);
        }
        catch (RemoteException remoteException) {
            throw new IllegalStateException(remoteException);
        }
    }

    public void addGeofences(List<fa> geofences, PendingIntent pendingIntent, LocationClient.OnAddGeofencesResultListener listener) {
        this.bc();
        dm.b(geofences != null && geofences.size() > 0, "At least one geofence must be specified.");
        dm.a(pendingIntent, (Object)"PendingIntent must be specified.");
        dm.a(listener, (Object)"OnAddGeofencesResultListener not provided.");
        try {
            b b2 = listener == null ? null : new b(listener, this);
            ((ex)this.bd()).a(geofences, pendingIntent, b2, this.getContext().getPackageName());
        }
        catch (RemoteException remoteException) {
            throw new IllegalStateException(remoteException);
        }
    }

    public void removeGeofences(PendingIntent pendingIntent, LocationClient.OnRemoveGeofencesResultListener listener) {
        this.bc();
        dm.a(pendingIntent, (Object)"PendingIntent must be specified.");
        dm.a(listener, (Object)"OnRemoveGeofencesResultListener not provided.");
        try {
            b b2 = listener == null ? null : new b(listener, this);
            ((ex)this.bd()).a(pendingIntent, (ew)b2, this.getContext().getPackageName());
        }
        catch (RemoteException remoteException) {
            throw new IllegalStateException(remoteException);
        }
    }

    public void removeGeofences(List<String> geofenceRequestIds, LocationClient.OnRemoveGeofencesResultListener listener) {
        this.bc();
        dm.b(geofenceRequestIds != null && geofenceRequestIds.size() > 0, "geofenceRequestIds can't be null nor empty.");
        dm.a(listener, (Object)"OnRemoveGeofencesResultListener not provided.");
        String[] stringArray = geofenceRequestIds.toArray(new String[0]);
        try {
            b b2 = listener == null ? null : new b(listener, this);
            ((ex)this.bd()).a(stringArray, (ew)b2, this.getContext().getPackageName());
        }
        catch (RemoteException remoteException) {
            throw new IllegalStateException(remoteException);
        }
    }

    public Location getLastLocation() {
        return this.oU.getLastLocation();
    }

    public void requestLocationUpdates(LocationRequest request, LocationListener listener) {
        this.requestLocationUpdates(request, listener, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestLocationUpdates(LocationRequest request, LocationListener listener, Looper looper) {
        ey ey2 = this.oU;
        synchronized (ey2) {
            this.oU.requestLocationUpdates(request, listener, looper);
        }
    }

    public void requestLocationUpdates(LocationRequest request, PendingIntent callbackIntent) {
        this.oU.requestLocationUpdates(request, callbackIntent);
    }

    public void removeLocationUpdates(LocationListener listener) {
        this.oU.removeLocationUpdates(listener);
    }

    public void removeLocationUpdates(PendingIntent callbackIntent) {
        this.oU.removeLocationUpdates(callbackIntent);
    }

    public void setMockMode(boolean isMockMode) {
        this.oU.setMockMode(isMockMode);
    }

    public void setMockLocation(Location mockLocation) {
        this.oU.setMockLocation(mockLocation);
    }

    protected ex G(IBinder iBinder) {
        return ex.a.F(iBinder);
    }

    @Override
    protected void a(dj dj2, de.d d2) throws RemoteException {
        Bundle bundle = new Bundle();
        bundle.putString("client_name", this.oV);
        dj2.e(d2, 4030500, this.getContext().getPackageName(), bundle);
    }

    @Override
    protected /* synthetic */ IInterface p(IBinder iBinder) {
        return this.G(iBinder);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class d
    extends de.b<LocationClient.OnRemoveGeofencesResultListener> {
        private final int iC;
        private final String[] oW;
        private final PendingIntent mPendingIntent;
        private final int pb;

        public d(int n2, LocationClient.OnRemoveGeofencesResultListener onRemoveGeofencesResultListener, int n3, String[] stringArray) {
            super(ez.this, onRemoveGeofencesResultListener);
            db.k(n2 == 2);
            this.pb = n2;
            this.iC = LocationStatusCodes.Z(n3);
            this.oW = stringArray;
            this.mPendingIntent = null;
        }

        public d(int n2, LocationClient.OnRemoveGeofencesResultListener onRemoveGeofencesResultListener, int n3, PendingIntent pendingIntent) {
            super(ez.this, onRemoveGeofencesResultListener);
            db.k(n2 == 1);
            this.pb = n2;
            this.iC = LocationStatusCodes.Z(n3);
            this.mPendingIntent = pendingIntent;
            this.oW = null;
        }

        @Override
        protected void a(LocationClient.OnRemoveGeofencesResultListener onRemoveGeofencesResultListener) {
            if (onRemoveGeofencesResultListener != null) {
                switch (this.pb) {
                    case 1: {
                        onRemoveGeofencesResultListener.onRemoveGeofencesByPendingIntentResult(this.iC, this.mPendingIntent);
                        break;
                    }
                    case 2: {
                        onRemoveGeofencesResultListener.onRemoveGeofencesByRequestIdsResult(this.iC, this.oW);
                        break;
                    }
                    default: {
                        Log.wtf((String)"LocationClientImpl", (String)("Unsupported action: " + this.pb));
                    }
                }
            }
        }

        @Override
        protected void aF() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class a
    extends de.b<LocationClient.OnAddGeofencesResultListener> {
        private final int iC;
        private final String[] oW;

        public a(LocationClient.OnAddGeofencesResultListener onAddGeofencesResultListener, int n2, String[] stringArray) {
            super(ez.this, onAddGeofencesResultListener);
            this.iC = LocationStatusCodes.Z(n2);
            this.oW = stringArray;
        }

        @Override
        protected void a(LocationClient.OnAddGeofencesResultListener onAddGeofencesResultListener) {
            if (onAddGeofencesResultListener != null) {
                onAddGeofencesResultListener.onAddGeofencesResult(this.iC, this.oW);
            }
        }

        @Override
        protected void aF() {
        }
    }

    private static final class b
    extends ew.a {
        private LocationClient.OnAddGeofencesResultListener oY;
        private LocationClient.OnRemoveGeofencesResultListener oZ;
        private ez pa;

        public b(LocationClient.OnAddGeofencesResultListener onAddGeofencesResultListener, ez ez2) {
            this.oY = onAddGeofencesResultListener;
            this.oZ = null;
            this.pa = ez2;
        }

        public b(LocationClient.OnRemoveGeofencesResultListener onRemoveGeofencesResultListener, ez ez2) {
            this.oZ = onRemoveGeofencesResultListener;
            this.oY = null;
            this.pa = ez2;
        }

        public void onAddGeofencesResult(int statusCode, String[] geofenceRequestIds) throws RemoteException {
            if (this.pa == null) {
                Log.wtf((String)"LocationClientImpl", (String)"onAddGeofenceResult called multiple times");
                return;
            }
            ez ez2 = this.pa;
            ez2.getClass();
            this.pa.a(ez2.new a(this.oY, statusCode, geofenceRequestIds));
            this.pa = null;
            this.oY = null;
            this.oZ = null;
        }

        public void onRemoveGeofencesByRequestIdsResult(int statusCode, String[] geofenceRequestIds) {
            if (this.pa == null) {
                Log.wtf((String)"LocationClientImpl", (String)"onRemoveGeofencesByRequestIdsResult called multiple times");
                return;
            }
            ez ez2 = this.pa;
            ez2.getClass();
            this.pa.a(ez2.new d(2, this.oZ, statusCode, geofenceRequestIds));
            this.pa = null;
            this.oY = null;
            this.oZ = null;
        }

        public void onRemoveGeofencesByPendingIntentResult(int statusCode, PendingIntent pendingIntent) {
            if (this.pa == null) {
                Log.wtf((String)"LocationClientImpl", (String)"onRemoveGeofencesByPendingIntentResult called multiple times");
                return;
            }
            ez ez2 = this.pa;
            ez2.getClass();
            this.pa.a(ez2.new d(1, this.oZ, statusCode, pendingIntent));
            this.pa = null;
            this.oY = null;
            this.oZ = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class c
    implements fc<ex> {
        private c() {
        }

        @Override
        public void bc() {
            ez.this.bc();
        }

        public ex cn() {
            return (ex)ez.this.bd();
        }

        @Override
        public /* synthetic */ IInterface bd() {
            return this.cn();
        }
    }
}

