
local base_topic = "/help basics"
local base_button = "Basics"

local function topic_basics()
	ib:SetHeader("st_001", "")
	ib:SetTitle("The basics")

	ib:SetMsg("\n\nThe following topics are the fundamental actions which will help you play the game.")
	ib:AddLink("Movement", "/help movement")
	ib:AddLink("Talking to NPC's", "/help talking")
	ib:AddLink("First steps", "/help first steps")
	ib:AddLink("Combat", "/help combat")
	ib:AddLink("Controls", "/help controls")
	ib:AddLink("Keybindings", "/help keybindings")

	ib:SetLHSButton("Back", "/help main")
end

local function topic_movement()
	ib:SetHeader("st_001", "")
	ib:SetTitle("Movement")

	ib:SetMsg("\n\nYou can move your character by either using your keyboard's ~number pad~ or by clicking the playfield with the mouse in the direction you want to move. ")
	ib:AddMsg("Currently the ~numpad~ is the easier and faster way to move, but mouse movement will be improved in coming releases. ")
	ib:AddMsg("\n\nEach key on the ~numpad~ moves the character in a directon. By default, pressing 7 will move the character north, 3 south, etc. These can be modified in the ~key bindings~ menu.")
	ib:AddMsg("\n\nTo move with the mouse, simply click on the map in the direction you want to move. You can hold down the mouse button to continually move and move the mouse to adjust direction.")

	ib:AddLink("Changing keybindings", "/help keybindings")
	ib:SetLHSButton(base_button, base_topic)
end

local function topic_talking()
	ib:SetHeader("st_001", "")
	ib:SetTitle("Talking to NPC's")

	ib:SetMsg("\n\nTo talk to a NPC you can target a friendly NPC by pressing the ~S~ key. Keep pressing the ~S~ key to cycle between nearby NPC's. ")
	ib:AddMsg("When you've targeted the NPC you want to talk to, press ~T~ to start talking to them. Many NPC's throughout the game have various ~quests~, ~rumours~, or ~services~ for you to talk about.")
	ib:AddMsg("\n\nOnce you've spoken to a NPC, you can use the various ~sidebar~ links, links in the main talk interface, and the two buttons at the bottom of the interface to talk about the various topics the NPC has to discuss.")
	
	-- This topic should eventually be added to the help files.
	--ib:AddLink("Advanced NPC interaction (SENTInce)", "/help sentince")
	ib:SetLHSButton(base_button, base_topic)
end

local function topic_combat()
	ib:SetHeader("st_001", "")
	ib:SetTitle("Combat")

	ib:SetMsg("\n\nDaimonin has 4 main modes of combat: ~melee~, ~magic~, ~prayer~, and ~ranged~. Each mode has its own strengths and weaknesses, and they can even be combined to suit your needs.")
	ib:AddMsg("\n\n~Melee~ combat is used at close quarters with an enemy. To use melee combat, you should first enable ~combat mode~. Near the bottom of the game screen, you should see a shield icon or crossed swords. ")
	ib:AddMsg("If it is a shield icon, you are not in combat mode. Press the ~C~ key to enable combat mode. Once you are in combat mode press ~X~ to cycle between enemies. When you are adjacent to an enemy, you will automatically attack.")
	ib:AddMsg("\n\nTo use ~magic~, click ~Spells~ in the top-right corner and find the spell you'd like to use. Select it, then assign it to a ~hotkey~ by pressing any of ~F1~ through ~F8~. Now press enter, and note the spell appears on the left side of the scren in the ~ready skills~ panel.")
	ib:AddMsg("\n\nOnce you've readied the spell, press ~Ctrl~ and a direction to cast the spell in that direction. Spells which are cast upon yourself will work in any direction. Using spells will lower your ~Mana~ so keep an eye on it.")
	ib:AddMsg("\n\n~Prayer~ works exactly the same as ~magic~, but the player must first apply an altar to worship a deity. ~Prayers~ are generally more focused on healing and buffs. They use ~Grace~ instead of ~Mana~ to cast, as well.")

	ib:SetLHSButton(base_button, base_topic)
end

local function topic_tutorial()
	ib:SetHeader("st_001", "")
	ib:SetTitle("First steps")

	ib:SetMsg("\n\nYou may be wondering, 'what do I do first?'")
	ib:AddMsg("\n\nYou should start by talking to ~Fanrir~ the NPC next to the docks where you started playing. He will provide you with quests and items to get you started.")
	ib:AddMsg("\n\nOnce you've completed his quests, you can either explore on your own, or talk to other NPC's throughout ~Guild Hall~ for more quests. There are many NPC's, quests, items, and skills throughout the world to help you on your journey.")

	ib:SetLHSButton(base_button, base_topic)
end

local function topic_controls()
	ib:SetHeader("st_001", "")
	ib:SetTitle("Controls")

	ib:SetMsg("\n\nThe following are the basic controls which will help you interact with the Daimonin game world.")
	ib:AddMsg("\n\n`Format: Name (default key) - Function`")
	ib:AddMsg("\n\nApply (~A~) - Interact with the currently-selected object. This will equip or consume items, open chests or corpses, etc.")
	ib:AddMsg("\n\nDrop (~D~) - Move an item from your inventory to the ground (or a chest if there is one open on the ground).")
	ib:AddMsg("\n\nGet (~G~) - Pick up an item from the ground or a chest, or move an item from your inventory to a container in your inventory.")
	ib:AddMsg("\n\nExamine (~E~) - Tells you the stats of the selected item.")
	ib:AddMsg("\n\nTalk (~T~) - Communicate with the targeted NPC, or if one is not targeted, the nearest NPC.")
	ib:AddMsg("\n\nRest (~R~) - Exit combat mode and rest. This will restore HP, Mana, and Grace at a faster rate than normal.")
	ib:AddMsg("\n\nTarget friendly (~S~) - Target the nearest friendly NPC or player. Pressing this multiple times will cycle through all nearby friendly NPC's or players.")
	ib:AddMsg("\n\nLock (~L~) - Locks an item selected in your inventory. This makes it unable to be dropped until you unlock it by pressing the same key.")
	ib:AddMsg("\n\nTarget enemy (~X~) - Target the nearest enemy NPC or player. Pressing this multiple times will cycle through all nearby enemy NPC's or players.")
	ib:AddMsg("\n\nMark (~M~) - Marks an item in your inventory for special purposes. An action which requires you to mark an item will tell you to mark an item.")
	ib:AddMsg("\n\nMain menu (~Esc~) - Opens up the main menu, which can be used to log out, change settings, or change keybindings.")
	ib:AddMsg("\n\nTo open your inventory, press and hold the ~Shift~ key or click the backpack icon. You can scroll through selected items with the ~arrow keys~. If your inventory is not open, the ~arrow keys~ will scroll through items in the ~Below Window~.")

	ib:AddLink("Movement", "/help movement")
	ib:AddLink("Changing keybindings", "/help keybindings")
	ib:SetLHSButton(base_button, base_topic)
end

local function topic_keybindings()
	ib:SetHeader("st_001", "")
	ib:SetTitle("Keybindings")

	ib:SetMsg("\n\nTo modify your keybindings (which can be particularly useful for players using keyboards without a number pad), either press ~F11~ or press ~Esc~ and scroll with the ~arrow keys~ to the ~Key Settings~ option.")
	ib:AddMsg("\n\nYou can scroll through this menu to find all of the game's key bindings. To modify a binding, select it with the mouse or the arrow keys and press ~Enter~ twice and press the key you'd like to bind that action to.")
	ib:AddMsg("\n\nYou can even create a new keybinding (which is primarily useful for chat macros) by clicking an empty slot, pressing ~Enter~, typing the command you'd like to bind, pressing ~Enter~, and pressing the key you'd like to bind that action to.")

	ib:SetLHSButton(base_button, base_topic)
end


tl:AddTopics("/help basics", topic_basics)
tl:AddTopics("/help movement", topic_movement)
tl:AddTopics("/help talking", topic_talking)
tl:AddTopics("/help combat", topic_combat)
tl:AddTopics("/help controls", topic_controls)
tl:AddTopics("/help keybindings", topic_keybindings)
tl:AddTopics("/help first steps", topic_tutorial)