/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing;

import java.time.Instant;
import java.util.Collections;
import org.gradle.api.NonNullApi;
import org.gradle.api.internal.tasks.testing.DefaultTestFailure;
import org.gradle.api.internal.tasks.testing.DefaultTestFailureDetails;
import org.gradle.api.internal.tasks.testing.DefaultTestOutputEvent;
import org.gradle.api.internal.tasks.testing.TestCompleteEvent;
import org.gradle.api.internal.tasks.testing.TestDescriptorInternal;
import org.gradle.api.internal.tasks.testing.TestResultState;
import org.gradle.api.internal.tasks.testing.TestStartEvent;
import org.gradle.api.internal.tasks.testing.results.DefaultTestResult;
import org.gradle.api.internal.tasks.testing.results.TestListenerInternal;
import org.gradle.api.tasks.testing.TestEventReporter;
import org.gradle.api.tasks.testing.TestFailureDetails;
import org.gradle.api.tasks.testing.TestOutputEvent;
import org.gradle.api.tasks.testing.TestResult;

@NonNullApi
class DefaultTestEventReporter
implements TestEventReporter {
    protected final TestListenerInternal listener;
    protected final TestDescriptorInternal testDescriptor;
    protected final TestResultState testResultState;
    private long startTime;

    DefaultTestEventReporter(TestListenerInternal listener, TestDescriptorInternal testDescriptor, TestResultState testResultState) {
        this.listener = listener;
        this.testDescriptor = testDescriptor;
        this.testResultState = testResultState;
    }

    protected boolean isComposite() {
        return false;
    }

    @Override
    public void started(Instant startTime) {
        if (!this.isComposite()) {
            this.testResultState.incrementTotalCount();
        }
        this.startTime = startTime.toEpochMilli();
        this.listener.started(this.testDescriptor, new TestStartEvent(startTime.toEpochMilli(), this.testDescriptor.getParent() == null ? null : this.testDescriptor.getParent().getId()));
    }

    @Override
    public void output(Instant logTime, TestOutputEvent.Destination destination, String output) {
        this.listener.output(this.testDescriptor, (TestOutputEvent)new DefaultTestOutputEvent(logTime.toEpochMilli(), destination, output));
    }

    @Override
    public void succeeded(Instant endTime) {
        if (!this.isComposite()) {
            this.testResultState.incrementSuccessfulCount();
        }
        this.listener.completed(this.testDescriptor, new DefaultTestResult(TestResult.ResultType.SUCCESS, this.startTime, endTime.toEpochMilli(), this.testResultState.getTotalCount(), this.testResultState.getSuccessfulCount(), this.testResultState.getFailureCount(), Collections.emptyList()), new TestCompleteEvent(endTime.toEpochMilli(), TestResult.ResultType.SUCCESS));
    }

    @Override
    public void skipped(Instant endTime) {
        this.listener.completed(this.testDescriptor, new DefaultTestResult(TestResult.ResultType.SKIPPED, this.startTime, endTime.toEpochMilli(), this.testResultState.getTotalCount(), this.testResultState.getSuccessfulCount(), this.testResultState.getFailureCount(), Collections.emptyList()), new TestCompleteEvent(endTime.toEpochMilli(), TestResult.ResultType.SKIPPED));
    }

    @Override
    public void failed(Instant endTime, String message, String additionalContent) {
        if (!this.isComposite()) {
            this.testResultState.incrementFailureCount();
        }
        DefaultTestFailureDetails failureDetails = new DefaultTestFailureDetails(message, Throwable.class.getName(), additionalContent, true, false, null, null, null, null);
        DefaultTestFailure testFailure = new DefaultTestFailure(new Throwable(message), (TestFailureDetails)failureDetails, Collections.emptyList());
        this.listener.completed(this.testDescriptor, new DefaultTestResult(TestResult.ResultType.FAILURE, this.startTime, endTime.toEpochMilli(), this.testResultState.getTotalCount(), this.testResultState.getSuccessfulCount(), this.testResultState.getFailureCount(), Collections.singletonList(testFailure)), new TestCompleteEvent(endTime.toEpochMilli(), TestResult.ResultType.FAILURE));
    }

    @Override
    public void close() {
    }

    public String toString() {
        return "reporter for " + this.testDescriptor.getDisplayName();
    }
}

