/*
 * Decompiled with CFR 0.152.
 */
package jrm.ui.progress;

import JTrrntzip.LogCallback;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.UIManager;
import javax.swing.border.BevelBorder;
import jrm.locale.Messages;
import jrm.ui.progress.ProgressHandler;
import org.apache.commons.lang3.time.DurationFormatUtils;

public class Progress
extends JDialog
implements ProgressHandler {
    private JPanel panel;
    private JLabel[] lblInfo;
    private JLabel[] lblSubInfo;
    private Map<Long, Integer> threadId_Offset = new HashMap<Long, Integer>();
    private final JProgressBar progressBar;
    private boolean cancel = false;
    private final JLabel lblTimeleft;
    private final JButton btnCancel;
    private long startTime = 0L;
    private final JProgressBar progressBar2;
    private final JLabel lblTimeLeft2;
    private long startTime2 = 0L;

    public Progress(final Window owner) {
        super(owner, Messages.getString("Progress.Title"), Dialog.ModalityType.MODELESS);
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(Progress.class.getResource("/jrm/resources/rom.png")));
        this.getContentPane().setBackground(UIManager.getColor("Panel.background"));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                Progress.this.cancel = true;
            }

            @Override
            public void windowOpened(WindowEvent e) {
                owner.setEnabled(false);
                if (owner.getOwner() != null) {
                    owner.getOwner().setEnabled(false);
                }
            }

            @Override
            public void windowClosed(WindowEvent e) {
                owner.setEnabled(true);
                owner.toFront();
                if (owner.getOwner() != null) {
                    owner.getOwner().setEnabled(true);
                }
            }
        });
        this.setDefaultCloseOperation(0);
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{0, 0, 0};
        gridBagLayout.rowHeights = new int[]{30, 0, 0, 0, 0};
        gridBagLayout.columnWeights = new double[]{1.0, 0.0, Double.MIN_VALUE};
        gridBagLayout.rowWeights = new double[]{1.0, 0.0, 0.0, 1.0, Double.MIN_VALUE};
        this.getContentPane().setLayout(gridBagLayout);
        this.panel = new JPanel();
        GridBagConstraints gbc_panel = new GridBagConstraints();
        gbc_panel.insets = new Insets(5, 5, 5, 5);
        gbc_panel.gridwidth = 2;
        gbc_panel.fill = 1;
        gbc_panel.gridx = 0;
        gbc_panel.gridy = 0;
        this.getContentPane().add((Component)this.panel, gbc_panel);
        this.panel.setLayout(new GridLayout(0, 1, 5, 5));
        this.setInfos(1, false);
        this.progressBar = new JProgressBar();
        this.progressBar.setMaximumSize(new Dimension(Short.MAX_VALUE, 20));
        this.progressBar.setMinimumSize(new Dimension(300, 20));
        this.progressBar.setPreferredSize(new Dimension(450, 20));
        GridBagConstraints gbc_progressBar = new GridBagConstraints();
        gbc_progressBar.fill = 2;
        gbc_progressBar.insets = new Insets(0, 5, 5, 5);
        gbc_progressBar.gridx = 0;
        gbc_progressBar.gridy = 1;
        this.getContentPane().add((Component)this.progressBar, gbc_progressBar);
        this.lblTimeleft = new JLabel("--:--:--");
        GridBagConstraints gbc_lblTimeleft = new GridBagConstraints();
        gbc_lblTimeleft.insets = new Insets(0, 0, 5, 5);
        gbc_lblTimeleft.gridx = 1;
        gbc_lblTimeleft.gridy = 1;
        this.getContentPane().add((Component)this.lblTimeleft, gbc_lblTimeleft);
        this.btnCancel = new JButton(Messages.getString("Progress.btnCancel.text"));
        this.btnCancel.setIcon(new ImageIcon(Progress.class.getResource("/jrm/resources/icons/stop.png")));
        this.btnCancel.addActionListener(e -> this.cancel());
        this.progressBar2 = new JProgressBar();
        this.progressBar2.setMaximumSize(new Dimension(Short.MAX_VALUE, 20));
        this.progressBar2.setVisible(false);
        this.progressBar2.setPreferredSize(new Dimension(450, 20));
        this.progressBar2.setMinimumSize(new Dimension(300, 20));
        GridBagConstraints gbc_progressBar2 = new GridBagConstraints();
        gbc_progressBar2.fill = 2;
        gbc_progressBar2.insets = new Insets(0, 5, 0, 5);
        gbc_progressBar2.gridx = 0;
        gbc_progressBar2.gridy = 2;
        this.getContentPane().add((Component)this.progressBar2, gbc_progressBar2);
        this.lblTimeLeft2 = new JLabel("--:--:--");
        this.lblTimeLeft2.setVisible(false);
        GridBagConstraints gbc_lblTimeLeft2 = new GridBagConstraints();
        gbc_lblTimeLeft2.fill = 3;
        gbc_lblTimeLeft2.insets = new Insets(0, 0, 0, 5);
        gbc_lblTimeLeft2.gridx = 1;
        gbc_lblTimeLeft2.gridy = 2;
        this.getContentPane().add((Component)this.lblTimeLeft2, gbc_lblTimeLeft2);
        GridBagConstraints gbc_btnCancel = new GridBagConstraints();
        gbc_btnCancel.weighty = 200.0;
        gbc_btnCancel.insets = new Insets(5, 5, 5, 5);
        gbc_btnCancel.gridwidth = 2;
        gbc_btnCancel.anchor = 15;
        gbc_btnCancel.gridx = 0;
        gbc_btnCancel.gridy = 3;
        this.getContentPane().add((Component)this.btnCancel, gbc_btnCancel);
        this.pack();
        this.setLocationRelativeTo(owner);
    }

    @Override
    public void setInfos(int threadCnt, boolean multipleSubInfos) {
        this.panel.removeAll();
        this.lblInfo = new JLabel[threadCnt];
        this.lblSubInfo = new JLabel[multipleSubInfos ? threadCnt : 1];
        this.threadId_Offset.clear();
        for (int i = 0; i < threadCnt; ++i) {
            this.lblInfo[i] = new JLabel();
            this.panel.add(this.lblInfo[i]);
            this.lblInfo[i].setPreferredSize(new Dimension(0, 20));
            this.lblInfo[i].setMinimumSize(new Dimension(0, 20));
            this.lblInfo[i].setBorder(new BevelBorder(1, null, null, null, null));
            if (!multipleSubInfos) continue;
            this.lblSubInfo[i] = new JLabel();
            this.panel.add(this.lblSubInfo[i]);
            this.lblSubInfo[i].setPreferredSize(new Dimension(0, 20));
            this.lblSubInfo[i].setMinimumSize(new Dimension(0, 20));
            this.lblSubInfo[i].setBorder(new BevelBorder(1, null, null, null, null));
        }
        if (!multipleSubInfos) {
            this.lblSubInfo[0] = new JLabel();
            this.panel.add(this.lblSubInfo[0]);
            this.lblSubInfo[0].setPreferredSize(new Dimension(0, 20));
            this.lblSubInfo[0].setMinimumSize(new Dimension(0, 20));
            this.lblSubInfo[0].setBorder(new BevelBorder(1, null, null, null, null));
        }
        this.packHeight();
    }

    @Override
    public void clearInfos() {
        for (JLabel label : this.lblInfo) {
            label.setText(null);
        }
        for (JLabel label : this.lblSubInfo) {
            label.setText(null);
        }
    }

    @Override
    public void setProgress(String msg) {
        this.setProgress(msg, null, null, null);
    }

    @Override
    public void setProgress(String msg, Integer val) {
        this.setProgress(msg, val, null, null);
    }

    @Override
    public void setProgress(String msg, Integer val, Integer max) {
        this.setProgress(msg, val, max, null);
    }

    @Override
    public synchronized void setProgress(String msg, Integer val, Integer max, String submsg) {
        if (!this.threadId_Offset.containsKey(Thread.currentThread().getId())) {
            if (this.threadId_Offset.size() < this.lblInfo.length) {
                this.threadId_Offset.put(Thread.currentThread().getId(), this.threadId_Offset.size());
            } else {
                this.threadId_Offset.put(Thread.currentThread().getId(), 0);
            }
        }
        int offset = this.threadId_Offset.get(Thread.currentThread().getId());
        if (msg != null) {
            this.lblInfo[offset].setText(msg);
        }
        if (val != null) {
            if (val < 0 && this.progressBar.isVisible()) {
                this.progressBar.setVisible(false);
                this.lblTimeleft.setVisible(false);
                this.packHeight();
            } else if (val > 0 && !this.progressBar.isVisible()) {
                this.progressBar.setVisible(true);
                this.lblTimeleft.setVisible(true);
                this.packHeight();
            }
            this.progressBar.setStringPainted(true);
            if (max != null) {
                this.progressBar.setMaximum(max);
            }
            if (val > 0) {
                this.progressBar.setValue(val);
            }
            if (val == 0) {
                this.startTime = System.currentTimeMillis();
            }
            if (val > 0) {
                String left = DurationFormatUtils.formatDuration((long)((System.currentTimeMillis() - this.startTime) * (long)(this.progressBar.getMaximum() - val) / (long)val.intValue()), (String)"HH:mm:ss");
                String total = DurationFormatUtils.formatDuration((long)((System.currentTimeMillis() - this.startTime) * (long)this.progressBar.getMaximum() / (long)val.intValue()), (String)"HH:mm:ss");
                this.lblTimeleft.setText(String.format("%s / %s", left, total));
            } else {
                this.lblTimeleft.setText("--:--:-- / --:--:--");
            }
        }
        if (this.lblSubInfo.length == 1) {
            this.lblSubInfo[0].setText(submsg);
        } else {
            this.lblSubInfo[offset].setText(submsg);
        }
    }

    @Override
    public boolean isCancel() {
        return this.cancel;
    }

    @Override
    public void cancel() {
        this.cancel = true;
        this.btnCancel.setEnabled(false);
        this.btnCancel.setText(Messages.getString("Progress.Canceling"));
    }

    @Override
    public void setProgress2(String msg, Integer val) {
        this.setProgress2(msg, val, null);
    }

    @Override
    public void setProgress2(String msg, Integer val, Integer max) {
        if (msg != null && val != null) {
            if (!this.progressBar2.isVisible()) {
                this.progressBar2.setVisible(true);
                this.lblTimeLeft2.setVisible(true);
                this.packHeight();
            }
            this.progressBar2.setStringPainted(true);
            this.progressBar2.setString(msg);
            if (max != null) {
                this.progressBar2.setMaximum(max);
            }
            if (val > 0) {
                this.progressBar2.setValue(val);
            }
            if (val == 0) {
                this.startTime2 = System.currentTimeMillis();
            }
            if (val > 0) {
                String left = DurationFormatUtils.formatDuration((long)((System.currentTimeMillis() - this.startTime2) * (long)(this.progressBar2.getMaximum() - val) / (long)val.intValue()), (String)"HH:mm:ss");
                String total = DurationFormatUtils.formatDuration((long)((System.currentTimeMillis() - this.startTime2) * (long)this.progressBar2.getMaximum() / (long)val.intValue()), (String)"HH:mm:ss");
                this.lblTimeLeft2.setText(String.format("%s / %s", left, total));
            } else {
                this.lblTimeLeft2.setText("--:--:-- / --:--:--");
            }
        } else if (this.progressBar2.isVisible()) {
            this.progressBar2.setVisible(false);
            this.lblTimeLeft2.setVisible(false);
            this.packHeight();
        }
    }

    public void packHeight() {
        Dimension newSize = this.getPreferredSize();
        Rectangle rect = this.getBounds();
        rect.height = Math.max(rect.height, newSize.height);
        this.setBounds(rect);
    }

    @Override
    public int getValue() {
        return this.progressBar.getValue();
    }

    @Override
    public int getValue2() {
        return this.progressBar2.getValue();
    }

    @Override
    public InputStream getInputStream(InputStream in, Integer len) {
        return new ProgressInputStream(in, len);
    }

    public final class ProgressInputStream
    extends FilterInputStream {
        private int value;

        protected ProgressInputStream(InputStream in, Integer len) {
            super(in);
            this.value = 0;
            Progress.this.setProgress(null, 0, len);
        }

        @Override
        public int read() throws IOException {
            int ret = super.read();
            if (ret != -1) {
                Progress.this.setProgress(null, ++this.value);
            }
            return ret;
        }

        @Override
        public int read(byte[] b) throws IOException {
            int ret = super.read(b);
            if (ret != -1) {
                Progress.this.setProgress(null, this.value += ret);
            }
            return ret;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int ret = super.read(b, off, len);
            if (ret != -1) {
                Progress.this.setProgress(null, this.value += ret);
            }
            return ret;
        }

        @Override
        public long skip(long n) throws IOException {
            long ret = super.skip(n);
            if (ret != -1L) {
                this.value = (int)((long)this.value + ret);
                Progress.this.setProgress(null, this.value);
            }
            return ret;
        }
    }

    public static final class ProgressTZipCallBack
    implements LogCallback {
        ProgressHandler ph;

        public ProgressTZipCallBack(ProgressHandler ph) {
            this.ph = ph;
        }

        @Override
        public void StatusCallBack(int percent) {
            this.ph.setProgress(null, null, null, String.format("<html><table cellpadding=2 cellspacing=0><tr><td valign='middle'><table cellpadding=0 cellspacing=0 style='width:%dpx;font-size:2px;border:1px solid gray'><tr><td style='width:%dpx;background:#ff00'><td></table><td>", 208, percent * 2));
        }

        @Override
        public boolean isVerboseLogging() {
            return false;
        }

        @Override
        public void StatusLogCallBack(String log) {
        }
    }
}

