/*
 * Decompiled with CFR 0.152.
 */
package one.util.streamex;

import java.util.BitSet;
import java.util.HashMap;
import java.util.LongSummaryStatistics;
import java.util.Map;
import java.util.Objects;
import java.util.OptionalDouble;
import java.util.OptionalLong;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.LongBinaryOperator;
import java.util.function.LongFunction;
import java.util.function.LongPredicate;
import java.util.function.LongUnaryOperator;
import java.util.function.ObjLongConsumer;
import java.util.function.Supplier;
import java.util.stream.Collector;
import one.util.streamex.MergingCollector;
import one.util.streamex.StreamExInternals;

public interface LongCollector<A, R>
extends MergingCollector<Long, A, R> {
    public ObjLongConsumer<A> longAccumulator();

    @Override
    default public BiConsumer<A, Long> accumulator() {
        return this.longAccumulator()::accept;
    }

    default public <RR> LongCollector<A, RR> andThen(Function<R, RR> finisher) {
        return LongCollector.of(this.supplier(), this.longAccumulator(), this.merger(), this.finisher().andThen(finisher));
    }

    public static <R> LongCollector<R, R> of(Supplier<R> supplier, ObjLongConsumer<R> longAccumulator, BiConsumer<R, R> merger) {
        return new StreamExInternals.LongCollectorImpl(supplier, longAccumulator, merger, Function.identity(), StreamExInternals.ID_CHARACTERISTICS);
    }

    public static <A, R> LongCollector<?, R> of(Collector<Long, A, R> collector) {
        if (collector instanceof LongCollector) {
            return (LongCollector)collector;
        }
        return LongCollector.mappingToObj(Long::valueOf, collector);
    }

    public static <A, R> LongCollector<A, R> of(Supplier<A> supplier, ObjLongConsumer<A> longAccumulator, BiConsumer<A, A> merger, Function<A, R> finisher) {
        return new StreamExInternals.LongCollectorImpl<A, R>(supplier, longAccumulator, merger, finisher, StreamExInternals.NO_CHARACTERISTICS);
    }

    public static LongCollector<?, String> joining(CharSequence delimiter, CharSequence prefix, CharSequence suffix) {
        return StreamExInternals.PartialCollector.joining(delimiter, prefix, suffix, true).asLong(StreamExInternals.joinAccumulatorLong(delimiter));
    }

    public static LongCollector<?, String> joining(CharSequence delimiter) {
        return StreamExInternals.PartialCollector.joining(delimiter, null, null, false).asLong(StreamExInternals.joinAccumulatorLong(delimiter));
    }

    public static LongCollector<?, Long> counting() {
        return StreamExInternals.PartialCollector.longSum().asLong((box, i) -> {
            box[0] = box[0] + 1L;
        });
    }

    public static LongCollector<?, Integer> countingInt() {
        return StreamExInternals.PartialCollector.intSum().asLong((box, i) -> {
            box[0] = box[0] + 1;
        });
    }

    public static LongCollector<?, Long> summing() {
        return StreamExInternals.PartialCollector.longSum().asLong((box, i) -> {
            box[0] = box[0] + i;
        });
    }

    public static LongCollector<?, OptionalDouble> averaging() {
        return LongCollector.of(StreamExInternals.AverageLong::new, StreamExInternals.AverageLong::accept, StreamExInternals.AverageLong::combine, StreamExInternals.AverageLong::result);
    }

    public static LongCollector<?, OptionalLong> min() {
        return LongCollector.reducing(Long::min);
    }

    public static LongCollector<?, OptionalLong> max() {
        return LongCollector.reducing(Long::max);
    }

    public static <A, R> LongCollector<?, R> mapping(LongUnaryOperator mapper, LongCollector<A, R> downstream) {
        ObjLongConsumer downstreamAccumulator = downstream.longAccumulator();
        return new StreamExInternals.LongCollectorImpl(downstream.supplier(), (r, t) -> downstreamAccumulator.accept(r, mapper.applyAsLong(t)), downstream.merger(), downstream.finisher(), downstream.characteristics());
    }

    public static <U, A, R> LongCollector<?, R> mappingToObj(LongFunction<U> mapper, Collector<U, A, R> downstream) {
        BiConsumer accumulator = downstream.accumulator();
        if (downstream instanceof MergingCollector) {
            return new StreamExInternals.LongCollectorImpl<Object, R>(downstream.supplier(), (acc, i) -> accumulator.accept(acc, mapper.apply(i)), ((MergingCollector)downstream).merger(), downstream.finisher(), downstream.characteristics());
        }
        return StreamExInternals.Box.partialCollector(downstream).asLong((box, i) -> accumulator.accept(box.a, mapper.apply(i)));
    }

    public static LongCollector<?, OptionalLong> reducing(LongBinaryOperator op) {
        return LongCollector.of(StreamExInternals.PrimitiveBox::new, (A box, long l) -> {
            if (!box.b) {
                box.b = true;
                box.l = l;
            } else {
                box.l = op.applyAsLong(box.l, l);
            }
        }, (A box1, A box2) -> {
            if (box2.b) {
                if (!box1.b) {
                    box1.from((StreamExInternals.PrimitiveBox)box2);
                } else {
                    box1.l = op.applyAsLong(box1.l, box2.l);
                }
            }
        }, StreamExInternals.PrimitiveBox::asLong);
    }

    public static LongCollector<?, Long> reducing(long identity, LongBinaryOperator op) {
        return LongCollector.of(() -> new long[]{identity}, (A box, long i) -> {
            box[0] = op.applyAsLong(box[0], i);
        }, (A box1, A box2) -> {
            box1[0] = op.applyAsLong(box1[0], box2[0]);
        }, StreamExInternals.UNBOX_LONG);
    }

    public static LongCollector<?, LongSummaryStatistics> summarizing() {
        return LongCollector.of(LongSummaryStatistics::new, LongSummaryStatistics::accept, LongSummaryStatistics::combine);
    }

    public static LongCollector<?, Map<Boolean, long[]>> partitioningBy(LongPredicate predicate) {
        return LongCollector.partitioningBy(predicate, LongCollector.toArray());
    }

    public static <A, D> LongCollector<?, Map<Boolean, D>> partitioningBy(LongPredicate predicate, LongCollector<A, D> downstream) {
        ObjLongConsumer downstreamAccumulator = downstream.longAccumulator();
        ObjLongConsumer<StreamExInternals.BooleanMap> accumulator = (result, t) -> downstreamAccumulator.accept(predicate.test(t) ? result.trueValue : result.falseValue, t);
        return StreamExInternals.BooleanMap.partialCollector(downstream).asLong(accumulator);
    }

    public static <K> LongCollector<?, Map<K, long[]>> groupingBy(LongFunction<? extends K> classifier) {
        return LongCollector.groupingBy(classifier, LongCollector.toArray());
    }

    public static <K, D, A> LongCollector<?, Map<K, D>> groupingBy(LongFunction<? extends K> classifier, LongCollector<A, D> downstream) {
        return LongCollector.groupingBy(classifier, HashMap::new, downstream);
    }

    public static <K, D, A, M extends Map<K, D>> LongCollector<?, M> groupingBy(LongFunction<? extends K> classifier, Supplier<M> mapFactory, LongCollector<A, D> downstream) {
        Supplier downstreamSupplier = downstream.supplier();
        Function<Object, Object> supplier = k -> downstreamSupplier.get();
        ObjLongConsumer downstreamAccumulator = downstream.longAccumulator();
        ObjLongConsumer<Map> accumulator = (m, t) -> {
            Object key = Objects.requireNonNull(classifier.apply(t));
            Object container = m.computeIfAbsent(key, supplier);
            downstreamAccumulator.accept(container, t);
        };
        return StreamExInternals.PartialCollector.grouping(mapFactory, downstream).asLong(accumulator);
    }

    public static LongCollector<?, long[]> toArray() {
        return LongCollector.of(StreamExInternals.LongBuffer::new, StreamExInternals.LongBuffer::add, StreamExInternals.LongBuffer::addAll, StreamExInternals.LongBuffer::toArray);
    }

    public static LongCollector<?, boolean[]> toBooleanArray(LongPredicate predicate) {
        return StreamExInternals.PartialCollector.booleanArray().asLong((box, t) -> {
            if (predicate.test(t)) {
                ((BitSet)box.a).set(box.b);
            }
            box.b = StrictMath.addExact(box.b, 1);
        });
    }
}

