/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.app.gui.application.document;

import com.jgoodies.app.gui.application.document.Document;
import com.jgoodies.app.gui.application.document.DocumentUtils;
import com.jgoodies.common.base.Preconditions;
import com.jgoodies.common.bean.Bean;
import com.jgoodies.common.internal.Collectors10;
import com.jgoodies.common.promise.Promise;
import com.jgoodies.common.swing.collect.ArrayListModel;
import com.jgoodies.dialogs.basics.StandardPaneBuilder;
import com.jgoodies.dialogs.core.CommandValue;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import javax.swing.ListModel;

public final class DocumentManager<D extends Document>
extends Bean {
    public static final String PROPERTY_ACTIVE_DOCUMENT = "activeDocument";
    public static final String PROPERTY_SAVE_ENABLED = "saveEnabled";
    private final ArrayListModel<D> documents = new ArrayListModel();
    private final PropertyChangeListener changedListener = this::onDocumentChange;
    private D activeDocument;

    public void register(D document) {
        Preconditions.checkNotNull(document, "The %s must not be null.", "document");
        Preconditions.checkArgument(!this.documents.contains(document), "The document must not be registered twice.");
        this.documents.add(document);
    }

    public void unregister(D document) {
        Preconditions.checkNotNull(document, "The %s must not be null.", "document");
        Preconditions.checkArgument(this.documents.contains(document), "To unregister the document it must be registered before.");
        this.documents.remove(document);
        if (document == this.activeDocument) {
            this.setActiveDocument(null);
        }
    }

    public D getActiveDocument() {
        return this.activeDocument;
    }

    public void setActiveDocument(D newDocument) {
        D oldDocument = this.activeDocument;
        if (oldDocument != null) {
            oldDocument.removePropertyChangeListener("changed", this.changedListener);
        }
        this.activeDocument = newDocument;
        if (newDocument != null) {
            newDocument.addPropertyChangeListener("changed", this.changedListener);
        }
        this.firePropertyChange(PROPERTY_ACTIVE_DOCUMENT, oldDocument, newDocument);
    }

    public List<D> getDocuments() {
        return Collections.unmodifiableList(this.documents);
    }

    public List<D> getChangedDocuments() {
        return this.documents.stream().filter(Document::isChanged).collect(Collectors10.toUnmodifiableList());
    }

    public boolean hasChangedDocuments() {
        return this.documents.stream().anyMatch(Document::isChanged);
    }

    public ListModel<D> getDocumentsModel() {
        return this.documents;
    }

    public boolean isCloseEnabled() {
        return this.activeDocument != null;
    }

    public Promise<Boolean> closeActiveDocument(EventObject evt) {
        Preconditions.checkState(this.activeDocument != null, "There must be an active document.");
        return DocumentUtils.reviewIfChanged(evt, this.activeDocument);
    }

    public Promise<Boolean> closeAllDocuments(EventObject evt) {
        ArrayList<D> copy = new ArrayList<D>(this.documents);
        copy.stream().filter(Document::isUnchanged).forEach(document -> document.closeDocument(evt));
        return this.closeAllUnsavedDocuments(evt);
    }

    private Promise<Boolean> closeAllUnsavedDocuments(EventObject evt) {
        block7: {
            CommandValue result;
            List<D> changedDocuments;
            block8: {
                block6: {
                    changedDocuments = this.getChangedDocuments();
                    if (changedDocuments.isEmpty()) {
                        return Promise.of(true);
                    }
                    if (changedDocuments.size() == 1) {
                        return DocumentUtils.reviewIfChanged(evt, (Document)changedDocuments.get(0));
                    }
                    result = ((StandardPaneBuilder)new StandardPaneBuilder().owner(evt)).showSaveAllChangesConfirmation(changedDocuments.size());
                    if (result == CommandValue.CANCEL) {
                        return Promise.of(false);
                    }
                    if (result != CommandValue.DISCARD_ALL_CHANGES) break block6;
                    for (Document document : changedDocuments) {
                        document.closeDocument(evt);
                    }
                    break block7;
                }
                if (result != CommandValue.SAVE_ALL_CHANGES) break block8;
                for (Document document : changedDocuments) {
                    document.saveDocument(evt);
                }
                break block7;
            }
            if (result != CommandValue.REVIEW_CHANGES) break block7;
            for (Document document : changedDocuments) {
                DocumentUtils.reviewIfChanged(evt, document);
            }
        }
        return Promise.of(true);
    }

    public boolean isSaveEnabled() {
        return this.activeDocument != null && this.activeDocument.isChanged();
    }

    public void saveActiveDocument(EventObject evt) {
        if (this.activeDocument != null) {
            this.activeDocument.saveDocument(evt);
        }
    }

    public void saveAllChangedDocuments(EventObject evt) {
        this.getChangedDocuments().forEach(document -> document.saveDocument(evt));
    }

    private void onDocumentChange(PropertyChangeEvent evt) {
        this.firePropertyChange(PROPERTY_SAVE_ENABLED, null, (Object)this.isSaveEnabled());
    }
}

