/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.common.jsdl.action;

import com.jgoodies.common.base.Preconditions;
import com.jgoodies.common.jsdl.action.ConsumerAction;
import com.jgoodies.common.jsdl.action.SplitAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Action;
import javax.swing.ActionMap;

public final class ActionGroup {
    private static final Object SEPARATOR = new StringBuilder("Separator");
    private final Action labelAction;
    private final List<Object> items;

    public ActionGroup() {
        this((Action)null);
    }

    public ActionGroup(String markedText) {
        this(ConsumerAction.noOp(Preconditions.checkNotBlank(markedText, "The %s must not be null, empty, or whitespace.", "marked text")));
    }

    public ActionGroup(Action labelAction) {
        this.labelAction = labelAction;
        this.items = new ArrayList<Object>();
    }

    public ActionGroup add(Action action) {
        Preconditions.checkNotNull(action, "The %s must not be null.", "action");
        this.items.add(action);
        return this;
    }

    public ActionGroup add(ActionMap actionMap, String ... actionNames) {
        Preconditions.checkNotNull(actionMap, "The %s must not be null.", "action map");
        Preconditions.checkNotNull(actionNames, "The %s must not be null.", "action names");
        for (String name : actionNames) {
            if (name == null || name.startsWith("---")) {
                this.addSeparator();
                continue;
            }
            Action action = actionMap.get(name);
            Preconditions.checkArgument(action != null, "No action found for name %s.", name);
            this.add(action);
        }
        return this;
    }

    public ActionGroup add(ActionGroup ... groups) {
        Preconditions.checkNotNull(groups, "The %s must not be null.", "group array");
        Collections.addAll(this.items, groups);
        return this;
    }

    public ActionGroup add(SplitAction splitAction) {
        Preconditions.checkNotNull(splitAction, "The %s must not be null.", "split action");
        this.items.add(splitAction);
        return this;
    }

    public ActionGroup addSeparator() {
        if (!this.lastAddedWasSeparator()) {
            this.items.add(SEPARATOR);
        }
        return this;
    }

    public boolean contains(Action action) {
        return this.items.contains(action);
    }

    public Action getLabelAction() {
        return this.labelAction;
    }

    public void build(ActionGroupBuilder builder) {
        builder.setLabelAction(this.getLabelAction());
        for (Object item : this.items) {
            if (item instanceof Action) {
                builder.add((Action)item);
                continue;
            }
            if (item instanceof ActionGroup) {
                builder.add((ActionGroup)item);
                continue;
            }
            if (item instanceof SplitAction) {
                builder.add((SplitAction)item);
                continue;
            }
            if (item == SEPARATOR) {
                builder.addSeparator();
                continue;
            }
            throw new IllegalStateException("Unknown item type " + item);
        }
    }

    private boolean lastAddedWasSeparator() {
        return !this.items.isEmpty() && this.items.get(this.items.size() - 1).equals(SEPARATOR);
    }

    public static interface ActionGroupBuilder {
        default public void setLabelAction(Action labelAction) {
        }

        public void add(Action var1);

        default public void add(ActionGroup group) {
            throw new UnsupportedOperationException("Adding a sub-group is not supported by this builder.");
        }

        default public void add(SplitAction splitAction) {
            throw new UnsupportedOperationException("Adding a split action is not supported by this builder.");
        }

        default public void addSeparator() {
            throw new UnsupportedOperationException("Adding a separator is not supported by this builder.");
        }
    }
}

