/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.common.jsdl.check;

import com.jgoodies.common.base.Preconditions;
import com.jgoodies.common.jsdl.check.SeverityLevel;
import com.jgoodies.common.jsdl.check.StyleCheck;
import com.jgoodies.common.jsdl.check.StyleChecker;
import java.util.HashMap;
import java.util.Map;

public final class StyleCheckConfiguration {
    private final StyleCheckConfiguration parent;
    private final Map<StyleCheck, SeverityLevel> map;

    public StyleCheckConfiguration(StyleCheckConfiguration parent) {
        this.parent = parent;
        this.map = new HashMap<StyleCheck, SeverityLevel>();
    }

    public SeverityLevel get(StyleCheck check) {
        Preconditions.checkNotNull(check, "The %s must not be null.", "style check");
        SeverityLevel level = this.map.get(check);
        if (level != null) {
            return level;
        }
        return this.parent != null ? this.parent.get(check) : SeverityLevel.IGNORE;
    }

    public SeverityLevel put(StyleCheck check, SeverityLevel level) {
        Preconditions.checkNotNull(check, "The %s must not be null.", "style check");
        Preconditions.checkNotNull(level, "The %s must not be null.", "severity level");
        return this.map.put(check, level);
    }

    public void restore() {
        StyleChecker.restore(this);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(super.toString()).append("\nSeverity levels:");
        this.map.forEach((check, level) -> builder.append("\n    ").append(check).append(" -> ").append(level));
        return builder.toString();
    }
}

