/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.components.internal;

import com.jgoodies.common.base.Preconditions;
import com.jgoodies.common.base.SystemUtils;
import com.jgoodies.components.JGCheckBoxList;
import com.jgoodies.layout.builder.FormBuilder;
import com.jgoodies.layout.factories.CC;
import java.awt.Component;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

public class JGCheckBoxListCellRenderer<E>
implements ListCellRenderer<E> {
    private final ListCellRenderer<E> delegate;
    private final JCheckBox checkBox;
    private final JComponent container;

    public JGCheckBoxListCellRenderer(ListCellRenderer<E> delegate) {
        this.delegate = delegate;
        this.checkBox = new JCheckBox();
        this.checkBox.setBorderPaintedFlat(true);
        this.container = this.buildPanel();
    }

    private JComponent buildPanel() {
        return ((FormBuilder)((FormBuilder)((FormBuilder)((FormBuilder)new FormBuilder().columns("1dlu, pref, 2dlu, fill:default:grow", new Object[0])).rows("p", new Object[0])).opaque(SystemUtils.isLafAqua())).add(this.checkBox).xy(2, 1)).build();
    }

    @Override
    public Component getListCellRendererComponent(JList<? extends E> list, E value, int index, boolean isSelected, boolean cellHasFocus) {
        Component rendererComponent = this.delegate.getListCellRendererComponent((JList<? extends E>)list, (E)value, index, isSelected, cellHasFocus);
        this.checkBox.setSelected(this.isIncluded(list, index));
        this.checkBox.setEnabled(list.isEnabled());
        if (SystemUtils.isLafAqua()) {
            this.container.setBackground(rendererComponent.getBackground());
        }
        if (this.container.getComponentCount() == 2) {
            this.container.remove(1);
        }
        this.container.add(rendererComponent, CC.xy(4, 1));
        return this.container;
    }

    protected boolean isIncluded(JList<? extends E> list, int index) {
        Preconditions.checkArgument(list instanceof JGCheckBoxList, "The JGCheckBoxListCellRender must be used only with JGCheckBoxLists.");
        JGCheckBoxList checkBoxList = (JGCheckBoxList)list;
        return checkBoxList.isIncluded(index);
    }
}

