/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.dialogs.basics;

import com.jgoodies.common.base.Preconditions;
import com.jgoodies.dialogs.basics.internal.JSDLBasicsUtils;
import com.jgoodies.dialogs.core.AspectRatio;
import com.jgoodies.dialogs.core.CommandValue;
import com.jgoodies.dialogs.core.MessageType;
import com.jgoodies.dialogs.core.PreferredWidth;
import com.jgoodies.dialogs.core.Verification;
import com.jgoodies.dialogs.core.internal.AbstractPaneBuilder;
import com.jgoodies.dialogs.core.internal.JSDLCoreStyleChecker;
import com.jgoodies.dialogs.core.pane.task.TaskPane;
import com.jgoodies.dialogs.core.pane.task.TaskPaneBuilder;
import java.util.Arrays;

public final class MessagePaneBuilder
extends AbstractPaneBuilder<TaskPane, MessagePaneBuilder> {
    private final TaskPaneBuilder builder = new TaskPaneBuilder();

    public MessagePaneBuilder() {
        this.builder.internalPreferredWidth(PreferredWidth.MEDIUM);
    }

    public MessagePaneBuilder mainInstructionText(String text, Object ... args) {
        this.builder.mainInstructionText(text, args);
        return this;
    }

    public MessagePaneBuilder supplementalInstructionText(String text, Object ... args) {
        this.builder.contentText(text, args);
        return this;
    }

    public MessagePaneBuilder verificationText(String text, Object ... args) {
        this.builder.verificationText(text, args);
        return this;
    }

    public MessagePaneBuilder verificationSelected(boolean b) {
        this.builder.verificationSelected(b);
        return this;
    }

    public MessagePaneBuilder verification(Verification verification) {
        this.builder.verification(verification);
        return this;
    }

    public MessagePaneBuilder preferredWidth(int customValue) {
        this.builder.preferredWidth(customValue);
        return this;
    }

    public MessagePaneBuilder preferredWidth(PreferredWidth standardizedValue) {
        this.builder.preferredWidth(standardizedValue);
        return this;
    }

    public MessagePaneBuilder aspectRatio(double customValue) {
        this.builder.aspectRatio(customValue);
        return this;
    }

    public MessagePaneBuilder aspectRatio(AspectRatio standardizedValue) {
        this.builder.aspectRatio(standardizedValue);
        return this;
    }

    public MessagePaneBuilder cancelAllowed(boolean b) {
        this.builder.cancelAllowed(b);
        return this;
    }

    public MessagePaneBuilder commandContentVisible(boolean b) {
        this.builder.commandContentVisible(b);
        return this;
    }

    public TaskPane buildAwarenessWarning() {
        this.builder.messageType(MessageType.WARNING);
        this.builder.commitCommands(CommandValue.CLOSE);
        this.checkStyle();
        return this.builder.build();
    }

    public TaskPane buildError() {
        this.builder.messageType(MessageType.ERROR);
        this.builder.commitCommands(CommandValue.CLOSE);
        this.checkStyle();
        return this.builder.build();
    }

    public TaskPane buildImminentProblem() {
        this.builder.messageType(MessageType.WARNING);
        this.builder.commitCommands(CommandValue.OK);
        this.builder.cancelAllowed(true);
        this.checkStyle();
        return this.builder.build();
    }

    public TaskPane buildRiskyActionConfirmation() {
        this.buildRiskyActionConfirmationImpl(new CommandValue[]{CommandValue.YES, CommandValue.NO}, null);
        this.builder.cancelCommand(CommandValue.NO);
        return this.builder.build();
    }

    public TaskPane buildRiskyActionConfirmation(Object ... commitObjects) {
        this.buildRiskyActionConfirmation((V[])commitObjects, (V)null);
        return this.builder.build();
    }

    public <V> TaskPane buildRiskyActionConfirmation(V[] commitObjects, V defaultCommitObject) {
        return this.buildRiskyActionConfirmationImpl(commitObjects, defaultCommitObject);
    }

    public TaskPane buildConfirmation() {
        this.buildConfirmationImpl(new CommandValue[]{CommandValue.YES, CommandValue.NO}, null);
        this.builder.cancelCommand(CommandValue.NO);
        return this.builder.build();
    }

    public TaskPane buildConfirmationDefaultNo() {
        this.buildConfirmationImpl(new CommandValue[]{CommandValue.YES, CommandValue.NO}, CommandValue.NO);
        this.builder.cancelCommand(CommandValue.NO);
        return this.builder.build();
    }

    public TaskPane buildConfirmation(Object ... commitObjects) {
        this.buildConfirmation((V[])commitObjects, (V)null);
        return this.builder.build();
    }

    public <V> TaskPane buildConfirmation(V[] commitObjects, V defaultCommitObject) {
        MessagePaneBuilder.checkValidCommitObjects(commitObjects, defaultCommitObject);
        return this.buildConfirmationImpl(commitObjects, defaultCommitObject);
    }

    public TaskPane buildInformation() {
        this.builder.messageType(MessageType.INFORMATION);
        this.builder.commitCommands(CommandValue.CLOSE);
        this.checkStyle();
        return this.builder.build();
    }

    public TaskPane buildHelp() {
        this.builder.messageType(MessageType.HELP);
        this.builder.commitCommands(CommandValue.CLOSE);
        this.checkStyle();
        return this.builder.build();
    }

    public void showError() {
        this.showDialog(this.buildError());
    }

    public void showAwarenessWarning() {
        this.showDialog(this.buildAwarenessWarning());
    }

    public void showImminentProblem() {
        this.showDialog(this.buildImminentProblem());
    }

    public boolean showRiskyActionConfirmation() {
        return this.showDialogReturnProceed(this.buildRiskyActionConfirmation());
    }

    public <V> V showRiskyActionConfirmation(V ... commitObjects) {
        return (V)this.showDialogReturnCommitValue(this.buildRiskyActionConfirmation((Object[])commitObjects));
    }

    public <V> V showRiskyActionConfirmation(V[] commitObjects, V defaultCommitObject) {
        MessagePaneBuilder.checkValidCommitObjects(commitObjects, defaultCommitObject);
        return (V)this.showDialogReturnCommitValue(this.buildRiskyActionConfirmation(commitObjects, defaultCommitObject));
    }

    public boolean showConfirmationReturnProceed() {
        return this.showDialogReturnProceed(this.buildConfirmation());
    }

    public boolean showConfirmationDefaultNoReturnProceed() {
        return this.showDialogReturnProceed(this.buildConfirmationDefaultNo());
    }

    public <V> V showConfirmation(V ... commitObjects) {
        return (V)this.showDialogReturnCommitValue(this.buildConfirmation((Object[])commitObjects));
    }

    public <V> V showConfirmation(V[] commitObjects, V defaultCommitObject) {
        return (V)this.showDialogReturnCommitValue(this.buildConfirmation(commitObjects, defaultCommitObject));
    }

    public void showInformation() {
        this.showDialog(this.buildInformation());
    }

    public void showHelp() {
        this.modal(false);
        this.showDialog(this.buildHelp());
    }

    @Override
    protected String getTitle() {
        if (this.title == null) {
            this.title = JSDLBasicsUtils.getApplicationTitle();
        }
        return this.title;
    }

    private <V> TaskPane buildRiskyActionConfirmationImpl(V[] commitObjects, V defaultCommitObject) {
        this.builder.messageType(MessageType.QUESTION_CRITICAL).commitCommands(commitObjects).defaultCommand(defaultCommitObject != null ? defaultCommitObject : commitObjects[commitObjects.length - 1]);
        this.checkStyle();
        return this.builder.build();
    }

    private <V> TaskPane buildConfirmationImpl(V[] commitObjects, V defaultCommitObject) {
        this.builder.messageType(MessageType.QUESTION).commitCommands(commitObjects).defaultCommand(defaultCommitObject);
        this.checkStyle();
        return this.builder.build();
    }

    private void checkStyle() {
        MessagePaneBuilder.checkMainInstructionNotBlank(this.builder.build().getMainInstructionText());
        MessagePaneBuilder.checkSupplementalInstructionNullOrNotBlank(this.builder.build().getContentText());
    }

    private static void checkMainInstructionNotBlank(String mainInstruction) {
        Preconditions.checkNotBlank(mainInstruction, "The %s must not be null, empty, or whitespace.", "main instruction");
    }

    private static void checkSupplementalInstructionNullOrNotBlank(String supplementalInstruction) {
        if (supplementalInstruction != null) {
            Preconditions.checkNotBlank(supplementalInstruction, "The supplemental instruction must not be empty, or whitespace.");
        }
        JSDLCoreStyleChecker.getInstance().checkSupplementalInstructionIsTrimmed(supplementalInstruction);
    }

    private static void checkValidCommitObjects(Object[] commitObjects, Object defaultCommitObject) {
        Preconditions.checkNotNull(commitObjects, "The %s must not be null.", "proceed commit objects");
        Preconditions.checkArgument(commitObjects.length >= 2, "There must be at least two commit objects.");
        for (Object commitObject : commitObjects) {
            Preconditions.checkArgument(commitObject instanceof CommandValue || commitObject instanceof String, "The commit object %s must be a CommandValue or String.", commitObject.toString());
        }
        int last = commitObjects.length - 1;
        Preconditions.checkArgument(commitObjects[last] == CommandValue.CANCEL || commitObjects[last] == CommandValue.CLOSE, "The last commit object must be Cancel or Close.");
        if (defaultCommitObject != null && !Arrays.asList(commitObjects).contains(defaultCommitObject)) {
            StringBuilder builder = new StringBuilder();
            builder.append(MessagePaneBuilder.printString(commitObjects[0]));
            for (int i = 1; i < commitObjects.length; ++i) {
                builder.append(", ");
                builder.append(MessagePaneBuilder.printString(commitObjects[i]));
            }
            throw new IllegalArgumentException(String.format("The default commit object %1$s must be one of: %2$s", MessagePaneBuilder.printString(defaultCommitObject), builder.toString()));
        }
    }

    private static String printString(Object commitObject) {
        if (commitObject instanceof CommandValue) {
            return "CommandValue(" + ((CommandValue)commitObject).getText() + ")";
        }
        return commitObject.toString();
    }
}

