/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.dialogs.core.pane.property;

import com.jgoodies.common.base.Strings;
import com.jgoodies.components.JGComponentFactory;
import com.jgoodies.dialogs.core.internal.BasicPropertyPaneBuilder;
import com.jgoodies.dialogs.core.pane.property.ListPropertyPane;
import com.jgoodies.layout.builder.FormBuilder;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.text.JTextComponent;

public final class ListPropertyPaneBuilder
extends BasicPropertyPaneBuilder<ListPropertyPane, ListPropertyPaneBuilder> {
    public Adder beginTab() {
        return new Adder(this);
    }

    @Override
    protected ListPropertyPane createPane() {
        return new ListPropertyPane();
    }

    void addTab(String tabText, String tabTitle, JComponent tabComponent) {
        ((ListPropertyPane)this.pane).addTabImpl(tabText, tabTitle, tabComponent);
    }

    public static final class Adder {
        private final ListPropertyPaneBuilder builder;
        private String text;
        private String title;
        private EmptyBorder padding;
        private boolean paddingSet;
        private JComponent content;

        Adder(ListPropertyPaneBuilder builder) {
            this.builder = builder;
        }

        public Adder text(String plainText, Object ... args) {
            this.text = Strings.get(plainText, args);
            return this;
        }

        public Adder title(String markedTitle, Object ... args) {
            this.title = Strings.get(markedTitle, args);
            return this;
        }

        public Adder padding(EmptyBorder padding) {
            this.padding = padding;
            this.paddingSet = true;
            return this;
        }

        public Adder content(JComponent tabContent) {
            this.content = tabContent;
            return this;
        }

        public Adder content(String text, Object ... args) {
            JGComponentFactory factory = JGComponentFactory.getCurrent();
            JTextComponent staticText = factory.createStaticText(text, args);
            JPanel content = ((FormBuilder)((FormBuilder)((FormBuilder)((FormBuilder)new FormBuilder().columns("fill:pref:grow", new Object[0])).rows("p", new Object[0])).opaque(false)).add(staticText).xy(1, 1)).build();
            return this.content(content);
        }

        public ListPropertyPaneBuilder endTab() {
            if (this.paddingSet) {
                this.content.setBorder(this.padding);
            }
            this.builder.addTab(this.text, this.title, this.content);
            return this.builder;
        }
    }

    public static final class TabAdder {
        private final ListPropertyPaneBuilder builder;
        private final String tabText;
        private String tabTitle;
        private EmptyBorder padding;
        private boolean paddingSet;

        TabAdder(ListPropertyPaneBuilder builder, String tabText) {
            this.builder = builder;
            this.tabText = tabText;
        }

        public TabAdder title(String title, Object ... args) {
            this.tabTitle = Strings.get(title, args);
            return this;
        }

        public TabAdder padding(EmptyBorder padding) {
            this.padding = padding;
            this.paddingSet = true;
            return this;
        }

        public ListPropertyPaneBuilder content(JComponent tabContent) {
            if (this.paddingSet) {
                tabContent.setBorder(this.padding);
            }
            this.builder.addTab(this.tabText, this.tabTitle, tabContent);
            return this.builder;
        }
    }
}

