/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.dialogs.core.style;

import com.jgoodies.common.base.SystemUtils;
import com.jgoodies.dialogs.core.style.Style;
import com.jgoodies.dialogs.core.style.StylePolicy;
import com.jgoodies.dialogs.core.style.basic.GenericStyle;
import com.jgoodies.dialogs.core.style.mac.AquaStyle;
import com.jgoodies.dialogs.core.style.windows.WindowsClassicStyle;
import com.jgoodies.dialogs.core.style.windows.WindowsMetroStyle;
import javax.swing.LookAndFeel;

public final class StylePolicies {
    private StylePolicies() {
    }

    public static StylePolicy createFixedPolicy(Style style) {
        return new FixedPolicy(style);
    }

    public static StylePolicy getDefaultPolicy() {
        return new DefaultPolicy();
    }

    private static final class DefaultPolicy
    implements StylePolicy {
        private DefaultPolicy() {
        }

        @Override
        public Style getStyle(LookAndFeel laf) {
            if (laf.getID().equals("Aqua")) {
                return new AquaStyle();
            }
            if (laf.getID().equals("Plastic")) {
                return new WindowsMetroStyle();
            }
            if (!laf.getID().equals("Windows")) {
                return new GenericStyle();
            }
            if (!SystemUtils.IS_LAF_WINDOWS_XP_ENABLED) {
                return new WindowsClassicStyle();
            }
            return new WindowsMetroStyle();
        }
    }

    private static final class FixedPolicy
    implements StylePolicy {
        private final Style style;

        FixedPolicy(Style style) {
            this.style = style;
        }

        @Override
        public Style getStyle(LookAndFeel laf) {
            return this.style;
        }
    }
}

