/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.fluent.tabs;

import com.jgoodies.common.base.Preconditions;
import com.jgoodies.common.base.Strings;
import com.jgoodies.common.bean.Bean;
import com.jgoodies.common.display.IconDisplayable;
import com.jgoodies.common.promise.Promise;
import com.jgoodies.fluent.tabs.Pinnable;
import com.jgoodies.navigation.NavigationEventArgs;
import com.jgoodies.navigation.NavigationMode;
import com.jgoodies.navigation.Page;
import com.jgoodies.navigation.PageFrame;
import com.jgoodies.navigation.PageModel;
import com.jgoodies.navigation.TabFeatures;
import com.jgoodies.navigation.internal.BackStack;
import com.jgoodies.navigation.internal.FocusTrackerSupport;
import com.jgoodies.navigation.internal.LazyValue;
import com.jgoodies.navigation.views.Activatable;
import com.jgoodies.navigation.views.FocusTracker;
import com.jgoodies.navigation.views.View;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.EventObject;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.swing.Icon;
import javax.swing.JComponent;

public interface Tab
extends TabFeatures,
View,
Activatable {
    public static final int DEFAULT_PINNED_PREFERRED_TAB_WIDTH = 48;
    public static final String PROPERTY_ICON = "icon";
    public static final String PROPERTY_TITLE = "title";
    public static final String PROPERTY_TOOL_TIP_TEXT = "toolTipText";
    public static final String PROPERTY_PINNED_ICON = "pinnedIcon";
    public static final String PROPERTY_PINNED_TITLE = "pinnedTitle";
    public static final String PROPERTY_CLOSEABLE = "closeable";
    public static final String PROPERTY_PINNED = "pinned";

    public Icon getIcon();

    public String getTitle();

    default public String getToolTipText() {
        return this.getTitle();
    }

    default public int getPreferredTabWidth() {
        return -1;
    }

    default public boolean isPinned() {
        return false;
    }

    default public Icon getPinnedIcon() {
        return this.getIcon();
    }

    default public String getPinnedTitle() {
        return this.getTitle();
    }

    default public int getPinnedPreferredTabWidth() {
        return -1;
    }

    public Object getId();

    default public Object getOpenerTabId() {
        return null;
    }

    default public boolean isCloseable() {
        return this.isCloseEnabled() && !this.isPinned();
    }

    public Promise<Boolean> onClosing(EventObject var1);

    default public void onClosed(EventObject evt) {
    }

    public void onContextMenuRequested(MouseEvent var1);

    public static class DefaultFrameTab
    extends DefaultTab
    implements BackStack {
        private final PageModel pageModel;
        private final PropertyChangeListener tabDataChangeListener = this::onCurrentPageTabDataChanged;
        private static final int MAX_LENGHT_PINNED_TITLE = 3;

        protected DefaultFrameTab() {
            this(new PageModel());
        }

        protected DefaultFrameTab(PageModel pageModel) {
            this.pageModel = pageModel;
            this.setId(this::getDefaultTabId);
            this.setCloseEnabled(true);
            this.setPreferredTabWidth(200);
            this.setPanel(this::buildPanel);
            this.initEventHandling();
        }

        @Override
        public final Page getCurrentPage() {
            return this.pageModel.getCurrentPage();
        }

        @Override
        public final Page getPreviousPage() {
            return this.pageModel.getPreviousPage();
        }

        public final List<Page> getPages() {
            return this.pageModel.getPages();
        }

        @Override
        public final boolean canGoBack() {
            return this.pageModel.canGoBack();
        }

        @Override
        public final Promise<Boolean> goBack(EventObject evt) {
            return this.pageModel.goBack(evt);
        }

        public final Promise<Boolean> navigate(EventObject evt, Page page) {
            return this.pageModel.navigate(evt, page);
        }

        public Promise<Boolean> navigate(EventObject evt, Page page, Object params) {
            return this.pageModel.navigate(evt, page, params);
        }

        public final void initialPage(Page page, Object params) {
            this.pageModel.initialPage(page, params);
        }

        public final void refreshCurrentPage() {
            this.pageModel.refreshCurrentPage();
        }

        public final void refreshCurrentPage(Object params) {
            this.pageModel.refreshCurrentPage(params);
        }

        private void initEventHandling() {
            this.getPageModel().addPropertyChangeListener("currentPage", this::onCurrentPageChanged);
            this.getPageModel().addPropertyChangeListener("canGoBack", this::onCanGoBackChanged);
        }

        protected void onCurrentPageChanged(PropertyChangeEvent evt) {
            Page oldPage = (Page)evt.getOldValue();
            Page newPage = (Page)evt.getNewValue();
            if (oldPage instanceof Page.AbstractPage) {
                ((Page.AbstractPage)oldPage).removePropertyChangeListener("displayString", this.tabDataChangeListener);
            }
            if (newPage instanceof Page.AbstractPage) {
                ((Page.AbstractPage)newPage).addPropertyChangeListener("displayString", this.tabDataChangeListener);
            }
            this.firePropertyChange(Tab.PROPERTY_ICON, null, this.getIcon());
            this.firePropertyChange(Tab.PROPERTY_TITLE, null, this.getTitle());
            this.firePropertyChange(Tab.PROPERTY_PINNED_ICON, null, this.getPinnedIcon());
            this.firePropertyChange(Tab.PROPERTY_PINNED_TITLE, null, this.getPinnedTitle());
            this.firePropertyChange("currentPage", evt.getOldValue(), evt.getNewValue());
        }

        private void onCanGoBackChanged(PropertyChangeEvent evt) {
            this.firePropertyChange("canGoBack", evt.getOldValue(), evt.getNewValue());
        }

        private void onCurrentPageTabDataChanged(PropertyChangeEvent evt) {
            this.firePropertyChange(Tab.PROPERTY_TITLE, null, this.getTitle());
        }

        @Override
        public void onActivating() {
            if (this.getCurrentPage() instanceof Activatable) {
                ((Activatable)((Object)this.getCurrentPage())).onActivating();
            }
        }

        @Override
        public void onActivated() {
            if (this.getCurrentPage() instanceof Activatable) {
                ((Activatable)((Object)this.getCurrentPage())).onActivated();
            }
        }

        @Override
        public void onDeactivating() {
            if (this.getCurrentPage() instanceof Activatable) {
                ((Activatable)((Object)this.getCurrentPage())).onDeactivating();
            }
        }

        @Override
        public Promise<Boolean> onClosing(EventObject evt) {
            if (this.getPageModel().canGoBack()) {
                return this.getPageModel().goBack(evt).thenCompose(success -> success != false ? this.onClosing(evt) : Promise.of(false));
            }
            NavigationEventArgs backArgs = new NavigationEventArgs(evt, this.getCurrentPage(), null, NavigationMode.BACK);
            return this.getCurrentPage().onNavigatingFrom(backArgs).thenApply(accepted -> {
                if (accepted.booleanValue()) {
                    this.getCurrentPage().onNavigatedFrom(backArgs);
                }
                return accepted;
            });
        }

        @Override
        protected Icon getDefaultIcon() {
            return this.getPageIcon();
        }

        @Override
        protected String getDefaultTitle() {
            return this.getPageDisplayString();
        }

        @Override
        protected String getDefaultPinnedTitle() {
            Page currentPage = this.getCurrentPage();
            if (currentPage instanceof Pinnable) {
                return ((Pinnable)((Object)currentPage)).getPinnedTitle();
            }
            return this.getAbbreviatedUppercasePageDisplayString(3);
        }

        protected JComponent buildPanel() {
            return new PageFrame(this.getPageModel());
        }

        protected final PageModel getPageModel() {
            return this.pageModel;
        }

        protected final Object getDefaultTabId() {
            Page currentPage = this.getCurrentPage();
            return currentPage instanceof TabIdProvider ? ((TabIdProvider)((Object)currentPage)).getTabId() : Integer.valueOf(currentPage != null ? currentPage.hashCode() : this.hashCode());
        }

        protected final Icon getPageIcon() {
            Page currentPage = this.getCurrentPage();
            return currentPage instanceof IconDisplayable ? ((IconDisplayable)((Object)currentPage)).getIcon() : null;
        }

        protected final String getPageDisplayString() {
            Page currentPage = this.getCurrentPage();
            return currentPage != null ? currentPage.getDisplayString() : null;
        }

        protected final String getAbbreviatedUppercasePageDisplayString(int maxLength) {
            String display = this.getPageDisplayString();
            return display != null ? display.substring(0, Math.min(3, display.length())).toUpperCase() : null;
        }

        @Override
        protected String paramString() {
            return super.paramString() + ", " + this.pageModel;
        }

        public static interface TabIdProvider {
            public Object getTabId();
        }
    }

    public static class DefaultTab
    extends Bean
    implements Tab,
    FocusTracker {
        private final LazyValue<JComponent> panelHolder = new LazyValue();
        private final FocusTrackerSupport focusTrackerSupport = new FocusTrackerSupport();
        private Icon icon;
        private String title;
        private String toolTipText;
        private int preferredTabWidth = -1;
        private boolean pinned = false;
        private Icon pinnedIcon;
        private String pinnedTitle;
        private int pinnedPreferredTabWidth = 48;
        private Supplier<Object> idSupplier = this::hashCode;
        private Object openerTabId;
        private boolean closeEnabled = true;
        private boolean refreshEnabled = true;
        private boolean duplicateEnabled = false;
        private boolean moveToWindowEnabled = true;
        private boolean pinEnabled = true;
        private boolean addToFavoritesEnabled = false;
        private Function<EventObject, Promise<Boolean>> closingHandler;
        private Consumer<MouseEvent> contextMenuHandler;

        protected DefaultTab() {
        }

        @Override
        public final Icon getIcon() {
            return !this.isPinned() ? (this.icon != null ? this.icon : this.getDefaultIcon()) : (this.pinnedIcon != null ? this.pinnedIcon : this.getDefaultPinnedIcon());
        }

        public final void setIcon(Icon newValue) {
            this.icon = newValue;
            this.firePropertyChange(Tab.PROPERTY_ICON, this.icon, this.icon);
        }

        @Override
        public final String getTitle() {
            return !this.isPinned() ? (this.title != null ? this.title : this.getDefaultTitle()) : (this.pinnedTitle != null ? this.pinnedTitle : this.getDefaultPinnedTitle());
        }

        public final void setTitle(String newValue) {
            this.title = newValue;
            this.firePropertyChange(Tab.PROPERTY_TITLE, this.title, this.title);
        }

        @Override
        public String getToolTipText() {
            return this.toolTipText != null ? this.toolTipText : this.getDefaultToolTipText();
        }

        public final void setToolTipText(String newValue) {
            this.toolTipText = newValue;
            this.firePropertyChange(Tab.PROPERTY_TOOL_TIP_TEXT, this.toolTipText, this.toolTipText);
        }

        @Override
        public boolean isPinned() {
            return this.pinned;
        }

        public final void setPinned(boolean pinned) {
            this.pinned = pinned;
            this.firePropertyChange(Tab.PROPERTY_PINNED, this.pinned, this.pinned);
            this.firePropertyChange(Tab.PROPERTY_CLOSEABLE, null, (Object)this.isCloseable());
            this.firePropertyChange(Tab.PROPERTY_ICON, null, this.getIcon());
            this.firePropertyChange(Tab.PROPERTY_TITLE, null, this.getTitle());
        }

        @Override
        public final Icon getPinnedIcon() {
            return this.pinnedIcon;
        }

        public final void setPinnedIcon(Icon newValue) {
            this.pinnedIcon = newValue;
            this.firePropertyChange(Tab.PROPERTY_PINNED_ICON, this.pinnedIcon, this.pinnedIcon);
        }

        @Override
        public final String getPinnedTitle() {
            return this.pinnedTitle;
        }

        public final void setPinnedTitle(String newValue) {
            this.pinnedTitle = newValue;
            this.firePropertyChange(Tab.PROPERTY_PINNED_TITLE, this.pinnedTitle, this.pinnedTitle);
        }

        @Override
        public final JComponent getPanel() {
            return this.panelHolder.get();
        }

        public final void setPanel(JComponent panel) {
            this.setPanel(() -> panel);
        }

        public final void setPanel(Supplier<JComponent> panelSupplier) {
            Preconditions.checkNotNull(panelSupplier, "The %s must not be null.", "panel supplier");
            this.panelHolder.set(panelSupplier);
        }

        @Override
        public final Object getId() {
            return this.idSupplier.get();
        }

        public final void setId(Object id) {
            this.setId(() -> id);
        }

        public final void setId(Supplier<Object> idSupplier) {
            this.idSupplier = Preconditions.checkNotNull(idSupplier, "The %s must not be null.", "id supplier");
        }

        @Override
        public boolean isCloseEnabled() {
            return this.closeEnabled;
        }

        public final void setCloseEnabled(boolean closeEnabled) {
            this.closeEnabled = closeEnabled;
            this.firePropertyChange("closeEnabled", this.closeEnabled, this.closeEnabled);
            this.firePropertyChange(Tab.PROPERTY_CLOSEABLE, null, (Object)this.isCloseable());
        }

        @Override
        public boolean isRefreshEnabled() {
            return this.refreshEnabled;
        }

        public final void setRefreshEnabled(boolean refreshEnabled) {
            this.refreshEnabled = refreshEnabled;
            this.firePropertyChange("refreshEnabled", this.refreshEnabled, this.refreshEnabled);
        }

        @Override
        public boolean isDuplicateEnabled() {
            return this.duplicateEnabled;
        }

        public final void setDuplicateEnabled(boolean duplicateEnabled) {
            this.duplicateEnabled = duplicateEnabled;
            this.firePropertyChange("duplicateEnabled", this.duplicateEnabled, this.duplicateEnabled);
        }

        @Override
        public boolean isMoveToWindowEnabled() {
            return this.moveToWindowEnabled;
        }

        public final void setMoveToWindowEnabled(boolean moveToWindowEnabled) {
            this.moveToWindowEnabled = moveToWindowEnabled;
            this.firePropertyChange("moveToWindowEnabled", this.moveToWindowEnabled, this.moveToWindowEnabled);
        }

        @Override
        public boolean isPinEnabled() {
            return this.pinEnabled;
        }

        public final void setPinEnabled(boolean pinEnabled) {
            this.pinEnabled = pinEnabled;
            this.firePropertyChange("pinEnabled", this.pinEnabled, this.pinEnabled);
        }

        @Override
        public boolean isAddToFavoritesEnabled() {
            return this.addToFavoritesEnabled;
        }

        public final void setAddToFavoritesEnabled(boolean addToFavoritesEnabled) {
            this.addToFavoritesEnabled = addToFavoritesEnabled;
            this.firePropertyChange("addToFavoritesEnabled", this.addToFavoritesEnabled, this.addToFavoritesEnabled);
        }

        @Override
        public Object getOpenerTabId() {
            return this.openerTabId;
        }

        public final void setOpenerTabId(Object value) {
            this.openerTabId = value;
        }

        @Override
        public int getPreferredTabWidth() {
            return this.isPinned() ? this.pinnedPreferredTabWidth : this.preferredTabWidth;
        }

        public final void setPreferredTabWidth(int effectivePixels) {
            this.preferredTabWidth = effectivePixels;
        }

        @Override
        public int getPinnedPreferredTabWidth() {
            return this.pinnedPreferredTabWidth;
        }

        public final void setPinnedPreferredTabWidth(int effectivePixels) {
            this.pinnedPreferredTabWidth = effectivePixels;
        }

        @Override
        public Promise<Boolean> onClosing(EventObject evt) {
            return this.closingHandler != null ? this.closingHandler.apply(evt) : Promise.of(true);
        }

        public final void setOnClosing(Function<EventObject, Promise<Boolean>> closingHandler) {
            this.closingHandler = closingHandler;
        }

        @Override
        public void onContextMenuRequested(MouseEvent evt) {
            if (this.contextMenuHandler != null) {
                this.contextMenuHandler.accept(evt);
            }
        }

        public final void setOnContextMenuRequested(Consumer<MouseEvent> contextMenuHandler) {
            this.contextMenuHandler = contextMenuHandler;
        }

        @Override
        public void onActivating() {
        }

        @Override
        public void onActivated() {
        }

        @Override
        public void onDeactivating() {
        }

        @Override
        public final void requestInitialFocus() {
            this.focusTrackerSupport.requestInitialFocus(this.getPanel());
        }

        @Override
        public final void setMostRecentFocusOwner(Component newFocusOwner) {
            if (!this.panelHolder.isEvaluated()) {
                return;
            }
            this.focusTrackerSupport.setMostRecentFocusOwner(this.getPanel(), newFocusOwner);
        }

        protected Icon getDefaultIcon() {
            return null;
        }

        protected String getDefaultTitle() {
            return this.title;
        }

        protected String getDefaultToolTipText() {
            return this.getDefaultTitle();
        }

        protected Icon getDefaultPinnedIcon() {
            return null;
        }

        protected String getDefaultPinnedTitle() {
            return Strings.isNotBlank(this.pinnedTitle) ? this.pinnedTitle : this.getDefaultTitle();
        }

        public String toString() {
            return this.getClass().getSimpleName() + '@' + Integer.toHexString(this.hashCode()) + '[' + this.paramString() + ']';
        }

        protected String paramString() {
            return String.format("icon=%s, title=%s, openerTabId=%s, preferredTabWidth=%s, hasClosingHandler=%s, close=%s, refresh=%s, duplicate=%s, moveToWindow=%s, pin=%s, addToFavorites=%s, pinned=%s, pinnedTitle=%s, pinnedPreferredTabWidth=%s", this.icon, this.title, this.openerTabId, this.preferredTabWidth, this.closingHandler != null, DefaultTab.toEnabled(this.closeEnabled), DefaultTab.toEnabled(this.refreshEnabled), DefaultTab.toEnabled(this.duplicateEnabled), DefaultTab.toEnabled(this.moveToWindowEnabled), DefaultTab.toEnabled(this.pinEnabled), DefaultTab.toEnabled(this.addToFavoritesEnabled), this.pinned, this.pinnedTitle, this.pinnedPreferredTabWidth);
        }

        private static String toEnabled(boolean b) {
            return b ? "enabled" : "disabled";
        }
    }
}

