/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.layout.builder;

import com.jgoodies.common.base.Preconditions;
import com.jgoodies.common.base.Strings;
import com.jgoodies.common.internal.BuilderSupport;
import com.jgoodies.common.swing.focus.FocusTraversalUtils;
import com.jgoodies.layout.FormsSetup;
import com.jgoodies.layout.debug.FormDebugPanel;
import com.jgoodies.layout.factories.CC;
import com.jgoodies.layout.factories.ComponentFactory;
import com.jgoodies.layout.factories.Forms;
import com.jgoodies.layout.factories.Paddings;
import com.jgoodies.layout.internal.InternalFocusSetupUtils;
import com.jgoodies.layout.layout.CellConstraints;
import com.jgoodies.layout.layout.ColumnSpec;
import com.jgoodies.layout.layout.FormLayout;
import com.jgoodies.layout.layout.LayoutMap;
import com.jgoodies.layout.layout.RowSpec;
import com.jgoodies.layout.util.FocusTraversalType;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.FocusTraversalPolicy;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.border.Border;

public class AbstractFormBuilder<B extends AbstractFormBuilder<B>> {
    private static final String LABELED_BY_PROPERTY = "labeledBy";
    private final BuilderSupport support = new BuilderSupport();
    private LayoutMap layoutMap;
    private ColumnSpec[] columnSpecs;
    private RowSpec[] rowSpecs;
    private FormLayout layout;
    private JPanel panel;
    private JComponent initialComponent;
    private FocusTraversalType focusTraversalType;
    private FocusTraversalPolicy focusTraversalPolicy;
    private boolean debug;
    private int offsetX = 0;
    private int offsetY = 0;
    private boolean labelForFeatureEnabled;
    private LabelType defaultLabelType = LabelType.DEFAULT;
    private ComponentFactory factory;
    private WeakReference<JLabel> mostRecentlyAddedLabelReference = null;

    protected AbstractFormBuilder() {
        this.labelForFeatureEnabled = FormsSetup.getLabelForFeatureEnabledDefault();
    }

    public JPanel build() {
        return this.getPanel();
    }

    public B layoutMap(LayoutMap layoutMap) {
        this.support.checkNotCalledTwice("layoutMap");
        this.layoutMap = layoutMap;
        return (B)this;
    }

    public B columns(String encodedColumnSpecs, Object ... args) {
        this.support.checkNotCalledTwice("columns");
        this.columnSpecs = ColumnSpec.decodeSpecs(Strings.get(encodedColumnSpecs, args), this.getLayoutMap());
        return (B)this;
    }

    public B columns(ColumnSpec ... columnSpecs) {
        this.support.checkNotCalledTwice("columns");
        this.columnSpecs = Preconditions.checkNotNull(columnSpecs, "The %s must not be null.", "column specifications");
        return (B)this;
    }

    public B appendColumns(String encodedColumnSpecs, Object ... args) {
        ColumnSpec[] newColumnSpecs;
        for (ColumnSpec columnSpec : newColumnSpecs = ColumnSpec.decodeSpecs(Strings.get(encodedColumnSpecs, args), this.getLayoutMap())) {
            this.getLayout().appendColumn(columnSpec);
        }
        return (B)this;
    }

    public B rows(String encodedRowSpecs, Object ... args) {
        this.support.checkNotCalledTwice("rows");
        this.rowSpecs = RowSpec.decodeSpecs(Strings.get(encodedRowSpecs, args), this.getLayoutMap());
        return (B)this;
    }

    public B rows(RowSpec ... rowSpecs) {
        this.support.checkNotCalledTwice("rows");
        this.rowSpecs = Preconditions.checkNotNull(rowSpecs, "The %s must not be null.", "row specifications");
        return (B)this;
    }

    public B appendRows(String encodedRowSpecs, Object ... args) {
        RowSpec[] newRowSpecs;
        for (RowSpec rowSpec : newRowSpecs = RowSpec.decodeSpecs(Strings.get(encodedRowSpecs, args), this.getLayoutMap())) {
            this.getLayout().appendRow(rowSpec);
        }
        return (B)this;
    }

    public B columnGroup(int ... columnIndices) {
        this.support.checkNotCalledTwice("columnGroup or #columnGroups");
        this.getLayout().setColumnGroup(columnIndices);
        return (B)this;
    }

    public B columnGroups(int[] ... multipleColumnGroups) {
        this.support.checkNotCalledTwice("columnGroup or #columnGroups");
        this.getLayout().setColumnGroups(multipleColumnGroups);
        return (B)this;
    }

    public B rowGroup(int ... rowIndices) {
        this.support.checkNotCalledTwice("rowGroup or #rowGroups");
        this.getLayout().setRowGroup(rowIndices);
        return (B)this;
    }

    public B rowGroups(int[] ... multipleRowGroups) {
        this.support.checkNotCalledTwice("rowGroup or #rowGroups");
        this.getLayout().setRowGroups(multipleRowGroups);
        return (B)this;
    }

    public B honorsVisibility(boolean b) {
        this.support.checkNotCalledTwice("honorsVisibility");
        this.getLayout().setHonorsVisibility(b);
        return (B)this;
    }

    public B honorsVisibility(JComponent c, boolean b) {
        this.getLayout().setHonorsVisibility(c, b);
        return (B)this;
    }

    public B layout(FormLayout layout) {
        this.support.checkNotCalledTwice("layout");
        this.layout = Preconditions.checkNotNull(layout, "The %s must not be null.", "layout");
        return (B)this;
    }

    public B panel(JPanel panel) {
        this.support.checkNotCalledTwice("panel");
        this.panel = Preconditions.checkNotNull(panel, "The %s must not be null.", "panel");
        this.panel.setLayout(this.getLayout());
        return (B)this;
    }

    public B debug(boolean b) {
        this.support.checkNotCalledTwice("debug");
        this.debug = b;
        return (B)this;
    }

    public B name(String panelName) {
        this.support.checkNotCalledTwice("name");
        this.getPanel().setName(panelName);
        return (B)this;
    }

    public B background(Color background) {
        this.support.checkNotCalledTwice("background");
        this.getPanel().setBackground(background);
        this.getPanel().setOpaque(background != null);
        return (B)this;
    }

    public B border(Border border) {
        this.support.checkNotCalledTwice("border or #padding");
        this.getPanel().setBorder(border);
        return (B)this;
    }

    public B padding(Paddings.Padding padding) {
        return this.border(padding);
    }

    public B padding(String paddingSpec, Object ... args) {
        return this.padding(Paddings.createPadding(paddingSpec, args));
    }

    public B opaque(boolean b) {
        this.support.checkNotCalledTwice("opaque");
        this.getPanel().setOpaque(b);
        return (B)this;
    }

    public B initialComponent(JComponent initialComponent) {
        this.support.checkNotCalledTwice("initialComponent");
        this.checkValidFocusTraversalSetup();
        this.initialComponent = initialComponent;
        this.setupFocusTraversalPolicyAndProvider();
        return (B)this;
    }

    public B focusTraversalType(FocusTraversalType focusTraversalType) {
        this.support.checkNotCalledTwice("focusTraversalType or #focusTraversalPolicy");
        Preconditions.checkNotNull(focusTraversalType, "The %s must not be null.", "focus traversal type");
        this.checkValidFocusTraversalSetup();
        this.focusTraversalType = focusTraversalType;
        this.setupFocusTraversalPolicyAndProvider();
        return (B)this;
    }

    public B focusTraversalPolicy(FocusTraversalPolicy policy) {
        this.support.checkNotCalledTwice("focusTraversalType or #focusTraversalPolicy");
        Preconditions.checkNotNull(policy, "The %s must not be null.", "focus traversal policy");
        this.checkValidFocusTraversalSetup();
        this.focusTraversalPolicy = policy;
        this.setupFocusTraversalPolicyAndProvider();
        return (B)this;
    }

    public B focusGroup(AbstractButton ... buttons) {
        FocusTraversalUtils.group(buttons);
        return (B)this;
    }

    public B focusGroup(List<AbstractButton> buttons) {
        FocusTraversalUtils.group(buttons);
        return (B)this;
    }

    public FormLayout getLayout() {
        if (this.layout != null) {
            return this.layout;
        }
        Preconditions.checkNotNull(this.columnSpecs, "The layout columns must be specified.");
        Preconditions.checkNotNull(this.rowSpecs, "The layout rows must be specified.");
        this.layout = new FormLayout(this.columnSpecs, this.rowSpecs);
        return this.layout;
    }

    public JPanel getPanel() {
        if (this.panel == null) {
            this.panel = this.debug ? new FormDebugPanel() : new JPanel(null);
            this.panel.setOpaque(FormsSetup.getOpaqueDefault());
        }
        return this.panel;
    }

    public B factory(ComponentFactory factory) {
        this.support.checkNotCalledTwice("factory");
        this.factory = factory;
        return (B)this;
    }

    public B labelForFeatureEnabled(boolean b) {
        this.support.checkNotCalledTwice("labelForFeatureEnabled");
        this.labelForFeatureEnabled = b;
        return (B)this;
    }

    public B offset(int offsetX, int offsetY) {
        this.offsetX = offsetX;
        this.offsetY = offsetY;
        return (B)this;
    }

    public B translate(int dX, int dY) {
        this.offsetX += dX;
        this.offsetY += dY;
        return (B)this;
    }

    public B defaultLabelType(LabelType newValue) {
        this.defaultLabelType = newValue;
        return (B)this;
    }

    public B readOnlyLabels() {
        return this.defaultLabelType(LabelType.READ_ONLY);
    }

    public B doWith(Consumer<B> consumer) {
        consumer.accept(this);
        return (B)this;
    }

    public ComponentAdder<B> add(Component c) {
        return this.add(true, c);
    }

    public ComponentAdder<B> addRaw(Component c) {
        return this.addRaw(true, c);
    }

    public ComponentAdder<B> addScrolled(Component c) {
        return this.addScrolled(true, c);
    }

    public ComponentAdder<B> addBar(JButton ... buttons) {
        return this.addBar(true, buttons);
    }

    public ComponentAdder<B> addBar(JCheckBox ... checkBoxes) {
        return this.addBar(true, checkBoxes);
    }

    public ComponentAdder<B> addBar(JRadioButton ... radioButtons) {
        return this.addBar(true, radioButtons);
    }

    public ComponentAdder<B> addStack(JButton ... buttons) {
        return this.addStack(true, buttons);
    }

    public ComponentAdder<B> addStack(JCheckBox ... checkBoxes) {
        return this.addStack(true, checkBoxes);
    }

    public ComponentAdder<B> addStack(JRadioButton ... radioButtons) {
        return this.addStack(true, radioButtons);
    }

    public RendererAdder<B> add(Consumer<B> renderer) {
        return this.add(true, renderer);
    }

    public ComponentAdder<B> add(String markedLabelText, Object ... args) {
        return this.add(true, markedLabelText, args);
    }

    public ComponentAdder<B> addLabel(String markedText, Object ... args) {
        return this.addLabel(true, markedText, args);
    }

    public ComponentAdder<B> addROLabel(String markedText, Object ... args) {
        return this.addROLabel(true, markedText, args);
    }

    public ComponentAdder<B> addTitle(String markedText, Object ... args) {
        return this.addTitle(true, markedText, args);
    }

    public ComponentAdder<B> addSeparator() {
        return this.addSeparator(true, "", new Object[0]);
    }

    public ComponentAdder<B> addSeparator(String markedText, Object ... args) {
        return this.addSeparator(true, markedText, args);
    }

    public ComponentAdder<B> add(Icon image) {
        return this.add(true, image);
    }

    public ComponentAdder<B> add(boolean expression, Component c) {
        if (!expression || c == null) {
            return new NoOpComponentAdder<AbstractFormBuilder>(this);
        }
        if (c instanceof JTable || c instanceof JList || c instanceof JTree) {
            return this.addScrolled(expression, c);
        }
        return this.addRaw(expression, c);
    }

    public ComponentAdder<B> addRaw(boolean expression, Component c) {
        if (!expression || c == null) {
            return new NoOpComponentAdder<AbstractFormBuilder>(this);
        }
        return this.addImpl(c);
    }

    public ComponentAdder<B> addScrolled(boolean expression, Component c) {
        if (!expression || c == null) {
            return new NoOpComponentAdder<AbstractFormBuilder>(this);
        }
        return this.addImpl(new JScrollPane(c));
    }

    public ComponentAdder<B> addBar(boolean expression, JButton ... buttons) {
        if (!expression || buttons == null) {
            return new NoOpComponentAdder<AbstractFormBuilder>(this);
        }
        return this.addImpl(Forms.buttonBar(buttons));
    }

    public ComponentAdder<B> addBar(boolean expression, JCheckBox ... checkBoxes) {
        if (!expression) {
            return new NoOpComponentAdder<AbstractFormBuilder>(this);
        }
        return this.addImpl(Forms.checkBoxBar(checkBoxes));
    }

    public ComponentAdder<B> addBar(boolean expression, JRadioButton ... radioButtons) {
        if (!expression) {
            return new NoOpComponentAdder<AbstractFormBuilder>(this);
        }
        return this.addImpl(Forms.radioButtonBar(radioButtons));
    }

    public ComponentAdder<B> addStack(boolean expression, JButton ... buttons) {
        if (!expression || buttons == null) {
            return new NoOpComponentAdder<AbstractFormBuilder>(this);
        }
        return this.addImpl(Forms.buttonStack(buttons));
    }

    public ComponentAdder<B> addStack(boolean expression, JCheckBox ... checkBoxes) {
        if (!expression) {
            return new NoOpComponentAdder<AbstractFormBuilder>(this);
        }
        return this.addImpl(Forms.checkBoxStack(checkBoxes));
    }

    public ComponentAdder<B> addStack(boolean expression, JRadioButton ... radioButtons) {
        if (!expression || radioButtons == null) {
            return new NoOpComponentAdder<AbstractFormBuilder>(this);
        }
        return this.addImpl(Forms.radioButtonStack(radioButtons));
    }

    public RendererAdder<B> add(boolean expression, Consumer<B> renderer) {
        return new RendererAdder<AbstractFormBuilder>(this, expression, renderer);
    }

    public ComponentAdder<B> add(boolean expression, String markedLabelText, Object ... args) {
        return this.defaultLabelType == LabelType.DEFAULT ? this.addLabel(expression, markedLabelText, args) : this.addROLabel(expression, markedLabelText, args);
    }

    public ComponentAdder<B> addLabel(boolean expression, String markedText, Object ... args) {
        return this.addRaw(expression, this.getFactory().createLabel(Strings.get(markedText, args)));
    }

    public ComponentAdder<B> addROLabel(boolean expression, String markedText, Object ... args) {
        return this.addRaw(expression, this.getFactory().createReadOnlyLabel(Strings.get(markedText, args)));
    }

    public ComponentAdder<B> addTitle(boolean expression, String markedText, Object ... args) {
        String text = Strings.get(markedText, args);
        return this.addRaw(expression, this.getFactory().createTitle(text));
    }

    public ComponentAdder<B> addSeparator(boolean expression, String markedText, Object ... args) {
        int alignment = this.isLeftToRight() ? 2 : 4;
        String text = Strings.get(markedText, args);
        return this.addRaw(expression, this.getFactory().createSeparator(text, alignment));
    }

    public ComponentAdder<B> add(boolean expression, Icon image) {
        if (!expression || image == null) {
            return new NoOpComponentAdder<AbstractFormBuilder>(this);
        }
        return this.addImpl(new JLabel(image));
    }

    protected LayoutMap getLayoutMap() {
        if (this.layoutMap == null) {
            this.layoutMap = LayoutMap.getRoot();
        }
        return this.layoutMap;
    }

    protected ComponentFactory getFactory() {
        if (this.factory == null) {
            this.factory = FormsSetup.getComponentFactoryDefault();
        }
        return this.factory;
    }

    protected ComponentAdder<B> addImpl(Component c) {
        if (this.getPanel().getLayout() == null) {
            this.panel.setLayout(this.getLayout());
        }
        return new ComponentAdder<AbstractFormBuilder>(this, c);
    }

    void addImpl(Component component, CellConstraints rawConstraints) {
        CellConstraints translatedConstraints = rawConstraints.translate(this.offsetX, this.offsetY);
        this.getPanel().add(component, translatedConstraints);
        this.manageLabelsAndComponents(component);
    }

    private void manageLabelsAndComponents(Component c) {
        if (!this.labelForFeatureEnabled) {
            return;
        }
        if (c instanceof JLabel) {
            JLabel label = (JLabel)c;
            if (label.getLabelFor() == null) {
                this.setMostRecentlyAddedLabel(label);
            } else {
                this.clearMostRecentlyAddedLabel();
            }
            return;
        }
        JLabel mostRecentlyAddedLabel = this.getMostRecentlyAddedLabel();
        if (mostRecentlyAddedLabel != null && AbstractFormBuilder.isLabelForApplicable(mostRecentlyAddedLabel, c)) {
            AbstractFormBuilder.setLabelFor(mostRecentlyAddedLabel, c);
            this.clearMostRecentlyAddedLabel();
        }
    }

    private static boolean isLabelForApplicable(JLabel label, Component component) {
        if (label.getLabelFor() != null) {
            return false;
        }
        if (!component.isFocusable()) {
            return false;
        }
        if (!(component instanceof JComponent)) {
            return true;
        }
        JComponent c = (JComponent)component;
        return c.getClientProperty(LABELED_BY_PROPERTY) == null;
    }

    private static void setLabelFor(JLabel label, Component component) {
        Component labeledComponent;
        if (component instanceof JScrollPane) {
            JScrollPane scrollPane = (JScrollPane)component;
            labeledComponent = scrollPane.getViewport().getView();
        } else {
            labeledComponent = component;
        }
        label.setLabelFor(labeledComponent);
    }

    private JLabel getMostRecentlyAddedLabel() {
        return this.mostRecentlyAddedLabelReference == null ? null : (JLabel)this.mostRecentlyAddedLabelReference.get();
    }

    private void setMostRecentlyAddedLabel(JLabel label) {
        this.mostRecentlyAddedLabelReference = new WeakReference<JLabel>(label);
    }

    private void clearMostRecentlyAddedLabel() {
        this.mostRecentlyAddedLabelReference = null;
    }

    private boolean isLeftToRight() {
        ComponentOrientation orientation = this.getPanel().getComponentOrientation();
        return orientation.isLeftToRight() || !orientation.isHorizontal();
    }

    private void checkValidFocusTraversalSetup() {
        InternalFocusSetupUtils.checkValidFocusTraversalSetup(this.focusTraversalPolicy, this.focusTraversalType, this.initialComponent);
    }

    private void setupFocusTraversalPolicyAndProvider() {
        InternalFocusSetupUtils.setupFocusTraversalPolicyAndProvider(this.getPanel(), this.focusTraversalPolicy, this.focusTraversalType, this.initialComponent);
    }

    public static class ComponentAdder<T extends AbstractFormBuilder<T>> {
        protected final T builder;
        private final Component component;
        private boolean labelForSet;

        ComponentAdder(T builder, Component component) {
            this.builder = builder;
            this.component = component;
            this.labelForSet = false;
        }

        public final ComponentAdder<T> labelFor(Component c) {
            Preconditions.checkArgument(this.component instanceof JLabel, "#labelFor is applicable only to JLabels");
            Preconditions.checkArgument(!this.labelForSet, "You must set the label-for-relation only once.");
            ((JLabel)this.component).setLabelFor(c);
            this.labelForSet = true;
            return this;
        }

        public final T at(CellConstraints constraints) {
            return this.add(constraints);
        }

        public final T xy(int col, int row) {
            return this.at(CC.xy(col, row));
        }

        public final T xy(int col, int row, String encodedAlignments) {
            return this.at(CC.xy(col, row, encodedAlignments));
        }

        public final T xy(int col, int row, CellConstraints.Alignment colAlign, CellConstraints.Alignment rowAlign) {
            return this.at(CC.xy(col, row, colAlign, rowAlign));
        }

        public final T xyw(int col, int row, int colSpan) {
            return this.at(CC.xyw(col, row, colSpan));
        }

        public final T xyw(int col, int row, int colSpan, String encodedAlignments) {
            return this.at(CC.xyw(col, row, colSpan, encodedAlignments));
        }

        public final T xyw(int col, int row, int colSpan, CellConstraints.Alignment colAlign, CellConstraints.Alignment rowAlign) {
            return this.at(CC.xyw(col, row, colSpan, colAlign, rowAlign));
        }

        public final T xywh(int col, int row, int colSpan, int rowSpan) {
            return this.at(CC.xywh(col, row, colSpan, rowSpan));
        }

        public final T xywh(int col, int row, int colSpan, int rowSpan, String encodedAlignments) {
            return this.at(CC.xywh(col, row, colSpan, rowSpan, encodedAlignments));
        }

        public final T xywh(int col, int row, int colSpan, int rowSpan, CellConstraints.Alignment colAlign, CellConstraints.Alignment rowAlign) {
            return this.at(CC.xywh(col, row, colSpan, rowSpan, colAlign, rowAlign));
        }

        public final T rc(int row, int col) {
            return this.at(CC.rc(row, col));
        }

        public final T rc(int row, int col, String encodedAlignments) {
            return this.at(CC.rc(row, col, encodedAlignments));
        }

        public final T rc(int row, int col, CellConstraints.Alignment rowAlign, CellConstraints.Alignment colAlign) {
            return this.at(CC.rc(row, col, rowAlign, colAlign));
        }

        public final T rcw(int row, int col, int colSpan) {
            return this.at(CC.rcw(row, col, colSpan));
        }

        public final T rcw(int row, int col, int colSpan, String encodedAlignments) {
            return this.at(CC.rcw(row, col, colSpan, encodedAlignments));
        }

        public final T rcw(int row, int col, int colSpan, CellConstraints.Alignment rowAlign, CellConstraints.Alignment colAlign) {
            return this.at(CC.rcw(row, col, colSpan, rowAlign, colAlign));
        }

        public final T rchw(int row, int col, int rowSpan, int colSpan) {
            return this.at(CC.rchw(row, col, rowSpan, colSpan));
        }

        public final T rchw(int row, int col, int rowSpan, int colSpan, String encodedAlignments) {
            return this.at(CC.rchw(row, col, rowSpan, colSpan, encodedAlignments));
        }

        public final T rchw(int row, int col, int rowSpan, int colSpan, CellConstraints.Alignment rowAlign, CellConstraints.Alignment colAlign) {
            return this.at(CC.rchw(col, row, rowSpan, colSpan, colAlign, rowAlign));
        }

        protected T add(CellConstraints constraints) {
            ((AbstractFormBuilder)this.builder).addImpl(this.component, constraints);
            return this.builder;
        }
    }

    public static enum LabelType {
        DEFAULT,
        READ_ONLY;

    }

    private static final class NoOpComponentAdder<T extends AbstractFormBuilder<T>>
    extends ComponentAdder<T> {
        NoOpComponentAdder(T builder) {
            super(builder, null);
        }

        @Override
        protected T add(CellConstraints constraints) {
            return (T)this.builder;
        }
    }

    public static final class RendererAdder<T extends AbstractFormBuilder<T>> {
        private final T builder;
        private final boolean expression;
        private final Consumer<T> renderer;

        RendererAdder(T builder, boolean expression, Consumer<T> renderer) {
            this.builder = builder;
            this.expression = expression;
            this.renderer = renderer;
        }

        public T xy(int col, int row) {
            if (this.expression && this.renderer != null) {
                ((AbstractFormBuilder)this.builder).translate(col, row);
                this.renderer.accept(this.builder);
                ((AbstractFormBuilder)this.builder).translate(-col, -row);
            }
            return this.builder;
        }
    }
}

