/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.layout.builder;

import com.jgoodies.common.base.Preconditions;
import com.jgoodies.layout.internal.AbstractButtonPanelBuilder;
import com.jgoodies.layout.layout.ColumnSpec;
import com.jgoodies.layout.layout.ConstantSize;
import com.jgoodies.layout.layout.FormLayout;
import com.jgoodies.layout.layout.FormSpecs;
import com.jgoodies.layout.layout.RowSpec;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;

public final class ButtonStackBuilder
extends AbstractButtonPanelBuilder<ButtonStackBuilder> {
    private static final ColumnSpec[] COL_SPECS = new ColumnSpec[]{FormSpecs.BUTTON_COLSPEC};
    private static final RowSpec[] ROW_SPECS = new RowSpec[0];

    public ButtonStackBuilder() {
        this(new JPanel(null));
    }

    public ButtonStackBuilder(JPanel panel) {
        super(new FormLayout(COL_SPECS, ROW_SPECS), panel);
    }

    public ButtonStackBuilder addButton(JComponent button) {
        Preconditions.checkNotNull(button, "The %s must not be null.", "button to add");
        this.getLayout().appendRow(FormSpecs.PREF_ROWSPEC);
        this.add(button);
        this.nextRow();
        return this;
    }

    public ButtonStackBuilder addButton(JComponent ... buttons) {
        super.addButton(buttons);
        return this;
    }

    public ButtonStackBuilder addButton(Action ... actions) {
        super.addButton(actions);
        return this;
    }

    public ButtonStackBuilder addComponent(JComponent component) {
        Preconditions.checkNotNull(component, "The %s must not be null.", "component to add");
        this.getLayout().appendRow(FormSpecs.PREF_ROWSPEC);
        this.add(component);
        this.nextRow();
        return this;
    }

    public ButtonStackBuilder addGap(ConstantSize height) {
        this.getLayout().appendRow(new RowSpec(RowSpec.TOP, height, 0.0));
        this.nextRow();
        return this;
    }

    public ButtonStackBuilder addGrowingGap() {
        this.appendGrowingGapRow();
        this.nextRow();
        return this;
    }

    public ButtonStackBuilder addRelatedGap() {
        this.appendRelatedComponentsGapRow();
        this.nextRow();
        return this;
    }

    public ButtonStackBuilder addUnrelatedGap() {
        this.appendUnrelatedComponentsGapRow();
        this.nextRow();
        return this;
    }
}

