/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.layout.internal;

import com.jgoodies.common.base.Preconditions;
import com.jgoodies.layout.FormsSetup;
import com.jgoodies.layout.factories.ComponentFactory;
import com.jgoodies.layout.factories.Paddings;
import com.jgoodies.layout.layout.CellConstraints;
import com.jgoodies.layout.layout.FormLayout;
import java.awt.Color;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;

public abstract class AbstractBuilder<B extends AbstractBuilder<B>> {
    private final JPanel panel;
    private final FormLayout layout;
    protected final CellConstraints currentCellConstraints;
    private ComponentFactory componentFactory;

    protected AbstractBuilder(FormLayout layout, JPanel panel) {
        this.layout = Preconditions.checkNotNull(layout, "The %s must not be null.", "layout");
        this.panel = Preconditions.checkNotNull(panel, "The %s must not be null.", "panel");
        panel.setLayout(layout);
        this.currentCellConstraints = new CellConstraints();
    }

    public JPanel getPanel() {
        return this.panel;
    }

    public abstract JPanel build();

    public final FormLayout getLayout() {
        return this.layout;
    }

    public final int getColumnCount() {
        return this.getLayout().getColumnCount();
    }

    public final int getRowCount() {
        return this.getLayout().getRowCount();
    }

    public final B background(Color background) {
        this.getPanel().setBackground(background);
        this.opaque(true);
        return (B)this;
    }

    public final B border(Border border) {
        this.getPanel().setBorder(border);
        return (B)this;
    }

    public final B padding(EmptyBorder padding) {
        this.getPanel().setBorder(padding);
        return (B)this;
    }

    public final B padding(String paddingSpec, Object ... args) {
        this.padding(Paddings.createPadding(paddingSpec, args));
        return (B)this;
    }

    public final B opaque(boolean b) {
        this.getPanel().setOpaque(b);
        return (B)this;
    }

    public final ComponentFactory getComponentFactory() {
        if (this.componentFactory == null) {
            this.componentFactory = this.createComponentFactory();
        }
        return this.componentFactory;
    }

    public final void setComponentFactory(ComponentFactory newFactory) {
        this.componentFactory = newFactory;
    }

    protected ComponentFactory createComponentFactory() {
        return FormsSetup.getComponentFactoryDefault();
    }
}

