/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.navigation;

import com.jgoodies.navigation.NavigationMode;
import com.jgoodies.navigation.Page;
import java.util.EventObject;

public final class NavigationEventArgs {
    private final EventObject eventObject;
    private final Page sourcePage;
    private final Object parameter;
    private final NavigationMode mode;

    public NavigationEventArgs(EventObject eventObject, Page sourcePage, Object parameter, NavigationMode mode) {
        this.eventObject = eventObject;
        this.sourcePage = sourcePage;
        this.parameter = parameter;
        this.mode = mode;
    }

    public EventObject getEventObject() {
        return this.eventObject;
    }

    public Page getSourcePage() {
        return this.sourcePage;
    }

    public boolean isSourceType(Class<?> sourceType) {
        return this.sourcePage.getClass().isAssignableFrom(sourceType);
    }

    public Object getParameter() {
        return this.parameter;
    }

    public NavigationMode getMode() {
        return this.mode;
    }

    public boolean isModeBack() {
        return this.getMode() == NavigationMode.BACK;
    }

    public boolean isModeForward() {
        return this.getMode() == NavigationMode.FORWARD;
    }

    public boolean isModeNew() {
        return this.getMode() == NavigationMode.NEW;
    }

    public boolean isModeRefresh() {
        return this.getMode() == NavigationMode.REFRESH;
    }

    public Object getParameter(Object defaultValue) {
        return this.parameter != null ? this.parameter : defaultValue;
    }

    public Object getParameter(int index, Object defaultValue) {
        if (!(this.getParameter() instanceof Object[])) {
            return defaultValue;
        }
        Object[] params = (Object[])this.getParameter();
        if (params.length <= index) {
            return defaultValue;
        }
        return params[index];
    }

    public <T> T getParameter(int index, Class<T> type, T defaultValue) {
        if (!(this.getParameter() instanceof Object[])) {
            return defaultValue;
        }
        Object[] params = (Object[])this.getParameter();
        if (params.length <= index) {
            return defaultValue;
        }
        Object value = params[index];
        return (T)(type.isInstance(value) ? value : defaultValue);
    }

    public String toString() {
        return String.format("NavigationEventArgs [sourcePage=%s, parameter=%s, mode=%s]", new Object[]{this.sourcePage, this.parameter, this.mode});
    }
}

