/*
 * Decompiled with CFR 0.152.
 */
package plugin.initiative.gui;

import gmgen.GMGenSystem;
import gmgen.plugin.PcgCombatant;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.TransferHandler;
import pcgen.core.Globals;
import pcgen.core.Skill;
import plugin.initiative.OpposedSkillBasicModel;
import plugin.initiative.OpposedSkillModel;
import plugin.initiative.OpposedSkillTypeModel;

public class OpposedCheckDialog
extends JDialog {
    private CombatantTransferHandler transferHandler = new CombatantTransferHandler();
    private JLabel availableLabel = null;
    private JScrollPane availableScrollPane = null;
    private JTable availableTable = null;
    private OpposedSkillTypeModel ivjAvailableModel = null;
    private OpposedSkillModel ivjOpposedSkillModel = null;
    private OpposedSkillModel ivjRollingSkillModel = null;
    private JPanel jContentPane = null;
    private JButton okButton = null;
    private JComboBox opposingComboBox = null;
    private JLabel opposingGroupLabel = null;
    private JScrollPane opposingGroupScrollPane = null;
    private JTable opposingGroupTable = null;
    private JButton rollButton = null;
    private JComboBox rollingComboBox = null;
    private JLabel rollingGroupLabel = null;
    private JScrollPane rollingGroupScrollPane = null;
    private JTable rollingGroupTable = null;
    private TreeSet<String> skillNames = new TreeSet();

    public OpposedCheckDialog() {
        this.skillNames.add("Hide");
        this.skillNames.add("Move Silently");
        this.skillNames.add("Listen");
        this.skillNames.add("Spot");
        this.initialize();
    }

    public OpposedCheckDialog(Dialog owner, List rollingGroup, List availableGroup) throws HeadlessException {
        super(owner);
        this.initializeLists(rollingGroup, availableGroup);
        this.initialize();
    }

    public OpposedCheckDialog(Dialog owner, boolean modal, List rollingGroup, List availableGroup) throws HeadlessException {
        super(owner, modal);
        this.initializeLists(rollingGroup, availableGroup);
        this.initialize();
    }

    public OpposedCheckDialog(Dialog owner, String title, List rollingGroup, List availableGroup) throws HeadlessException {
        super(owner, title);
        this.initializeLists(rollingGroup, availableGroup);
        this.initialize();
    }

    public OpposedCheckDialog(Dialog owner, String title, boolean modal, List rollingGroup, List availableGroup) throws HeadlessException {
        super(owner, title, modal);
        this.initializeLists(rollingGroup, availableGroup);
        this.initialize();
    }

    public OpposedCheckDialog(Dialog owner, String title, boolean modal, GraphicsConfiguration gc, List rollingGroup, List availableGroup) throws HeadlessException {
        super(owner, title, modal, gc);
        this.initializeLists(rollingGroup, availableGroup);
        this.initialize();
    }

    public OpposedCheckDialog(Frame owner, List rollingGroup, List availableGroup) throws HeadlessException {
        super(owner);
        this.initializeLists(rollingGroup, availableGroup);
        this.initialize();
    }

    public OpposedCheckDialog(Frame owner, boolean modal, List rollingGroup, List availableGroup) throws HeadlessException {
        super(owner, modal);
        this.initializeLists(rollingGroup, availableGroup);
        this.initialize();
    }

    public OpposedCheckDialog(Frame owner, String title, List rollingGroup, List availableGroup) throws HeadlessException {
        super(owner, title);
        this.initializeLists(rollingGroup, availableGroup);
        this.initialize();
    }

    public OpposedCheckDialog(Frame owner, String title, boolean modal, List rollingGroup, List availableGroup) throws HeadlessException {
        super(owner, title, modal);
        this.initializeLists(rollingGroup, availableGroup);
        this.initialize();
    }

    public OpposedCheckDialog(Frame owner, String title, boolean modal, GraphicsConfiguration gc, List rollingGroup, List availableGroup) {
        super(owner, title, modal, gc);
        this.initializeLists(rollingGroup, availableGroup);
        this.initialize();
    }

    public OpposedCheckDialog(List rollingGroup, List availableGroup) {
        this.initializeLists(rollingGroup, availableGroup);
        this.initialize();
    }

    private void initializeLists(List rollingGroup, List availableGroup) {
        for (Skill skill : Globals.getContext().getReferenceContext().getConstructedCDOMObjects(Skill.class)) {
            this.skillNames.add(skill.toString());
        }
        this.ivjAvailableModel = new OpposedSkillTypeModel(availableGroup);
        this.ivjRollingSkillModel = new OpposedSkillModel(rollingGroup);
        this.ivjOpposedSkillModel = new OpposedSkillModel();
    }

    private JLabel getAvailableLabel() {
        if (this.availableLabel == null) {
            this.availableLabel = new JLabel();
            this.availableLabel.setText("Available Combatants");
        }
        return this.availableLabel;
    }

    private JScrollPane getAvailableScrollPane() {
        if (this.availableScrollPane == null) {
            this.availableScrollPane = new JScrollPane();
            this.availableScrollPane.setViewportView(this.getAvailableTable());
            this.availableScrollPane.setPreferredSize(new Dimension(300, 100));
        }
        return this.availableScrollPane;
    }

    private JTable getAvailableTable() {
        if (this.availableTable == null) {
            this.availableTable = new JTable();
            this.availableTable.setModel(this.getIvjAvailableModel());
            this.availableTable.setDragEnabled(true);
            this.availableTable.setTransferHandler(this.transferHandler);
            this.availableTable.setName("availableTable");
        }
        return this.availableTable;
    }

    private OpposedSkillBasicModel getIvjAvailableModel() {
        if (this.ivjAvailableModel == null) {
            this.ivjAvailableModel = new OpposedSkillTypeModel();
        }
        return this.ivjAvailableModel;
    }

    private OpposedSkillModel getIvjOpposedSkillModel() {
        if (this.ivjOpposedSkillModel == null) {
            this.ivjOpposedSkillModel = new OpposedSkillModel();
        }
        return this.ivjOpposedSkillModel;
    }

    private OpposedSkillModel getIvjRollingSkillModel() {
        if (this.ivjRollingSkillModel == null) {
            this.ivjRollingSkillModel = new OpposedSkillModel();
        }
        return this.ivjRollingSkillModel;
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            GridBagConstraints consAvailableLabel = new GridBagConstraints();
            GridBagConstraints consOpposingGroupLabel = new GridBagConstraints();
            GridBagConstraints consRollingGroupLabel = new GridBagConstraints();
            GridBagConstraints consOkButton = new GridBagConstraints();
            GridBagConstraints consRollButton = new GridBagConstraints();
            GridBagConstraints consRollingComboBox = new GridBagConstraints();
            GridBagConstraints consOpposingGroupPane = new GridBagConstraints();
            GridBagConstraints consOpposingComboBox = new GridBagConstraints();
            GridBagConstraints consRollingGroupPane = new GridBagConstraints();
            GridBagConstraints consAvailableTable = new GridBagConstraints();
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new GridBagLayout());
            consAvailableTable.gridx = 0;
            consAvailableTable.gridy = 1;
            consAvailableTable.weightx = 1.0;
            consAvailableTable.weighty = 1.0;
            consAvailableTable.fill = 1;
            consAvailableTable.gridwidth = 2;
            consRollingGroupPane.weightx = 1.0;
            consRollingGroupPane.weighty = 1.0;
            consRollingGroupPane.fill = 1;
            consRollingGroupPane.gridx = 0;
            consRollingGroupPane.gridy = 4;
            consOpposingComboBox.weightx = 1.0;
            consOpposingComboBox.fill = 2;
            consOpposingComboBox.gridx = 1;
            consOpposingComboBox.gridy = 3;
            consOpposingGroupPane.weightx = 1.0;
            consOpposingGroupPane.weighty = 1.0;
            consOpposingGroupPane.fill = 1;
            consOpposingGroupPane.gridx = 1;
            consOpposingGroupPane.gridy = 4;
            consRollingComboBox.weightx = 1.0;
            consRollingComboBox.fill = 2;
            consRollingComboBox.gridx = 0;
            consRollingComboBox.gridy = 3;
            consRollButton.gridx = 0;
            consRollButton.gridy = 5;
            consOkButton.gridx = 1;
            consOkButton.gridy = 5;
            this.jContentPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            consRollingGroupLabel.gridx = 0;
            consRollingGroupLabel.gridy = 2;
            consOpposingGroupLabel.gridx = 1;
            consOpposingGroupLabel.gridy = 2;
            consAvailableLabel.gridx = 0;
            consAvailableLabel.gridy = 0;
            consAvailableLabel.gridwidth = 2;
            this.jContentPane.add((Component)this.getAvailableScrollPane(), consAvailableTable);
            this.jContentPane.add((Component)this.getRollingGroupScrollPane(), consRollingGroupPane);
            this.jContentPane.add((Component)this.getOpposingComboBox(), consOpposingComboBox);
            this.jContentPane.add((Component)this.getOpposingGroupScrollPane(), consOpposingGroupPane);
            this.jContentPane.add((Component)this.getRollingComboBox(), consRollingComboBox);
            this.jContentPane.add((Component)this.getRollButton(), consRollButton);
            this.jContentPane.add((Component)this.getOkButton(), consOkButton);
            this.jContentPane.add((Component)this.getRollingGroupLabel(), consRollingGroupLabel);
            this.jContentPane.add((Component)this.getOpposingGroupLabel(), consOpposingGroupLabel);
            this.jContentPane.add((Component)this.getAvailableLabel(), consAvailableLabel);
        }
        return this.jContentPane;
    }

    private JButton getOkButton() {
        if (this.okButton == null) {
            this.okButton = new JButton();
            this.okButton.setText("Ok");
            this.okButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    OpposedCheckDialog.this.okButtonActionPerformed(e);
                }
            });
        }
        return this.okButton;
    }

    private JComboBox getOpposingComboBox() {
        if (this.opposingComboBox == null) {
            this.opposingComboBox = new JComboBox<Object>(this.skillNames.toArray());
            this.opposingComboBox.setSelectedIndex(-1);
            this.opposingComboBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    OpposedCheckDialog.this.opposingComboBoxActionPerformed(e);
                }
            });
        }
        return this.opposingComboBox;
    }

    private JLabel getOpposingGroupLabel() {
        if (this.opposingGroupLabel == null) {
            this.opposingGroupLabel = new JLabel();
            this.opposingGroupLabel.setText("Opposing Group");
        }
        return this.opposingGroupLabel;
    }

    private JScrollPane getOpposingGroupScrollPane() {
        if (this.opposingGroupScrollPane == null) {
            this.opposingGroupScrollPane = new JScrollPane();
            this.opposingGroupScrollPane.setViewportView(this.getOpposingGroupTable());
            this.opposingGroupScrollPane.setPreferredSize(new Dimension(300, 100));
        }
        return this.opposingGroupScrollPane;
    }

    private JTable getOpposingGroupTable() {
        if (this.opposingGroupTable == null) {
            this.opposingGroupTable = new JTable();
            this.opposingGroupTable.setModel(this.getIvjOpposedSkillModel());
            this.opposingGroupTable.setDragEnabled(true);
            this.opposingGroupTable.setTransferHandler(this.transferHandler);
            this.opposingGroupTable.setName("opposingGroupTable");
        }
        return this.opposingGroupTable;
    }

    private JButton getRollButton() {
        if (this.rollButton == null) {
            this.rollButton = new JButton();
            this.rollButton.setText("Roll");
            this.rollButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    OpposedCheckDialog.this.rollButtonActionPerformed(e);
                }
            });
        }
        return this.rollButton;
    }

    private JComboBox getRollingComboBox() {
        if (this.rollingComboBox == null) {
            this.rollingComboBox = new JComboBox<Object>(this.skillNames.toArray());
            this.rollingComboBox.setSelectedIndex(-1);
            this.rollingComboBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    OpposedCheckDialog.this.rollingComboBoxActionPerformed(e);
                }
            });
        }
        return this.rollingComboBox;
    }

    private JLabel getRollingGroupLabel() {
        if (this.rollingGroupLabel == null) {
            this.rollingGroupLabel = new JLabel();
            this.rollingGroupLabel.setText("Rolling Group");
        }
        return this.rollingGroupLabel;
    }

    private JScrollPane getRollingGroupScrollPane() {
        if (this.rollingGroupScrollPane == null) {
            this.rollingGroupScrollPane = new JScrollPane();
            this.rollingGroupScrollPane.setViewportView(this.getRollingGroupTable());
            this.rollingGroupScrollPane.setPreferredSize(new Dimension(300, 100));
        }
        return this.rollingGroupScrollPane;
    }

    private JTable getRollingGroupTable() {
        if (this.rollingGroupTable == null) {
            this.rollingGroupTable = new JTable();
            this.rollingGroupTable.setModel(this.getIvjRollingSkillModel());
            this.rollingGroupTable.setDragEnabled(true);
            this.rollingGroupTable.setTransferHandler(this.transferHandler);
            this.rollingGroupTable.setName("rollingGroupTable");
        }
        return this.rollingGroupTable;
    }

    private void initialize() {
        this.setContentPane(this.getJContentPane());
        this.pack();
        this.setLocationRelativeTo((Component)GMGenSystem.inst);
    }

    protected void okButtonActionPerformed(ActionEvent e) {
        this.setVisible(false);
    }

    protected void opposingComboBoxActionPerformed(ActionEvent e) {
        this.ivjOpposedSkillModel.setSkill(this.opposingComboBox.getSelectedItem().toString());
    }

    protected void rollButtonActionPerformed(ActionEvent e) {
        this.ivjOpposedSkillModel.rollAll();
        this.ivjRollingSkillModel.rollAll();
    }

    protected void rollingComboBoxActionPerformed(ActionEvent e) {
        this.ivjRollingSkillModel.setSkill(this.rollingComboBox.getSelectedItem().toString());
    }

    private static class CombatantTransferHandler
    extends TransferHandler {
        private DataFlavor combatantFlavor = null;
        private String mimeType = "application/x-java-jvm-local-objectref;class=gmgen.plugin.PcgCombatant";
        private OpposedSkillBasicModel sourceModel = null;
        private JTable sourceTable = null;

        public CombatantTransferHandler() {
            try {
                this.combatantFlavor = new DataFlavor(this.mimeType);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }

        @Override
        public boolean canImport(JComponent c, DataFlavor[] flavors) {
            if (this.sourceTable == null || c == null || this.sourceTable.getName().equals(c.getName())) {
                return false;
            }
            for (int i = 0; i < flavors.length; ++i) {
                if (!this.combatantFlavor.equals(flavors[i])) continue;
                return true;
            }
            return false;
        }

        @Override
        protected Transferable createTransferable(JComponent c) {
            if (c instanceof JTable) {
                this.sourceModel = (OpposedSkillBasicModel)((JTable)c).getModel();
                this.sourceTable = (JTable)c;
                return new CombatantTransferable((JTable)c);
            }
            return null;
        }

        @Override
        protected void exportDone(JComponent c, Transferable data, int action) {
            if (action == 2) {
                try {
                    List items = (List)data.getTransferData(this.combatantFlavor);
                    Iterator i = items.iterator();
                    while (i.hasNext()) {
                        this.sourceModel.removeCombatant(((PcgCombatant)i.next()).getName());
                    }
                }
                catch (UnsupportedFlavorException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            this.sourceModel = null;
        }

        @Override
        public int getSourceActions(JComponent c) {
            return 2;
        }

        @Override
        public boolean importData(JComponent c, Transferable t) {
            if (this.canImport(c, t.getTransferDataFlavors())) {
                JTable table = (JTable)c;
                OpposedSkillBasicModel model = (OpposedSkillBasicModel)table.getModel();
                try {
                    List items = (List)t.getTransferData(this.combatantFlavor);
                    Iterator i = items.iterator();
                    while (i.hasNext()) {
                        model.addCombatant((PcgCombatant)i.next());
                    }
                    return true;
                }
                catch (UnsupportedFlavorException ufe) {
                }
                catch (IOException ioe) {
                    // empty catch block
                }
            }
            return false;
        }

        class CombatantTransferable
        implements Transferable {
            private List<PcgCombatant> items = null;

            public CombatantTransferable(JTable table) {
                int[] rows = table.getSelectedRows();
                if (rows != null && rows.length > 0) {
                    OpposedSkillBasicModel model = (OpposedSkillBasicModel)table.getModel();
                    this.items = new ArrayList<PcgCombatant>();
                    for (int i = 0; i < rows.length; ++i) {
                        this.items.add(model.getCombatant(rows[i]));
                    }
                }
            }

            @Override
            public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
                if (!this.isDataFlavorSupported(flavor)) {
                    throw new UnsupportedFlavorException(flavor);
                }
                return this.items;
            }

            @Override
            public DataFlavor[] getTransferDataFlavors() {
                return new DataFlavor[]{CombatantTransferHandler.this.combatantFlavor};
            }

            @Override
            public boolean isDataFlavorSupported(DataFlavor flavor) {
                return CombatantTransferHandler.this.combatantFlavor.equals(flavor);
            }
        }
    }
}

