/*
 * Decompiled with CFR 0.152.
 */
package plugin.exporttokens;

import java.util.StringTokenizer;
import pcgen.core.PlayerCharacter;
import pcgen.io.ExportHandler;
import pcgen.io.exporttoken.Token;
import pcgen.util.Delta;
import pcgen.util.Logging;

public class VarToken
extends Token {
    public static final String TOKENNAME = "VAR";

    public String getTokenName() {
        return TOKENNAME;
    }

    public String getToken(String tokenSource, PlayerCharacter pc, ExportHandler eh) {
        boolean isSign;
        boolean isMin = tokenSource.lastIndexOf(".MINVAL") >= 0;
        boolean isInt = tokenSource.lastIndexOf(".INTVAL") >= 0;
        boolean bl = isSign = tokenSource.lastIndexOf(".SIGN") >= 0;
        if (tokenSource.lastIndexOf(".NOSIGN") >= 0) {
            isSign = false;
            Logging.errorPrint((String)(".NOSIGN in output token " + tokenSource + " is deprecated. " + "The default output format is unsigned."));
        }
        String workingSource = tokenSource;
        if (isMin) {
            workingSource = workingSource.replaceAll(".MINVAL", "");
        }
        if (isInt) {
            workingSource = workingSource.replaceAll(".INTVAL", "");
        }
        workingSource = workingSource.replaceAll(".NOSIGN", "");
        workingSource = workingSource.replaceAll(".SIGN", "");
        StringTokenizer aTok = new StringTokenizer(workingSource, ".");
        aTok.nextToken();
        StringBuilder varName = new StringBuilder();
        if (aTok.hasMoreElements()) {
            varName.append(aTok.nextToken());
        }
        while (aTok.hasMoreElements()) {
            varName.append(".").append(aTok.nextToken());
        }
        if (isInt) {
            if (isSign) {
                return Delta.toString((int)pc.getVariable(varName.toString(), !isMin).intValue());
            }
            return pc.getVariable(varName.toString(), !isMin).intValue() + "";
        }
        if (isSign) {
            return Delta.toString((float)pc.getVariable(varName.toString(), !isMin).floatValue());
        }
        return pc.getVariable(varName.toString(), !isMin) + "";
    }
}

