/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.term;

import java.util.ArrayList;
import java.util.List;
import pcgen.core.Equipment;
import pcgen.core.EquipmentUtilities;
import pcgen.core.PlayerCharacter;
import pcgen.core.term.BasePCTermEvaluator;
import pcgen.core.term.TermEvaluator;

public class PCCountEquipmentTermEvaluator
extends BasePCTermEvaluator
implements TermEvaluator {
    final String[] types;
    private final int merge;

    public PCCountEquipmentTermEvaluator(String expressionString, String[] types, int merge) {
        this.originalText = expressionString;
        this.types = types;
        this.merge = merge;
    }

    @Override
    public Float resolve(PlayerCharacter pc) {
        List<Equipment> aList = new ArrayList<Equipment>();
        List<Equipment> equipList = pc.getEquipmentListInOutputOrder(this.merge);
        for (Equipment eq : equipList) {
            aList.add(eq);
        }
        int cur = 0;
        if ("".equalsIgnoreCase(this.types[cur])) {
            ++cur;
        }
        while (cur < this.types.length) {
            String curTok = this.types[cur];
            ++cur;
            if ("NOT".equalsIgnoreCase(curTok)) {
                aList = EquipmentUtilities.removeEqType(aList, this.types[cur]);
                ++cur;
                continue;
            }
            if ("ADD".equalsIgnoreCase(curTok)) {
                aList = pc.addEqType(aList, this.types[cur]);
                ++cur;
                continue;
            }
            if ("IS".equalsIgnoreCase(curTok)) {
                aList = EquipmentUtilities.removeNotEqType(aList, this.types[cur]);
                ++cur;
                continue;
            }
            if (!"EQUIPPED".equalsIgnoreCase(curTok) && !"NOTEQUIPPED".equalsIgnoreCase(curTok)) continue;
            boolean eFlag = "EQUIPPED".equalsIgnoreCase(curTok);
            for (int ix = aList.size() - 1; ix >= 0; --ix) {
                Equipment anEquip = aList.get(ix);
                if (anEquip.isEquipped() == eFlag) continue;
                aList.remove(anEquip);
            }
        }
        return Float.valueOf(aList.size());
    }

    @Override
    public boolean isSourceDependant() {
        return false;
    }

    public boolean isStatic() {
        return false;
    }
}

