/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui2.tools;

import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import pcgen.system.LanguageBundle;

public class CommonMenuText {
    private static final String MNEMONIC_SUFFIX = "in_mn_";
    private static final String TIP_SUFFIX = "Tip";

    public static void name(Action a, String prop, Object ... substitutes) {
        a.putValue("Name", CommonMenuText.getName(prop, substitutes));
        String shortDesc = CommonMenuText.getShortDesc(prop, substitutes);
        if (shortDesc != null && !shortDesc.isEmpty()) {
            a.putValue("ShortDescription", shortDesc);
        }
        a.putValue("MnemonicKey", CommonMenuText.getMnemonic(prop));
    }

    private static int getMnemonic(String prop) {
        return LanguageBundle.getMnemonic(MNEMONIC_SUFFIX + prop);
    }

    private static String getShortDesc(String prop, Object ... substitutes) {
        return LanguageBundle.getFormattedString("in_" + prop + TIP_SUFFIX, substitutes);
    }

    private static String getName(String prop, Object ... substitutes) {
        return LanguageBundle.getFormattedString("in_" + prop, substitutes);
    }

    public static void name(JMenuItem m, String prop, Object ... substitutes) {
        m.setText(CommonMenuText.getName(prop, substitutes));
        String shortDesc = CommonMenuText.getShortDesc(prop, substitutes);
        if (shortDesc != null && !shortDesc.isEmpty()) {
            m.setToolTipText(shortDesc);
        }
        m.setMnemonic(CommonMenuText.getMnemonic(prop));
    }

    public static void name(JButton b, String prop, Object ... substitutes) {
        b.setText(CommonMenuText.getName(prop, substitutes));
        String shortDesc = CommonMenuText.getShortDesc(prop, substitutes);
        if (shortDesc != null && !shortDesc.isEmpty()) {
            b.setToolTipText(shortDesc);
        }
        b.setMnemonic(CommonMenuText.getMnemonic(prop));
    }
}

