/*
 * Decompiled with CFR 0.152.
 */
package pcgen.rules.persistence;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import pcgen.base.util.CaseInsensitiveMap;
import pcgen.base.util.DoubleKeyMapToList;
import pcgen.base.util.TripleKeyMapToList;
import pcgen.base.util.WeightedCollection;
import pcgen.cdom.base.GroupDefinition;
import pcgen.cdom.base.Loadable;
import pcgen.persistence.PersistenceLayerException;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.TokenLibrary;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.CDOMSecondaryToken;
import pcgen.rules.persistence.token.CDOMSubToken;
import pcgen.rules.persistence.token.CDOMToken;
import pcgen.rules.persistence.token.ComplexParseResult;
import pcgen.rules.persistence.token.DeferredToken;
import pcgen.rules.persistence.token.ParseResult;
import pcgen.rules.persistence.util.Revision;
import pcgen.rules.persistence.util.TokenFamily;
import pcgen.rules.persistence.util.TokenFamilyIterator;
import pcgen.rules.persistence.util.TokenFamilySubIterator;
import pcgen.util.Logging;

public class TokenSupport {
    private TokenFamily localTokens = new TokenFamily(new Revision(0, 0, 0));
    private DoubleKeyMapToList<Class<?>, String, CDOMToken<?>> tokenCache = new DoubleKeyMapToList();
    private TripleKeyMapToList<Class<?>, String, String, CDOMToken<?>> subTokenCache = new TripleKeyMapToList(HashMap.class, CaseInsensitiveMap.class, CaseInsensitiveMap.class);

    public <T extends Loadable> boolean processToken(LoadContext context, T derivative, String typeStr, String argument) throws PersistenceLayerException {
        Class<?> cl = derivative.getClass();
        List<CDOMToken<?>> tokenList = this.getTokens(cl, typeStr);
        if (tokenList != null) {
            for (CDOMToken<?> token : tokenList) {
                ParseResult parse;
                try {
                    parse = token.parseToken(context, derivative, argument);
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                    Logging.addParseMessage(Logging.LST_ERROR, "Token generated an IllegalArgumentException: " + e.getLocalizedMessage());
                    parse = new ParseResult.Fail("Token processing failed");
                }
                parse.addMessagesToLog();
                if (parse.passed()) {
                    return true;
                }
                if (!Logging.isLoggable(Logging.LST_INFO)) continue;
                Logging.addParseMessage(Logging.LST_INFO, "Failed in parsing typeStr: " + typeStr + " " + argument);
            }
        }
        if (typeStr.startsWith(" ")) {
            Logging.addParseMessage(Logging.LST_ERROR, "Illegal whitespace at start of token '" + typeStr + "' '" + argument + "' for " + cl.getName() + " " + derivative.getDisplayName() + " in " + context.getSourceURI());
        } else {
            Logging.addParseMessage(Logging.LST_ERROR, "Illegal Token '" + typeStr + "' '" + argument + "' for " + cl.getName() + " " + derivative.getDisplayName() + " in " + context.getSourceURI());
        }
        return false;
    }

    public <T extends Loadable> List<? extends CDOMToken<T>> getTokens(Class<T> cl, String name) {
        List list = this.tokenCache.getListFor(cl, (Object)name);
        if (list == null) {
            CDOMToken<?> local = this.localTokens.getToken(cl, name);
            if (local != null) {
                this.tokenCache.addToListFor(cl, (Object)name, local);
            }
            TokenLibrary.TokenIterator it = new TokenLibrary.TokenIterator(cl, name);
            while (it.hasNext()) {
                CDOMToken token = (CDOMToken)it.next();
                this.tokenCache.addToListFor(cl, (Object)name, (Object)token);
            }
            list = this.tokenCache.getListFor(cl, (Object)name);
        }
        return list;
    }

    public <T> List<? extends CDOMToken<T>> getTokens(Class<T> cl, String name, String subtoken) {
        List list = this.subTokenCache.getListFor(cl, (Object)name, (Object)subtoken);
        if (list == null) {
            CDOMSubToken<T> local = this.localTokens.getSubToken(cl, name, subtoken);
            if (local != null) {
                this.subTokenCache.addToListFor(cl, (Object)name, (Object)subtoken, local);
            }
            TokenLibrary.SubTokenIterator it = new TokenLibrary.SubTokenIterator(cl, name, subtoken);
            while (it.hasNext()) {
                CDOMToken token = (CDOMToken)it.next();
                this.subTokenCache.addToListFor(cl, (Object)name, (Object)subtoken, (Object)token);
            }
            list = this.subTokenCache.getListFor(cl, (Object)name, (Object)subtoken);
        }
        return list;
    }

    public <T> ParseResult processSubToken(LoadContext context, T cdo, String tokenName, String key, String value) {
        ComplexParseResult cpr = new ComplexParseResult();
        List<CDOMToken<?>> tokenList = this.getTokens(cdo.getClass(), tokenName, key);
        if (tokenList != null) {
            for (CDOMToken<?> token : tokenList) {
                ParseResult pr = token.parseToken(context, cdo, value);
                if (pr.passed()) {
                    return pr;
                }
                cpr.copyMessages(pr);
                cpr.addErrorMessage("Failed in parsing subtoken: " + key + " of " + value);
            }
        }
        cpr.addErrorMessage("Illegal " + tokenName + " subtoken '" + key + "' '" + value + "' for " + cdo.toString());
        return cpr;
    }

    public <T> String[] unparseSubtoken(LoadContext context, T cdo, String tokenName) {
        char separator = tokenName.charAt(0) == '*' ? (char)':' : '|';
        WeightedCollection<String> set = new WeightedCollection<String>(String.CASE_INSENSITIVE_ORDER);
        Class<?> cl = cdo.getClass();
        TokenFamilySubIterator it = new TokenFamilySubIterator(cl, tokenName);
        while (it.hasNext()) {
            Object token = it.next();
            String[] s = token.unparse(context, cdo);
            if (s == null) continue;
            for (String aString : s) {
                set.add(token.getTokenName() + separator + aString);
            }
        }
        Set<CDOMSecondaryToken<?>> local = this.localTokens.getSubTokens(cl, tokenName);
        for (CDOMSecondaryToken<?> token : local) {
            String[] s = token.unparse(context, cdo);
            if (s == null) continue;
            for (String aString : s) {
                set.add(token.getTokenName() + separator + aString);
            }
        }
        if (set.isEmpty()) {
            return null;
        }
        return set.toArray(new String[set.size()]);
    }

    public <T> Collection<String> unparse(LoadContext context, T cdo) {
        WeightedCollection<String> set = new WeightedCollection<String>(String.CASE_INSENSITIVE_ORDER);
        Class<?> cl = cdo.getClass();
        TokenFamilyIterator it = new TokenFamilyIterator(cl);
        while (it.hasNext()) {
            Object token = it.next();
            String[] s = token.unparse(context, cdo);
            if (s == null) continue;
            for (String aString : s) {
                set.add(token.getTokenName() + ':' + aString);
            }
        }
        if (set.isEmpty()) {
            return null;
        }
        return set;
    }

    public <T> String[] unparseToken(LoadContext loadContext, T cdo, String tokenName) {
        Class<?> cl = cdo.getClass();
        CDOMToken<?> token = null;
        while (token == null) {
            token = TokenFamily.CURRENT.getToken(cl, tokenName);
            if (token != null) continue;
            if (Object.class.equals(cl)) {
                return null;
            }
            cl = cl.getSuperclass();
        }
        ArrayList<String> result = new ArrayList<String>();
        if (CDOMPrimaryToken.class.isAssignableFrom(token.getClass())) {
            CDOMPrimaryToken primaryToken = (CDOMPrimaryToken)token;
            String[] s = primaryToken.unparse(loadContext, cdo);
            if (s != null) {
                for (String aString : s) {
                    result.add(token.getTokenName() + ':' + aString);
                }
            }
        } else {
            throw new IllegalArgumentException("Expected a primary token in unparseToken, but " + tokenName + " - " + token.getClass().getName() + " is not a CDOMPrimaryToken.");
        }
        if (result.isEmpty()) {
            return null;
        }
        return result.toArray(new String[0]);
    }

    public Collection<DeferredToken<? extends Loadable>> getDeferredTokens() {
        ArrayList<DeferredToken<? extends Loadable>> c = new ArrayList<DeferredToken<? extends Loadable>>();
        c.addAll(this.localTokens.getDeferredTokens());
        c.addAll(TokenFamily.CURRENT.getDeferredTokens());
        return c;
    }

    public void loadLocalToken(Object token) {
        TokenLibrary.loadFamily(this.localTokens, token);
    }

    public <T> GroupDefinition<T> getGroup(Class<T> cl, String s) {
        return this.localTokens.getGroup(cl, s);
    }
}

