/*
 * Decompiled with CFR 0.152.
 */
package plugin.overland.model;

import java.io.File;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import java.util.logging.Level;
import org.jdom.DocType;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import pcgen.system.LanguageBundle;
import pcgen.util.Logging;
import plugin.overland.gui.XMLFilter;
import plugin.overland.model.TravelMethod;
import plugin.overland.model.TravelMethodImplementation;
import plugin.overland.util.Localized;

public class TravelMethodFactory {
    public static final Locale DEFAULT_LOCALE = Locale.UK;
    private static final String DIR_TRAVELMETHODS = "travel_methods";
    private static final String XML_ELEMENT_TRAVEL = "travel";
    private static final String XML_ELEMENT_COMBO = "combo";
    private static final String XML_ELEMENT_CHOICE = "choice";
    private static final String XML_ELEMENT_CHOOSE_FROM = "chooseFrom";
    private static final String XML_ELEMENT_PACE = "pace";
    private static final String XML_ELEMENT_METHOD = "method";
    private static final String XML_ELEMENT_ROUTE = "route";
    private static final String XML_ELEMENT_TERRAIN = "terrain";
    private static final String XML_ELEMENT_WAY = "way";
    private static final String XML_ATTRIBUTE_HOURSINDAY = "hoursInDay";
    private static final String XML_ATTRIBUTE_MPH = "mph";
    private static final String XML_ATTRIBUTE_KMH = "kmh";
    private static final String XML_ATTRIBUTE_COMMENT = "comment";
    private static final String XML_ATTRIBUTE_DAYS = "days";
    private static final String XML_ATTRIBUTE_ADDKMH = "addKmh";
    private static final String XML_ATTRIBUTE_ADDMPH = "addMph";
    private static final String XML_ATTRIBUTE_MULT = "mult";
    private static final String XML_ATTRIBUTE_ID = "id";
    private static final String XML_ATTRIBUTE_NUMBERFORMAT = "numberFormat";

    public static final Vector<TravelMethod> load(File datadir) {
        Vector<TravelMethod> tms = new Vector<TravelMethod>();
        File path = new File(datadir, DIR_TRAVELMETHODS);
        if (path.isDirectory()) {
            File[] dataFiles = path.listFiles(new XMLFilter());
            SAXBuilder builder = new SAXBuilder();
            for (int i = 0; i < dataFiles.length; ++i) {
                try {
                    Document methodSet = builder.build(dataFiles[i]);
                    DocType dt = methodSet.getDocType();
                    if (!dt.getElementName().equals(XML_ELEMENT_TRAVEL)) continue;
                    TravelMethod tm = TravelMethodFactory.create(methodSet);
                    tms.add(tm);
                    continue;
                }
                catch (Exception e) {
                    Logging.errorPrint(e.getMessage(), e);
                }
            }
        } else {
            Logging.errorPrintLocalised("in_plugin_overland_noDatafile", path.getPath());
        }
        return tms;
    }

    public static TravelMethod create(Document methodSet) {
        Element travel = methodSet.getRootElement();
        NumberFormat nf = TravelMethodFactory.getNumberFormat(travel);
        Localized name = new Localized(travel);
        HashMap<String, Map<String, TravelMethodImplementation.Combo>> multByRoadByTerrains = new HashMap<String, Map<String, TravelMethodImplementation.Combo>>();
        HashMap<String, List<Localized>> terrains2 = new HashMap<String, List<Localized>>();
        HashMap<String, Map<Localized, String>> terrainsById2 = new HashMap<String, Map<Localized, String>>();
        HashMap<String, List<Localized>> routes2 = new HashMap<String, List<Localized>>();
        HashMap<String, Map<Localized, String>> routesById2 = new HashMap<String, Map<Localized, String>>();
        ArrayList<TravelMethodImplementation.Method> methods = new ArrayList<TravelMethodImplementation.Method>();
        for (Object methodObj : travel.getChildren()) {
            Element child = (Element)methodObj;
            if (child.getName().equals(XML_ELEMENT_WAY)) {
                String wayId = child.getAttributeValue(XML_ATTRIBUTE_ID);
                ArrayList<Localized> terrains = new ArrayList<Localized>();
                terrains2.put(wayId, terrains);
                ArrayList<Localized> routes = new ArrayList<Localized>();
                routes2.put(wayId, routes);
                HashMap<Localized, String> terrainsById = new HashMap<Localized, String>();
                terrainsById2.put(wayId, terrainsById);
                HashMap<Localized, String> routesById = new HashMap<Localized, String>();
                routesById2.put(wayId, routesById);
                for (Object o : child.getChildren()) {
                    String id;
                    if (!(o instanceof Element)) continue;
                    Element grandchild = (Element)o;
                    if (grandchild.getName().equals(XML_ELEMENT_TERRAIN)) {
                        id = grandchild.getAttributeValue(XML_ATTRIBUTE_ID);
                        Localized terrain = new Localized(grandchild);
                        terrains.add(terrain);
                        terrainsById.put(terrain, id);
                        if (multByRoadByTerrains.containsKey(id)) continue;
                        multByRoadByTerrains.put(id, new TreeMap());
                        continue;
                    }
                    if (!grandchild.getName().equals(XML_ELEMENT_ROUTE)) continue;
                    id = grandchild.getAttributeValue(XML_ATTRIBUTE_ID);
                    Localized route = new Localized(grandchild);
                    routes.add(route);
                    routesById.put(route, id);
                    for (Object gcc : grandchild.getChildren(XML_ELEMENT_COMBO)) {
                        if (!(gcc instanceof Element)) continue;
                        Element grandgrandchild = (Element)gcc;
                        String idTerrain = grandgrandchild.getAttributeValue(XML_ELEMENT_TERRAIN);
                        Number mult = TravelMethodFactory.parseNumber(nf, grandgrandchild, XML_ATTRIBUTE_MULT, 1);
                        Number addMph = TravelMethodFactory.parseNumber(nf, grandgrandchild, XML_ATTRIBUTE_ADDMPH, 0);
                        Number addKmh = TravelMethodFactory.parseNumber(nf, grandgrandchild, XML_ATTRIBUTE_ADDKMH, 0);
                        if (!multByRoadByTerrains.containsKey(idTerrain)) {
                            multByRoadByTerrains.put(idTerrain, new TreeMap());
                        }
                        ((Map)multByRoadByTerrains.get(idTerrain)).put(id, new TravelMethodImplementation.Combo(mult, addMph, addKmh));
                    }
                }
                continue;
            }
            if (!child.getName().equals(XML_ELEMENT_METHOD)) continue;
            String way = child.getAttributeValue(XML_ELEMENT_WAY);
            TravelMethodImplementation.Method method = new TravelMethodImplementation.Method(new Localized(child), way);
            methods.add(method);
            for (Object o : child.getChildren()) {
                if (!(o instanceof Element)) continue;
                Element grandchild = (Element)o;
                if (grandchild.getName().equals(XML_ELEMENT_PACE)) {
                    Localized pace = new Localized(grandchild);
                    boolean useDays = Boolean.parseBoolean(grandchild.getAttributeValue(XML_ATTRIBUTE_DAYS));
                    Localized comment = new Localized(grandchild, XML_ATTRIBUTE_COMMENT);
                    Number mult = TravelMethodFactory.parseNumber(nf, grandchild, XML_ATTRIBUTE_MULT, 1);
                    TravelMethodImplementation.Pace newPace = new TravelMethodImplementation.Pace(pace, comment, useDays, mult);
                    method.add(newPace);
                }
                if (!grandchild.getName().equals(XML_ELEMENT_CHOOSE_FROM)) continue;
                Number kmh = TravelMethodFactory.parseNumber(nf, grandchild, XML_ATTRIBUTE_KMH, 0.75);
                Number mph = TravelMethodFactory.parseNumber(nf, grandchild, XML_ATTRIBUTE_MPH, 0.5);
                Number hoursInDay = TravelMethodFactory.parseNumber(nf, grandchild, XML_ATTRIBUTE_HOURSINDAY, 24);
                for (Object o2 : grandchild.getChildren(XML_ELEMENT_CHOICE)) {
                    if (!(o2 instanceof Element)) continue;
                    Element grandgrandchild = (Element)o2;
                    Localized choiceName = new Localized(grandgrandchild);
                    Number mult = TravelMethodFactory.parseNumber(nf, grandgrandchild, XML_ATTRIBUTE_MULT, 1);
                    TravelMethodImplementation.Choice c = new TravelMethodImplementation.Choice(choiceName, hoursInDay, mult.doubleValue() * kmh.doubleValue(), mult.doubleValue() * mph.doubleValue());
                    method.add(c);
                }
            }
        }
        return new TravelMethodImplementation(name, multByRoadByTerrains, terrains2, terrainsById2, routes2, routesById2, methods);
    }

    private static Number parseNumber(NumberFormat nf, Element e, String string, Number def) {
        Number n = def;
        String attributeValue = e.getAttributeValue(string);
        if (attributeValue != null) {
            try {
                n = nf.parse(attributeValue);
            }
            catch (ParseException exception) {
                exception.printStackTrace();
            }
        }
        return n;
    }

    public static NumberFormat getNumberFormat(Element e) {
        String numFormLoc = e.getAttributeValue(XML_ATTRIBUTE_NUMBERFORMAT, "");
        String[] split = numFormLoc.split("_");
        Locale l = null;
        switch (split.length) {
            case 0: {
                l = DEFAULT_LOCALE;
                break;
            }
            case 1: {
                l = new Locale(split[0]);
                break;
            }
            case 2: {
                l = new Locale(split[0], split[1]);
                break;
            }
            case 3: {
                l = new Locale(split[0], split[1], split[2]);
                break;
            }
            default: {
                Logging.log(Level.WARNING, LanguageBundle.getFormattedString("in_log_localeInvalid", numFormLoc, split[0], split[1], split[2]));
                l = new Locale(split[0], split[1], split[2]);
            }
        }
        return NumberFormat.getNumberInstance(l);
    }
}

