/*
 * Decompiled with CFR 0.152.
 */
package plugin.exporttokens;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import pcgen.core.PlayerCharacter;
import pcgen.io.ExportHandler;
import pcgen.io.exporttoken.Token;
import pcgen.util.Logging;

public class TextToken
extends Token {
    public static final String TOKENNAME = "TEXT";

    public String getTokenName() {
        return TOKENNAME;
    }

    public String getToken(String tokenSource, PlayerCharacter pc, ExportHandler eh) {
        String retString = "";
        StringTokenizer aTok = new StringTokenizer(tokenSource, ".");
        aTok.nextToken();
        String action = "";
        StringBuilder varName = new StringBuilder();
        if (aTok.hasMoreElements() && (action = aTok.nextToken()).startsWith("REPLACE")) {
            while (action.charAt(action.length() - 1) != '}') {
                action = action + "." + aTok.nextToken();
            }
        }
        if (aTok.hasMoreElements()) {
            varName.append(aTok.nextToken());
        }
        while (aTok.hasMoreElements()) {
            varName.append(".").append(aTok.nextToken());
        }
        StringWriter writer = new StringWriter();
        BufferedWriter bw = new BufferedWriter(writer);
        eh.replaceToken(varName.toString(), bw, pc);
        try {
            bw.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        retString = writer.getBuffer().toString();
        if (action.equalsIgnoreCase("UPPER") || action.equalsIgnoreCase("UPPERCASE")) {
            retString = retString.toUpperCase();
        } else if (action.equalsIgnoreCase("LOWER") || action.equalsIgnoreCase("LOWERCASE")) {
            retString = retString.toLowerCase();
        } else if (action.equalsIgnoreCase("SENTENCE") || action.equalsIgnoreCase("SENTENCECASE")) {
            retString = this.changeToSentenceCase(retString);
        } else if (action.equalsIgnoreCase("TITLE") || action.equalsIgnoreCase("TITLECASE")) {
            retString = this.changeToTitleCase(retString);
        } else if (action.equalsIgnoreCase("NUMSUFFIX")) {
            retString = this.buildNumSuffix(retString);
        } else if (action.equalsIgnoreCase("LENGTH")) {
            retString = String.valueOf(retString.length());
        } else if (action.startsWith("REPLACE")) {
            String replaceType = action.substring(7, action.indexOf(123));
            String args = action.substring(action.indexOf(123) + 1, action.length() - 1);
            int patternEnd = 0;
            while ((patternEnd = args.indexOf(44, patternEnd)) > 0 && args.charAt(patternEnd - 1) == '\\') {
                String temp = args.substring(0, patternEnd - 1);
                args = temp + args.substring(patternEnd, args.length());
            }
            if (patternEnd <= 0) {
                Logging.errorPrint((String)"Invalid REPLACE token");
            }
            String pattern = args.substring(0, patternEnd);
            pattern = pattern.replaceAll("__LP__", "\\(").replaceAll("__RP__", "\\)").replaceAll("__PLUS__", "+");
            String replacement = args.substring(patternEnd + 1).trim().replaceFirst("^\"", "").replaceFirst("\"$", "");
            if (replaceType.equalsIgnoreCase("ALL")) {
                retString = retString.replaceAll(pattern, replacement);
            } else if (replaceType.equalsIgnoreCase("FIRST")) {
                retString = retString.replaceFirst(pattern, replacement);
            }
        }
        return retString;
    }

    private String changeToSentenceCase(String value) {
        String temp = value.toLowerCase();
        String[] sentence = temp.split("\\.");
        StringBuilder res = new StringBuilder(value.length());
        Pattern p = Pattern.compile("\\s*");
        for (int i = 0; i < sentence.length; ++i) {
            if (i > 0) {
                res.append(".");
            }
            if (sentence[i].trim().length() > 0) {
                Matcher m = p.matcher(sentence[i]);
                int pos = 0;
                if (m.find()) {
                    pos = m.end();
                }
                if (pos > 0) {
                    res.append(sentence[i].substring(0, pos));
                }
                res.append(sentence[i].substring(pos, pos + 1).toUpperCase());
                res.append(sentence[i].substring(pos + 1));
                continue;
            }
            res.append(sentence[i]);
        }
        return res.toString();
    }

    private String changeToTitleCase(String value) {
        String temp = value.toLowerCase();
        char[] chars = temp.toCharArray();
        StringBuilder res = new StringBuilder(value.length());
        boolean start = true;
        for (int i = 0; i < chars.length; ++i) {
            boolean whiteSpace;
            char c = chars[i];
            boolean bl = whiteSpace = c == ' ' || c == '\t' || c == '\n' || c == '\f' || c == '\r';
            if (start && !whiteSpace) {
                res.append(Character.toUpperCase(c));
                start = false;
                continue;
            }
            start = whiteSpace;
            res.append(c);
        }
        return res.toString();
    }

    private String buildNumSuffix(String number) {
        String result = "";
        int intVal = 0;
        try {
            intVal = new BigDecimal(number).intValue();
        }
        catch (Exception e) {
            return "";
        }
        result = intVal % 10 == 1 && intVal % 100 != 11 ? "st" : (intVal % 10 == 2 && intVal % 100 != 12 ? "nd" : (intVal % 10 == 3 && intVal % 100 != 13 ? "rd" : "th"));
        return result;
    }

    public boolean isEncoded() {
        return false;
    }
}

