/*
 * Decompiled with CFR 0.152.
 */
package com.eed3si9n.jarjarabrams;

import com.eed3si9n.jarjar.util.DuplicateJarEntryException;
import com.eed3si9n.jarjar.util.EntryStruct;
import com.eed3si9n.jarjar.util.IoUtil;
import com.eed3si9n.jarjarabrams.Using$;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.util.TimeZone;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import scala.Console$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.JavaConverters$;
import scala.collection.immutable.List;
import scala.collection.mutable.HashSet;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class Zip$ {
    public static final Zip$ MODULE$ = new Zip$();
    private static final long localized2010Timestamp = MODULE$.localizeTimestamp(1262304000000L);
    private static final long localized2010TimestampPlus2s = MODULE$.localizeTimestamp(1262304002000L);
    private static final long localizedMinimumTimestamp = MODULE$.localizeTimestamp(315705600000L);

    private final int BufferSize() {
        return 8192;
    }

    private final long default2010Timestamp() {
        return 1262304000000L;
    }

    private final long minimumTimestampIncrement() {
        return 2000L;
    }

    private final long minimumTimestamp() {
        return 315705600000L;
    }

    public List<Tuple2<String, Object>> list(Path inputJar) {
        return (List)Using$.MODULE$.jarFile().apply(inputJar, (Function1<JarFile, List> & Serializable)in -> JavaConverters$.MODULE$.enumerationAsScalaIteratorConverter(in.entries()).asScala().map((Function1<JarEntry, Tuple2> & Serializable)entry -> new Tuple2<String, Long>(entry.getName(), BoxesRunTime.boxToLong(entry.getTime()))).toList());
    }

    public Path transformJarFile(Path inputJar, Path outputJar, boolean resetTimestamp, boolean warnOnDuplicateClass, Function1<EntryStruct, Option<EntryStruct>> f) {
        return (Path)Using$.MODULE$.jarFile().apply(inputJar, (Function1<JarFile, Path> & Serializable)in -> {
            Path tempJar = Files.createTempFile("jarjar", ".jar", new FileAttribute[0]);
            Using$.MODULE$.jarOutputStream().apply(tempJar, (Function1<JarOutputStream, Object> & Serializable)out -> {
                Zip$.$anonfun$transformJarFile$2(in, f, resetTimestamp, warnOnDuplicateClass, inputJar, out);
                return BoxedUnit.UNIT;
            });
            IoUtil.copyZipWithoutEmptyDirectories(tempJar.toFile(), outputJar.toFile());
            MODULE$.resetModifiedTime(outputJar);
            return outputJar;
        });
    }

    private long localized2010Timestamp() {
        return localized2010Timestamp;
    }

    private long localized2010TimestampPlus2s() {
        return localized2010TimestampPlus2s;
    }

    private long localizedMinimumTimestamp() {
        return localizedMinimumTimestamp;
    }

    private long hardcodedZipTimestamp(String name) {
        if (name.endsWith(".class")) {
            return this.localized2010TimestampPlus2s();
        }
        return this.localized2010Timestamp();
    }

    private long enforceMinimum(long timestampInLocal) {
        if (timestampInLocal < this.localizedMinimumTimestamp()) {
            return this.localizedMinimumTimestamp();
        }
        return timestampInLocal;
    }

    private long localizeTimestamp(long timestampInUtc) {
        return timestampInUtc - (long)TimeZone.getDefault().getOffset(timestampInUtc);
    }

    public EntryStruct entryStruct(String name, long time, byte[] data, boolean skipTransform) {
        EntryStruct struct = new EntryStruct();
        struct.name = name;
        struct.time = time;
        struct.data = data;
        struct.skipTransform = skipTransform;
        return struct;
    }

    public boolean entryStruct$default$4() {
        return false;
    }

    public boolean resetModifiedTime(Path file) {
        boolean bl;
        try {
            this.setModifiedTime(file, 1262304000000L);
            bl = true;
        }
        catch (FileNotFoundException fileNotFoundException) {
            bl = false;
        }
        return bl;
    }

    public boolean setModifiedTimeOrFalse(Path file, long mtime2) {
        boolean bl;
        try {
            this.setModifiedTime(file, mtime2);
            bl = true;
        }
        catch (FileNotFoundException fileNotFoundException) {
            bl = false;
        }
        return bl;
    }

    public void setModifiedTime(Path filePath, long mtime2) {
        this.mapNoSuchFileException(() -> Files.setLastModifiedTime(filePath, FileTime.fromMillis(mtime2)));
    }

    private <A> A mapNoSuchFileException(Function0<A> f) {
        A a;
        try {
            a = f.apply();
        }
        catch (NoSuchFileException e) {
            throw new FileNotFoundException(e.getFile()).initCause(e);
        }
        return a;
    }

    public void transfer(Path in2, OutputStream out) {
        Using$.MODULE$.fileInputStream().apply(in2, (Function1<InputStream, Object> & Serializable)in -> {
            Zip$.MODULE$.transfer(in, out);
            return BoxedUnit.UNIT;
        });
    }

    public void transfer(InputStream in, OutputStream out) {
        this.transferImpl(in, out, false);
    }

    private void transferImpl(InputStream in, OutputStream out, boolean close2) {
        try {
            byte[] buffer = new byte[8192];
            this.read$1(in, buffer, out);
        }
        finally {
            if (close2) {
                in.close();
            }
        }
    }

    private byte[] toByteArray(InputStream in) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.transfer(in, (OutputStream)baos);
        return baos.toByteArray();
    }

    public void createDirectories(Path p) {
        if (Files.exists(p, new LinkOption[0])) {
            return;
        }
        Files.createDirectories(p, new FileAttribute[0]);
    }

    public String sha256(Path p) {
        return (String)Using$.MODULE$.fileInputStream().apply(p, (Function1<InputStream, String> & Serializable)in0 -> {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            Using$.MODULE$.digestInputStream(digest).apply((InputStream)in0, (Function1<DigestInputStream, Object> & Serializable)in -> {
                Zip$.$anonfun$sha256$2(in);
                return BoxedUnit.UNIT;
            });
            return MODULE$.toHexString(digest.digest());
        });
    }

    private String toHexString(byte[] bytes) {
        scala.collection.mutable.StringBuilder buffer = new scala.collection.mutable.StringBuilder(bytes.length * 2);
        ArrayOps$.MODULE$.indices$extension(Predef$.MODULE$.byteArrayOps(bytes)).foreach((Function1<Object, scala.collection.mutable.StringBuilder> & Serializable)i -> Zip$.$anonfun$toHexString$1(bytes, buffer, BoxesRunTime.unboxToInt(i)));
        return buffer.toString();
    }

    public static final /* synthetic */ void $anonfun$transformJarFile$3(JarFile in$1, Function1 f$1, HashSet names$1, boolean resetTimestamp$1, JarOutputStream out$1, boolean warnOnDuplicateClass$1, Path inputJar$1, JarEntry entry0) {
        EntryStruct struct0 = MODULE$.entryStruct(entry0.getName(), entry0.getTime(), MODULE$.toByteArray(in$1.getInputStream(entry0)), false);
        Option option = (Option)f$1.apply(struct0);
        if (option instanceof Some) {
            Some some = (Some)option;
            EntryStruct struct = (EntryStruct)some.value();
            if (names$1.add(struct.name)) {
                JarEntry entry = new JarEntry(struct.name);
                long time = resetTimestamp$1 ? MODULE$.hardcodedZipTimestamp(struct.name) : MODULE$.enforceMinimum(struct.time);
                entry.setTime(time);
                entry.setCompressedSize(-1L);
                out$1.putNextEntry(entry);
                out$1.write(struct.data);
                return;
            }
            if (struct.name.endsWith("/")) {
                return;
            }
            if (warnOnDuplicateClass$1) {
                Console$.MODULE$.err().println(new StringBuilder(72).append("in ").append(inputJar$1).append(", found duplicate files with name: ").append(struct.name).append(", ignoring due to specified option").toString());
                return;
            }
            throw new DuplicateJarEntryException(((Object)inputJar$1).toString(), struct.name);
        }
        if (None$.MODULE$.equals(option)) {
            return;
        }
        throw new MatchError(option);
    }

    public static final /* synthetic */ void $anonfun$transformJarFile$2(JarFile in$1, Function1 f$1, boolean resetTimestamp$1, boolean warnOnDuplicateClass$1, Path inputJar$1, JarOutputStream out) {
        HashSet names = new HashSet();
        ((IterableOnceOps)JavaConverters$.MODULE$.enumerationAsScalaIteratorConverter(in$1.entries()).asScala()).foreach((Function1<JarEntry, Object> & Serializable)entry0 -> {
            Zip$.$anonfun$transformJarFile$3(in$1, f$1, names, resetTimestamp$1, out, warnOnDuplicateClass$1, inputJar$1, entry0);
            return BoxedUnit.UNIT;
        });
    }

    private final void read$1(InputStream in$2, byte[] buffer$1, OutputStream out$3) {
        int byteCount;
        while ((byteCount = in$2.read(buffer$1)) >= 0) {
            out$3.write(buffer$1, 0, byteCount);
        }
    }

    public static final /* synthetic */ void com$eed3si9n$jarjarabrams$Zip$$$anonfun$sha256$3(int b) {
    }

    public static final /* synthetic */ void $anonfun$sha256$2(DigestInputStream in) {
        OutputStream out = new OutputStream(){

            public final void write(int x$1) {
                Zip$.com$eed3si9n$jarjarabrams$Zip$$$anonfun$sha256$3(x$1);
            }
        };
        MODULE$.transfer(in, out);
    }

    public static final /* synthetic */ scala.collection.mutable.StringBuilder $anonfun$toHexString$1(byte[] bytes$1, scala.collection.mutable.StringBuilder buffer$2, int i) {
        String hex = Integer.toHexString(bytes$1[i] & 0xFF);
        Serializable serializable = hex.length() == 1 ? buffer$2.append('0') : BoxedUnit.UNIT;
        return buffer$2.append(hex);
    }

    private Zip$() {
    }
}

