/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.initialization;

import java.util.ArrayList;
import java.util.List;
import org.gradle.api.Buildable;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.initialization.BuildLogicBuildQueue;
import org.gradle.api.internal.initialization.BuildLogicBuilder;
import org.gradle.api.internal.initialization.ScriptClassPathResolver;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.tasks.TaskDependencyUtil;
import org.gradle.composite.internal.TaskIdentifier;
import org.gradle.internal.build.BuildState;
import org.gradle.internal.classpath.ClassPath;

public class DefaultBuildLogicBuilder
implements BuildLogicBuilder {
    private final BuildState currentBuild;
    private final ScriptClassPathResolver scriptClassPathResolver;
    private final BuildLogicBuildQueue buildQueue;

    public DefaultBuildLogicBuilder(BuildState currentBuild, ScriptClassPathResolver scriptClassPathResolver, BuildLogicBuildQueue buildQueue) {
        this.currentBuild = currentBuild;
        this.scriptClassPathResolver = scriptClassPathResolver;
        this.buildQueue = buildQueue;
    }

    @Override
    public void prepareClassPath(Configuration classpathConfiguration, DependencyHandler dependencyHandler) {
        this.scriptClassPathResolver.prepareClassPath(classpathConfiguration, dependencyHandler);
    }

    @Override
    public ClassPath resolveClassPath(Configuration classpathConfiguration) {
        return this.buildQueue.build(this.currentBuild, this.taskIdentifiersForBuildDependenciesOf(classpathConfiguration), () -> this.scriptClassPathResolver.resolveClassPath(classpathConfiguration));
    }

    private List<TaskIdentifier.TaskBasedTaskIdentifier> taskIdentifiersForBuildDependenciesOf(Configuration classpath) {
        ArrayList<TaskIdentifier.TaskBasedTaskIdentifier> tasksToBuild = new ArrayList<TaskIdentifier.TaskBasedTaskIdentifier>();
        for (Task task : TaskDependencyUtil.getDependenciesForInternalUse((Buildable)classpath)) {
            BuildState targetBuild = DefaultBuildLogicBuilder.owningBuildOf(task);
            assert (targetBuild != this.currentBuild);
            tasksToBuild.add(TaskIdentifier.of(targetBuild.getBuildIdentifier(), (TaskInternal)task));
        }
        return tasksToBuild;
    }

    private static BuildState owningBuildOf(Task task) {
        return ((ProjectInternal)task.getProject()).getOwner().getOwner();
    }
}

