/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugin.devel.tasks.internal;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.gradle.api.problems.DocLink;
import org.gradle.api.problems.Problem;
import org.gradle.api.problems.ReportableProblem;
import org.gradle.api.problems.internal.DefaultReportableProblem;
import org.gradle.api.problems.internal.InternalProblems;
import org.gradle.api.problems.locations.FileLocation;
import org.gradle.api.problems.locations.PluginIdLocation;
import org.gradle.api.problems.locations.ProblemLocation;
import org.gradle.api.problems.locations.TaskPathLocation;
import org.gradle.internal.reflect.validation.TypeValidationProblemRenderer;
import org.gradle.util.Path;

@Nonnull
public class ValidationProblemSerialization {
    private static final GsonBuilder GSON_BUILDER = ValidationProblemSerialization.createGsonBuilder();

    public static List<? extends ReportableProblem> parseMessageList(String lines, InternalProblems problemService) {
        Gson gson = GSON_BUILDER.create();
        Type type = new TypeToken<List<DefaultReportableProblem>>(){}.getType();
        List reportableProblems = (List)gson.fromJson(lines, type);
        reportableProblems.forEach(problem -> problem.setProblemService(problemService));
        return reportableProblems;
    }

    public static GsonBuilder createGsonBuilder() {
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.registerTypeHierarchyAdapter(DocLink.class, (Object)new DocLinkAdapter());
        gsonBuilder.registerTypeHierarchyAdapter(ProblemLocation.class, (Object)new LocationAdapter());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new ThrowableAdapterFactory());
        return gsonBuilder;
    }

    public static Stream<String> toPlainMessage(List<? extends ReportableProblem> problems) {
        return problems.stream().map(problem -> problem.getSeverity() + ": " + TypeValidationProblemRenderer.renderMinimalInformationAbout((Problem)problem));
    }

    private static class LocationAdapter
    extends TypeAdapter<ProblemLocation> {
        private LocationAdapter() {
        }

        public void write(JsonWriter out, ProblemLocation value) throws IOException {
            if (value == null) {
                out.nullValue();
                return;
            }
            if (value instanceof FileLocation) {
                new FileLocationAdapter().write(out, (FileLocation)value);
                return;
            }
            if (value instanceof PluginIdLocation) {
                new PluginIdLocationAdapter().write(out, (PluginIdLocation)value);
                return;
            }
            if (value instanceof TaskPathLocation) {
                new TaskLocationAdapter().write(out, (TaskPathLocation)value);
            }
        }

        public ProblemLocation read(JsonReader in) throws IOException {
            if (in.hasNext()) {
                in.beginObject();
                try {
                    String type = null;
                    String name = in.nextName();
                    if (name.equals("type")) {
                        type = in.nextString();
                    }
                    if (type == null) {
                        throw new JsonParseException("type must not be null");
                    }
                    switch (type) {
                        case "file": {
                            FileLocation fileLocation = FileLocationAdapter.readObject(in);
                            return fileLocation;
                        }
                        case "pluginId": {
                            PluginIdLocation pluginIdLocation = PluginIdLocationAdapter.readObject(in);
                            return pluginIdLocation;
                        }
                        case "task": {
                            TaskPathLocation taskPathLocation = TaskLocationAdapter.readObject(in);
                            return taskPathLocation;
                        }
                    }
                    throw new JsonParseException("Unknown type: " + type);
                }
                finally {
                    in.endObject();
                }
            }
            return null;
        }
    }

    public static class DocLinkAdapter
    extends TypeAdapter<DocLink> {
        public void write(JsonWriter out, @Nullable DocLink value) throws IOException {
            if (value == null) {
                out.nullValue();
                return;
            }
            out.beginObject();
            out.name("url").value(value.getUrl());
            out.name("consultDocumentationMessage").value(value.getConsultDocumentationMessage());
            out.endObject();
        }

        public DocLink read(JsonReader in) throws IOException {
            in.beginObject();
            String url = null;
            String consultDocumentationMessage = null;
            block8: while (in.hasNext()) {
                String name;
                switch (name = in.nextName()) {
                    case "url": {
                        url = in.nextString();
                        continue block8;
                    }
                    case "consultDocumentationMessage": {
                        consultDocumentationMessage = in.nextString();
                        continue block8;
                    }
                }
                in.skipValue();
            }
            in.endObject();
            final String finalUrl = url;
            final String finalConsultDocumentationMessage = consultDocumentationMessage;
            return new DocLink(){

                public String getUrl() {
                    return finalUrl;
                }

                public String getConsultDocumentationMessage() {
                    return finalConsultDocumentationMessage;
                }
            };
        }
    }

    public static class TaskLocationAdapter
    extends TypeAdapter<TaskPathLocation> {
        public void write(JsonWriter out, @Nullable TaskPathLocation value) throws IOException {
            if (value == null) {
                out.nullValue();
                return;
            }
            out.beginArray();
            out.name("type").value(value.getType());
            out.name("identityPath").value(value.getIdentityPath().getPath());
            out.endObject();
        }

        public TaskPathLocation read(JsonReader in) throws IOException {
            in.beginObject();
            TaskPathLocation identityPath = TaskLocationAdapter.readObject(in);
            in.endObject();
            Objects.requireNonNull(identityPath, "identityPath must not be null");
            return identityPath;
        }

        @Nonnull
        private static TaskPathLocation readObject(JsonReader in) throws IOException {
            String identityPath = null;
            while (in.hasNext()) {
                String name = in.nextName();
                if (name.equals("identityPath")) {
                    identityPath = in.nextString();
                    continue;
                }
                in.skipValue();
            }
            return new TaskPathLocation(Path.path(identityPath));
        }
    }

    public static class PluginIdLocationAdapter
    extends TypeAdapter<PluginIdLocation> {
        public void write(JsonWriter out, @Nullable PluginIdLocation value) throws IOException {
            if (value == null) {
                out.nullValue();
                return;
            }
            out.beginArray();
            out.name("type").value(value.getType());
            out.name("pluginId").value(value.getPluginId());
            out.endObject();
        }

        public PluginIdLocation read(JsonReader in) throws IOException {
            in.beginObject();
            PluginIdLocation problemLocation = PluginIdLocationAdapter.readObject(in);
            in.endObject();
            Objects.requireNonNull(problemLocation, "pluginId must not be null");
            return problemLocation;
        }

        private static PluginIdLocation readObject(JsonReader in) throws IOException {
            String pluginId = null;
            while (in.hasNext()) {
                String name = in.nextName();
                if (name.equals("pluginId")) {
                    pluginId = in.nextString();
                    continue;
                }
                in.skipValue();
            }
            return new PluginIdLocation(pluginId);
        }
    }

    public static class FileLocationAdapter
    extends TypeAdapter<FileLocation> {
        public void write(JsonWriter out, @Nullable FileLocation value) throws IOException {
            if (value == null) {
                out.nullValue();
                return;
            }
            out.beginObject();
            out.name("type").value(value.getType());
            out.name("path").value(value.getPath());
            out.name("line").value((Number)value.getLine());
            out.name("column").value((Number)value.getColumn());
            out.name("length").value((Number)value.getLength());
            out.endObject();
        }

        public FileLocation read(JsonReader in) throws IOException {
            in.beginObject();
            FileLocation fileLocation = FileLocationAdapter.readObject(in);
            in.endObject();
            Objects.requireNonNull(fileLocation, "path must not be null");
            return fileLocation;
        }

        @Nonnull
        private static FileLocation readObject(JsonReader in) throws IOException {
            String path = null;
            Integer line = null;
            Integer column = null;
            Integer length = null;
            block12: while (in.hasNext()) {
                String name;
                switch (name = in.nextName()) {
                    case "path": {
                        path = in.nextString();
                        continue block12;
                    }
                    case "line": {
                        line = in.nextInt();
                        continue block12;
                    }
                    case "column": {
                        column = in.nextInt();
                        continue block12;
                    }
                    case "length": {
                        length = in.nextInt();
                        continue block12;
                    }
                }
                in.skipValue();
            }
            return new FileLocation(path, line, column, length);
        }
    }

    public static class ThrowableTypeAdapter
    extends TypeAdapter<Throwable> {
        private final TypeToken<Throwable> typeToken;

        public ThrowableTypeAdapter(TypeToken<Throwable> typeToken) {
            this.typeToken = typeToken;
        }

        @Nullable
        public Throwable read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            in.beginObject();
            String message = null;
            Throwable cause = null;
            block11: while (in.hasNext()) {
                String name;
                switch (name = in.nextName()) {
                    case "message": {
                        message = in.nextString();
                        continue block11;
                    }
                    case "cause": {
                        cause = this.read(in);
                        continue block11;
                    }
                }
                in.skipValue();
            }
            in.endObject();
            try {
                Constructor constructor;
                if (message == null && cause == null) {
                    constructor = this.typeToken.getRawType().getDeclaredConstructor(new Class[0]);
                    return (Throwable)constructor.newInstance(new Object[0]);
                }
                if (message == null) {
                    constructor = this.typeToken.getRawType().getDeclaredConstructor(Throwable.class);
                    return (Throwable)constructor.newInstance(cause);
                }
                if (cause == null) {
                    constructor = this.typeToken.getRawType().getDeclaredConstructor(String.class);
                    return (Throwable)constructor.newInstance(message);
                }
                constructor = this.typeToken.getRawType().getDeclaredConstructor(String.class, Throwable.class);
                return (Throwable)constructor.newInstance(message, cause);
            }
            catch (NoSuchMethodException e) {
                if (message == null && cause == null) {
                    return new RuntimeException();
                }
                if (message == null) {
                    return new RuntimeException(cause);
                }
                if (cause == null) {
                    return new RuntimeException(message);
                }
                return new RuntimeException(message, cause);
            }
            catch (Exception e) {
                throw new JsonParseException((Throwable)e);
            }
        }

        public void write(JsonWriter out, @Nullable Throwable throwable) throws IOException {
            if (throwable == null) {
                out.nullValue();
            } else if (throwable.getMessage() == null && throwable.getCause() != null) {
                this.write(out, throwable.getCause());
            } else {
                out.beginObject();
                if (throwable.getMessage() != null) {
                    out.name("message");
                    out.value(throwable.getMessage());
                }
                if (ThrowableTypeAdapter.shouldWriteCause(throwable)) {
                    out.name("cause");
                    this.write(out, throwable.getCause());
                }
                out.endObject();
            }
        }

        private static boolean shouldWriteCause(Throwable throwable) {
            Throwable cause = throwable.getCause();
            if (cause == null || cause.getMessage() == null || cause == throwable) {
                return false;
            }
            return throwable.getMessage() == null || !throwable.getMessage().contains(cause.getMessage());
        }
    }

    public static class ThrowableAdapterFactory
    implements TypeAdapterFactory {
        @Nullable
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken) {
            if (!Throwable.class.isAssignableFrom(typeToken.getRawType())) {
                return null;
            }
            return new ThrowableTypeAdapter(typeToken);
        }
    }
}

