/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.caching.local.internal;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.function.Consumer;
import org.gradle.api.Action;
import org.gradle.api.NonNullApi;
import org.gradle.cache.PersistentCache;
import org.gradle.caching.BuildCacheEntryReader;
import org.gradle.caching.BuildCacheEntryWriter;
import org.gradle.caching.BuildCacheException;
import org.gradle.caching.BuildCacheKey;
import org.gradle.caching.BuildCacheService;
import org.gradle.caching.internal.DefaultBuildCacheKey;
import org.gradle.caching.local.internal.BuildCacheTempFileStore;
import org.gradle.caching.local.internal.DirectoryBuildCache;
import org.gradle.caching.local.internal.LocalBuildCacheService;
import org.gradle.internal.file.FileAccessTracker;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.io.IoConsumer;
import org.gradle.internal.resource.local.PathKeyFileStore;

@NonNullApi
public class DirectoryBuildCacheService
implements LocalBuildCacheService,
BuildCacheService {
    private final DirectoryBuildCache cache;

    public DirectoryBuildCacheService(PathKeyFileStore fileStore, PersistentCache persistentCache, BuildCacheTempFileStore tempFileStore, FileAccessTracker fileAccessTracker, String failedFileSuffix) {
        this.cache = new DirectoryBuildCache(fileStore, persistentCache, tempFileStore, fileAccessTracker, failedFileSuffix);
    }

    public boolean load(BuildCacheKey key, BuildCacheEntryReader reader) throws BuildCacheException {
        return this.cache.load(((DefaultBuildCacheKey)key).getHashCodeInternal(), (IoConsumer<InputStream>)((IoConsumer)arg_0 -> ((BuildCacheEntryReader)reader).readFrom(arg_0)));
    }

    @Override
    public void loadLocally(BuildCacheKey key, Action<? super File> reader) {
        this.cache.loadLocally(((DefaultBuildCacheKey)key).getHashCodeInternal(), arg_0 -> reader.execute(arg_0));
    }

    public void store(BuildCacheKey key, BuildCacheEntryWriter result) throws BuildCacheException {
        this.cache.store(((DefaultBuildCacheKey)key).getHashCodeInternal(), (IoConsumer<OutputStream>)((IoConsumer)arg_0 -> ((BuildCacheEntryWriter)result).writeTo(arg_0)));
    }

    @Override
    public void storeLocally(BuildCacheKey key, File file) {
        this.cache.storeLocally(((DefaultBuildCacheKey)key).getHashCodeInternal(), file);
    }

    @Override
    public void withTempFile(HashCode key, Consumer<? super File> action) {
        this.cache.withTempFile(key, action);
    }

    @Override
    public void close() throws IOException {
        this.cache.close();
    }
}

