/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.problems.internal;

import java.util.List;
import org.gradle.api.problems.ProblemCategory;
import org.gradle.util.Path;

public class DefaultProblemCategory
implements ProblemCategory {
    public static final int NAMESPACE_START_INDEX = 0;
    public static final String GRADLE_PLUGIN_MARKER = "gradle-plugin";
    public static final String DEPRECATION = "deprecation";
    public static final String VALIDATION = "validation";
    public static final String SEPARATOR = ":";
    protected Path category;

    public DefaultProblemCategory(String category) {
        if (category.startsWith(SEPARATOR)) {
            throw new IllegalArgumentException("Problem category cannot start with ':'");
        }
        Path path = Path.path((String)category);
        if (path.segmentCount() < 1) {
            throw new IllegalArgumentException("Problem category must have at least 1 segments");
        }
        this.category = path;
    }

    public static DefaultProblemCategory category(String category, String ... details) {
        if (details.length == 0) {
            return new DefaultProblemCategory(category);
        }
        return new DefaultProblemCategory(category + SEPARATOR + String.join((CharSequence)SEPARATOR, details));
    }

    public String segment(int i) {
        return this.category.segment(i);
    }

    public int segmentCount() {
        return this.category.segmentCount();
    }

    public String toString() {
        return this.category.toString();
    }

    @Override
    public boolean hasPluginId() {
        return this.category.segmentCount() > 1 && this.category.segment(0).equals(GRADLE_PLUGIN_MARKER);
    }

    @Override
    public String getPluginId() {
        return this.category.segment(1);
    }

    @Override
    public String getNamespace() {
        return this.category.segment(0);
    }

    @Override
    public String getCategory() {
        return this.category.segment(0 + (this.hasPluginId() ? 2 : 0));
    }

    @Override
    public List<String> getSubCategories() {
        return this.category.segments().subList(0 + (this.hasPluginId() ? 3 : 1), this.category.segmentCount());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DefaultProblemCategory)) {
            return false;
        }
        DefaultProblemCategory that = (DefaultProblemCategory)o;
        return this.category.equals((Object)that.category);
    }

    public int hashCode() {
        return this.category.hashCode();
    }
}

