/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.caching.internal.controller;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.io.Closer;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.Duration;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.internal.cache.StringInterner;
import org.gradle.api.internal.file.temp.TemporaryFileProvider;
import org.gradle.caching.BuildCacheKey;
import org.gradle.caching.BuildCacheService;
import org.gradle.caching.internal.CacheableEntity;
import org.gradle.caching.internal.controller.BuildCacheController;
import org.gradle.caching.internal.controller.operations.PackOperationDetails;
import org.gradle.caching.internal.controller.operations.PackOperationResult;
import org.gradle.caching.internal.controller.operations.UnpackOperationDetails;
import org.gradle.caching.internal.controller.operations.UnpackOperationResult;
import org.gradle.caching.internal.controller.service.BuildCacheLoadResult;
import org.gradle.caching.internal.controller.service.BuildCacheServiceRole;
import org.gradle.caching.internal.controller.service.BuildCacheServicesConfiguration;
import org.gradle.caching.internal.controller.service.DefaultLocalBuildCacheServiceHandle;
import org.gradle.caching.internal.controller.service.LocalBuildCacheServiceHandle;
import org.gradle.caching.internal.controller.service.NullLocalBuildCacheServiceHandle;
import org.gradle.caching.internal.controller.service.NullRemoteBuildCacheServiceHandle;
import org.gradle.caching.internal.controller.service.OpFiringRemoteBuildCacheServiceHandle;
import org.gradle.caching.internal.controller.service.RemoteBuildCacheServiceHandle;
import org.gradle.caching.internal.origin.OriginMetadata;
import org.gradle.caching.internal.origin.OriginMetadataFactory;
import org.gradle.caching.internal.packaging.BuildCacheEntryPacker;
import org.gradle.caching.local.internal.BuildCacheTempFileStore;
import org.gradle.caching.local.internal.DefaultBuildCacheTempFileStore;
import org.gradle.caching.local.internal.LocalBuildCacheService;
import org.gradle.internal.file.FileMetadata;
import org.gradle.internal.file.FileType;
import org.gradle.internal.file.TreeType;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.CallableBuildOperation;
import org.gradle.internal.operations.RunnableBuildOperation;
import org.gradle.internal.snapshot.FileSystemLocationSnapshot;
import org.gradle.internal.snapshot.FileSystemSnapshot;
import org.gradle.internal.snapshot.MissingFileSnapshot;
import org.gradle.internal.vfs.FileSystemAccess;

public class DefaultBuildCacheController
implements BuildCacheController {
    @VisibleForTesting
    final RemoteBuildCacheServiceHandle remote;
    @VisibleForTesting
    final LocalBuildCacheServiceHandle local;
    private final BuildCacheTempFileStore tmp;
    private final boolean emitDebugLogging;
    private final PackOperationExecutor packExecutor;
    private boolean closed;

    public DefaultBuildCacheController(BuildCacheServicesConfiguration config, BuildOperationExecutor buildOperationExecutor, TemporaryFileProvider temporaryFileProvider, boolean logStackTraces, boolean emitDebugLogging, boolean disableRemoteOnError, FileSystemAccess fileSystemAccess, BuildCacheEntryPacker packer, OriginMetadataFactory originMetadataFactory, StringInterner stringInterner) {
        this.emitDebugLogging = emitDebugLogging;
        this.local = DefaultBuildCacheController.toLocalHandle(config.getLocal(), config.isLocalPush());
        this.remote = DefaultBuildCacheController.toRemoteHandle(config.getRemote(), config.isRemotePush(), buildOperationExecutor, logStackTraces, disableRemoteOnError);
        this.tmp = DefaultBuildCacheController.toTempFileStore(config.getLocal(), temporaryFileProvider);
        this.packExecutor = new PackOperationExecutor(buildOperationExecutor, fileSystemAccess, packer, originMetadataFactory, stringInterner);
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public boolean isEmitDebugLogging() {
        return this.emitDebugLogging;
    }

    @Override
    public Optional<BuildCacheLoadResult> load(BuildCacheKey key, CacheableEntity entity) {
        Optional<BuildCacheLoadResult> result = this.loadLocal(key, entity);
        if (result.isPresent()) {
            return result;
        }
        return this.loadRemoteAndStoreResultLocally(key, entity);
    }

    private Optional<BuildCacheLoadResult> loadLocal(BuildCacheKey key, CacheableEntity entity) {
        try {
            return this.local.maybeLoad(key, file -> this.packExecutor.unpack(key, entity, (File)file));
        }
        catch (Exception e) {
            throw new GradleException("Could not load from local cache: " + e.getMessage(), (Throwable)e);
        }
    }

    private Optional<BuildCacheLoadResult> loadRemoteAndStoreResultLocally(BuildCacheKey key, CacheableEntity entity) {
        if (!this.remote.canLoad()) {
            return Optional.empty();
        }
        AtomicReference result = new AtomicReference(Optional.empty());
        this.tmp.withTempFile(key, (Action<? super File>)((Action)file -> {
            Optional<BuildCacheLoadResult> remoteResult;
            try {
                remoteResult = this.remote.maybeLoad(key, (File)file, f -> this.packExecutor.unpack(key, entity, (File)f));
            }
            catch (Exception e) {
                throw new GradleException("Could not load from remote cache: " + e.getMessage(), (Throwable)e);
            }
            if (remoteResult.isPresent()) {
                this.local.maybeStore(key, (File)file);
                result.set(remoteResult);
            }
        }));
        return result.get();
    }

    @Override
    public void store(BuildCacheKey key, CacheableEntity entity, Map<String, FileSystemSnapshot> snapshots, Duration executionTime) {
        if (!this.local.canStore() && !this.remote.canStore()) {
            return;
        }
        this.tmp.withTempFile(key, (Action<? super File>)((Action)file -> {
            this.packExecutor.pack((File)file, key, entity, snapshots, executionTime);
            this.remote.maybeStore(key, (File)file);
            this.local.maybeStore(key, (File)file);
        }));
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            Closer closer = Closer.create();
            closer.register((Closeable)this.local);
            closer.register((Closeable)this.remote);
            closer.close();
        }
    }

    private static RemoteBuildCacheServiceHandle toRemoteHandle(@Nullable BuildCacheService service, boolean push, BuildOperationExecutor buildOperationExecutor, boolean logStackTraces, boolean disableOnError) {
        return service == null ? NullRemoteBuildCacheServiceHandle.INSTANCE : new OpFiringRemoteBuildCacheServiceHandle(service, push, BuildCacheServiceRole.REMOTE, buildOperationExecutor, logStackTraces, disableOnError);
    }

    private static LocalBuildCacheServiceHandle toLocalHandle(@Nullable LocalBuildCacheService local, boolean localPush) {
        return local == null ? NullLocalBuildCacheServiceHandle.INSTANCE : new DefaultLocalBuildCacheServiceHandle(local, localPush);
    }

    private static BuildCacheTempFileStore toTempFileStore(@Nullable LocalBuildCacheService local, TemporaryFileProvider temporaryFileProvider) {
        return local != null ? local : new DefaultBuildCacheTempFileStore(temporaryFileProvider);
    }

    @VisibleForTesting
    static class PackOperationExecutor {
        private final BuildOperationExecutor buildOperationExecutor;
        private final FileSystemAccess fileSystemAccess;
        private final BuildCacheEntryPacker packer;
        private final OriginMetadataFactory originMetadataFactory;
        private final StringInterner stringInterner;

        PackOperationExecutor(BuildOperationExecutor buildOperationExecutor, FileSystemAccess fileSystemAccess, BuildCacheEntryPacker packer, OriginMetadataFactory originMetadataFactory, StringInterner stringInterner) {
            this.buildOperationExecutor = buildOperationExecutor;
            this.fileSystemAccess = fileSystemAccess;
            this.packer = packer;
            this.originMetadataFactory = originMetadataFactory;
            this.stringInterner = stringInterner;
        }

        @VisibleForTesting
        BuildCacheLoadResult unpack(final BuildCacheKey key, final CacheableEntity entity, final File file) {
            return (BuildCacheLoadResult)this.buildOperationExecutor.call((CallableBuildOperation)new CallableBuildOperation<BuildCacheLoadResult>(){

                public BuildCacheLoadResult call(BuildOperationContext context) throws IOException {
                    try (FileInputStream input = new FileInputStream(file);){
                        BuildCacheLoadResult metadata = this.doUnpack(entity, input);
                        context.setResult((Object)new UnpackOperationResult(metadata.getArtifactEntryCount()));
                        BuildCacheLoadResult buildCacheLoadResult = metadata;
                        return buildCacheLoadResult;
                    }
                }

                public BuildOperationDescriptor.Builder description() {
                    return BuildOperationDescriptor.displayName((String)("Unpack build cache entry " + key.getHashCode())).details((Object)new UnpackOperationDetails(key, file.length())).progressDisplayName("Unpacking build cache entry");
                }
            });
        }

        private BuildCacheLoadResult doUnpack(CacheableEntity entity, InputStream input) throws IOException {
            ImmutableList.Builder roots = ImmutableList.builder();
            entity.visitOutputTrees((name, type, root) -> roots.add((Object)root.getAbsolutePath()));
            this.fileSystemAccess.write((Iterable)roots.build(), () -> {});
            final BuildCacheEntryPacker.UnpackResult unpackResult = this.packer.unpack(entity, input, this.originMetadataFactory.createReader(entity));
            final ImmutableSortedMap<String, FileSystemSnapshot> resultingSnapshots = this.snapshotUnpackedData(entity, unpackResult.getSnapshots());
            return new BuildCacheLoadResult(){

                @Override
                public long getArtifactEntryCount() {
                    return unpackResult.getEntries();
                }

                @Override
                public OriginMetadata getOriginMetadata() {
                    return unpackResult.getOriginMetadata();
                }

                @Override
                public ImmutableSortedMap<String, FileSystemSnapshot> getResultingSnapshots() {
                    return resultingSnapshots;
                }
            };
        }

        private ImmutableSortedMap<String, FileSystemSnapshot> snapshotUnpackedData(CacheableEntity entity, Map<String, ? extends FileSystemLocationSnapshot> treeSnapshots) {
            ImmutableSortedMap.Builder builder = ImmutableSortedMap.naturalOrder();
            entity.visitOutputTrees((treeName, type, root) -> {
                FileSystemLocationSnapshot resultingSnapshot;
                FileSystemLocationSnapshot treeSnapshot = (FileSystemLocationSnapshot)treeSnapshots.get(treeName);
                if (treeSnapshot == null) {
                    String internedAbsolutePath = this.stringInterner.intern(root.getAbsolutePath());
                    resultingSnapshot = new MissingFileSnapshot(internedAbsolutePath, FileMetadata.AccessType.DIRECT);
                } else {
                    if (type == TreeType.FILE && treeSnapshot.getType() != FileType.RegularFile) {
                        throw new IllegalStateException(String.format("Only a regular file should be produced by unpacking tree '%s', but saw a %s", treeName, treeSnapshot.getType()));
                    }
                    resultingSnapshot = treeSnapshot;
                }
                this.fileSystemAccess.record(resultingSnapshot);
                builder.put((Object)treeName, (Object)resultingSnapshot);
            });
            return builder.build();
        }

        @VisibleForTesting
        void pack(final File file, final BuildCacheKey key, final CacheableEntity entity, final Map<String, FileSystemSnapshot> snapshots, final Duration executionTime) {
            this.buildOperationExecutor.run(new RunnableBuildOperation(){

                public void run(BuildOperationContext context) throws IOException {
                    try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
                        BuildCacheEntryPacker.PackResult packResult = packer.pack(entity, snapshots, (OutputStream)fileOutputStream, originMetadataFactory.createWriter(entity, executionTime));
                        long entryCount = packResult.getEntries();
                        context.setResult((Object)new PackOperationResult(entryCount, file.length()));
                    }
                }

                public BuildOperationDescriptor.Builder description() {
                    return BuildOperationDescriptor.displayName((String)("Pack build cache entry " + key)).details((Object)new PackOperationDetails(key)).progressDisplayName("Packing build cache entry");
                }
            });
        }
    }
}

