/*
 * Decompiled with CFR 0.152.
 */
package org.kobjects.pim;

import java.io.IOException;
import java.io.Reader;
import java.util.Vector;
import org.kobjects.io.LookAheadReader;
import org.kobjects.pim.PimField;
import org.kobjects.pim.PimItem;

public class PimParser {
    LookAheadReader reader;
    Class type;

    public PimParser(Reader reader, Class clazz) {
        this.reader = new LookAheadReader(reader);
        this.type = clazz;
    }

    public PimItem readItem() throws IOException {
        String string;
        PimItem pimItem;
        String string2 = this.readName();
        if (string2 == null) {
            return null;
        }
        if (!string2.equals("begin")) {
            throw new RuntimeException("'begin:' expected");
        }
        try {
            pimItem = (PimItem)this.type.newInstance();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.toString());
        }
        this.reader.read();
        if (!pimItem.getType().equals(this.readStringValue().toLowerCase())) {
            throw new RuntimeException("item types do not match!");
        }
        while (!(string = this.readName()).equals("end")) {
            String[] stringArray;
            PimField pimField = new PimField(string);
            this.readProperties(pimField);
            switch (pimItem.getType(string)) {
                case 1: {
                    stringArray = this.readArrayValue(pimItem.getArraySize(string));
                    break;
                }
                default: {
                    stringArray = this.readStringValue();
                }
            }
            pimField.setValue(stringArray);
            System.out.println("value:" + stringArray);
            pimItem.addField(pimField);
        }
        this.reader.read();
        System.out.println("end:" + this.readStringValue());
        return pimItem;
    }

    String readName() throws IOException {
        String string = this.reader.readTo(":;").trim().toLowerCase();
        System.out.println("name:" + string);
        return this.reader.peek(0) == -1 ? null : string;
    }

    String[] readArrayValue(int n) throws IOException {
        Vector<String> vector = new Vector<String>();
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        do {
            stringBuffer.append(this.reader.readTo(";\n\r"));
            switch (this.reader.read()) {
                case 59: {
                    vector.addElement(stringBuffer.toString());
                    stringBuffer.setLength(0);
                    break;
                }
                case 13: {
                    if (this.reader.peek(0) == 10) {
                        this.reader.read();
                    }
                }
                case 10: {
                    if (this.reader.peek(0) != 32) {
                        bl = false;
                        break;
                    }
                    this.reader.read();
                }
            }
        } while (bl);
        if (stringBuffer.length() != 0) {
            vector.addElement(stringBuffer.toString());
        }
        String[] stringArray = new String[n];
        for (int i = 0; i < Math.min(stringArray.length, vector.size()); ++i) {
            stringArray[i] = (String)vector.elementAt(i);
        }
        return stringArray;
    }

    String readStringValue() throws IOException {
        String string = this.reader.readLine();
        while (this.reader.peek(0) == 32) {
            this.reader.read();
            string = string + this.reader.readLine();
        }
        return string;
    }

    void readProperties(PimField pimField) throws IOException {
        int n = this.reader.read();
        while (n == 32) {
            n = this.reader.read();
        }
        while (n != 58) {
            String string = this.reader.readTo(":;=").trim().toLowerCase();
            n = this.reader.read();
            if (n == 61) {
                pimField.setProperty(string, this.reader.readTo(":;").trim().toLowerCase());
                n = this.reader.read();
                continue;
            }
            pimField.setAttribute(string, true);
        }
    }
}

