/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.jdbc;

import com.impossibl.postgres.jdbc.Exceptions;
import com.impossibl.postgres.jdbc.PGConnectionImpl;
import com.impossibl.postgres.jdbc.PGResultSet;
import com.impossibl.postgres.jdbc.Scroller;
import com.impossibl.postgres.protocol.DataRow;
import com.impossibl.postgres.protocol.ParsedDataRow;
import com.impossibl.postgres.protocol.ResultField;
import com.impossibl.postgres.types.CompositeType;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Iterator;
import java.util.List;

class CursorScroller
extends Scroller {
    PGConnectionImpl connection;
    String cursorName;
    int type;
    int holdability;
    List<ResultField> resultFields;
    int rowIndexValue;
    Integer rowCountCache;
    int rowIndexSign;
    DataRow result;

    CursorScroller(PGResultSet resultSet, String cursorName, int type, int holdability, List<ResultField> resultFields) {
        this.connection = resultSet.statement.connection;
        this.cursorName = cursorName;
        this.type = type;
        this.holdability = holdability;
        this.resultFields = resultFields;
        this.rowIndexValue = 0;
        this.rowIndexSign = 1;
    }

    void setRowIndex(int value, boolean sign) {
        this.rowIndexValue = value;
        this.rowIndexSign = sign ? 1 : -1;
    }

    void setResult(DataRow result) {
        if (this.result != null) {
            this.result.release();
        }
        this.result = result;
    }

    boolean fetch(String type, Object loc) throws SQLException {
        StringBuilder sb = new StringBuilder();
        sb.append("FETCH ");
        sb.append(type);
        sb.append(" ");
        sb.append(loc);
        sb.append(" FROM ");
        sb.append(this.cursorName);
        this.setResult(this.connection.executeForFirstResult(sb.toString(), true, new Object[0]));
        return this.result != null;
    }

    int move(String type, Object loc) throws SQLException {
        this.setResult(null);
        StringBuilder sb = new StringBuilder();
        sb.append("MOVE ");
        sb.append(type);
        sb.append(" ");
        sb.append(loc);
        sb.append(" IN ");
        sb.append(this.cursorName);
        return (int)this.connection.executeForRowsAffected(sb.toString(), true, new Object[0]);
    }

    int getRealRowCount() throws SQLException {
        if (this.rowCountCache == null) {
            this.move("ABSOLUTE", 0);
            this.rowCountCache = this.move("FORWARD", "ALL");
            this.move("ABSOLUTE", this.getRow());
        }
        return this.rowCountCache;
    }

    @Override
    void close() throws SQLException {
        this.setResult(null);
        if (this.holdability == 1) {
            this.connection.execute("CLOSE " + this.cursorName, true);
        }
    }

    @Override
    List<ResultField> getResultFields() {
        return this.resultFields;
    }

    @Override
    boolean isValidRow() {
        return this.result != null;
    }

    @Override
    String getCursorName() {
        return this.cursorName;
    }

    @Override
    public int getRow() throws SQLException {
        if (!this.isValidRow()) {
            return 0;
        }
        if (this.rowIndexSign < 0) {
            return this.getRealRowCount() - this.rowIndexValue + 1;
        }
        return this.rowIndexValue;
    }

    @Override
    DataRow getRowData() {
        return this.result;
    }

    @Override
    int getType() {
        return this.type;
    }

    @Override
    int getConcurrency() {
        return 1008;
    }

    @Override
    int getHoldability() {
        return this.holdability;
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        if (this.rowCountCache != null && this.rowCountCache == 0) {
            return false;
        }
        return this.rowIndexValue == 0 && this.rowIndexSign == 1;
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        if (this.rowCountCache != null && this.rowCountCache == 0) {
            return false;
        }
        return this.rowIndexValue == 0 && this.rowIndexSign == -1;
    }

    @Override
    public boolean isFirst() throws SQLException {
        if (!this.isValidRow()) {
            return false;
        }
        if (this.rowIndexSign == 1) {
            return this.rowIndexValue == 1;
        }
        if (this.rowCountCache == null) {
            boolean isFirst = this.move("RELATIVE", -1) == 0;
            this.move("RELATIVE", 1);
            return isFirst;
        }
        return this.rowIndexValue == this.rowCountCache;
    }

    @Override
    public boolean isLast() throws SQLException {
        if (this.type == 1003) {
            throw new SQLFeatureNotSupportedException("cannot call isLast on forward-only cursors");
        }
        if (!this.isValidRow()) {
            return false;
        }
        if (this.rowIndexSign == -1) {
            return this.rowIndexValue == 1;
        }
        if (this.rowCountCache == null) {
            boolean isLast = this.move("RELATIVE", 1) == 0;
            this.move("RELATIVE", -1);
            return isLast;
        }
        return this.rowIndexValue == this.rowCountCache;
    }

    @Override
    public void beforeFirst() throws SQLException {
        this.move("ABSOLUTE", 0);
        this.setRowIndex(0, true);
    }

    @Override
    public void afterLast() throws SQLException {
        this.rowIndexValue += this.move("FORWARD", "ALL") * this.rowIndexSign;
    }

    @Override
    public boolean first() throws SQLException {
        if (this.fetch("FIRST", "")) {
            this.setRowIndex(1, true);
            return true;
        }
        this.setRowIndex(0, true);
        this.rowCountCache = 0;
        return false;
    }

    @Override
    public boolean last() throws SQLException {
        if (this.fetch("LAST", "")) {
            this.setRowIndex(1, false);
            return true;
        }
        this.setRowIndex(0, true);
        this.rowCountCache = 0;
        return false;
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        if (this.fetch("ABSOLUTE", row)) {
            this.setRowIndex(Math.abs(row), row > 0);
            return true;
        }
        if (row == 0) {
            this.setRowIndex(0, true);
        } else {
            this.setRowIndex(0, row < 0);
        }
        return false;
    }

    @Override
    public boolean relative(int rows) throws SQLException {
        if (this.fetch("RELATIVE", rows)) {
            this.rowIndexValue += rows * this.rowIndexSign;
            return true;
        }
        if (rows < 0) {
            this.setRowIndex(0, true);
        } else if (rows == 1) {
            if (this.rowIndexSign > 0) {
                this.rowCountCache = this.rowIndexValue;
            }
            this.setRowIndex(0, false);
        } else {
            this.setRowIndex(0, true);
        }
        return false;
    }

    @Override
    public boolean next() throws SQLException {
        return this.relative(1);
    }

    @Override
    boolean previous() throws SQLException {
        return this.relative(-1);
    }

    @Override
    void insert(Object[] updatedRowValues) throws SQLException {
        if (updatedRowValues == null) {
            throw new SQLException("not on update row");
        }
        if (this.resultFields.isEmpty() || this.resultFields.size() != updatedRowValues.length) {
            throw new SQLException("Invalid update row");
        }
        CompositeType relType = this.connection.getRegistry().loadRelationType(this.resultFields.get(0).getRelationId());
        StringBuilder sb = new StringBuilder("INSERT INTO ");
        sb.append('\"').append(relType.getName()).append('\"');
        sb.append(" VALUES (");
        Iterator<ResultField> fieldsIter = this.resultFields.iterator();
        int pid = 1;
        while (fieldsIter.hasNext()) {
            fieldsIter.next();
            sb.append("$");
            sb.append(pid++);
            sb.append(fieldsIter.hasNext() ? ", " : " ");
        }
        sb.append(")");
        this.connection.executeForRowsAffected(sb.toString(), true, updatedRowValues);
    }

    @Override
    void update(Object[] updatedRowValues) throws SQLException {
        if (updatedRowValues == null) {
            throw new SQLException("not on update row");
        }
        if (this.resultFields.size() != updatedRowValues.length) {
            throw new SQLException("Invalid update row");
        }
        CompositeType relType = this.connection.getRegistry().loadRelationType(this.resultFields.get(0).getRelationId());
        StringBuilder sb = new StringBuilder("UPDATE ");
        sb.append('\"').append(relType.getName()).append('\"');
        sb.append(" SET ");
        Iterator<ResultField> fieldsIter = this.resultFields.iterator();
        int pid = 1;
        while (fieldsIter.hasNext()) {
            sb.append(fieldsIter.next().getName());
            sb.append(" = $");
            sb.append(pid++);
            sb.append(fieldsIter.hasNext() ? ", " : " ");
        }
        sb.append("WHERE CURRENT OF ");
        sb.append(this.cursorName);
        this.connection.executeForRowsAffected(sb.toString(), true, updatedRowValues);
        this.setResult(new ParsedDataRow(updatedRowValues));
    }

    @Override
    void delete() throws SQLException {
        if (!this.isValidRow()) {
            throw Exceptions.ROW_INDEX_OUT_OF_BOUNDS;
        }
        CompositeType relType = this.connection.getRegistry().loadRelationType(this.resultFields.get(0).getRelationId());
        StringBuilder sb = new StringBuilder();
        sb.append("DELETE FROM ").append('\"').append(relType.getName()).append('\"').append(" WHERE CURRENT OF ").append(this.cursorName);
        long rows = this.connection.executeForRowsAffected(sb.toString(), true, new Object[0]);
        if (rows != 0L) {
            if (this.rowCountCache != null) {
                Integer n = this.rowCountCache;
                Integer n2 = this.rowCountCache = Integer.valueOf(this.rowCountCache - 1);
            }
            --this.rowIndexValue;
            this.refresh();
        }
    }

    @Override
    void refresh() throws SQLException {
        this.relative(0);
    }
}

