/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.jdbc;

import com.impossibl.postgres.api.jdbc.PGConnection;
import com.impossibl.postgres.jdbc.ConnectionUtil;
import com.impossibl.postgres.protocol.v30.ProtocolShared;
import com.impossibl.postgres.system.Context;
import com.impossibl.postgres.system.Version;
import java.sql.Driver;
import java.sql.DriverAction;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PGDriver
implements Driver,
DriverAction {
    public static final Version VERSION = Version.get(0, 1, 0);
    public static final Logger logger = Logger.getLogger(PGDriver.class.getName());
    private static PGDriver registered;

    @Override
    public PGConnection connect(String url, Properties info) throws SQLException {
        return ConnectionUtil.createConnection(url, info, true);
    }

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        return ConnectionUtil.parseURL(url) != null;
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        ArrayList<DriverPropertyInfo> propInfo = new ArrayList<DriverPropertyInfo>();
        ConnectionUtil.ConnectionSpecifier spec = ConnectionUtil.parseURL(url);
        if (spec == null) {
            spec = new ConnectionUtil.ConnectionSpecifier();
        }
        if (spec.getDatabase() == null || spec.getDatabase().isEmpty()) {
            propInfo.add(new DriverPropertyInfo("database", ""));
        }
        if (spec.getParameters().get("username") == null || spec.getParameters().get("username").toString().isEmpty()) {
            propInfo.add(new DriverPropertyInfo("username", ""));
        }
        if (spec.getParameters().get("password") == null || spec.getParameters().get("password").toString().isEmpty()) {
            propInfo.add(new DriverPropertyInfo("password", ""));
        }
        return propInfo.toArray(new DriverPropertyInfo[propInfo.size()]);
    }

    @Override
    public int getMajorVersion() {
        return 0;
    }

    @Override
    public int getMinorVersion() {
        return 1;
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return Logger.getLogger(Context.class.getPackage().getName());
    }

    @Override
    public void deregister() {
        PGDriver.cleanup();
    }

    public static void cleanup() {
        if (registered != null) {
            try {
                DriverManager.deregisterDriver(registered);
            }
            catch (SQLException e) {
                logger.log(Level.WARNING, "Error deregistering driver", e);
            }
        }
        ProtocolShared.acquire(null).get().waitForShutdown();
    }

    static {
        try {
            registered = new PGDriver();
            DriverManager.registerDriver(registered);
        }
        catch (SQLException e) {
            logger.log(Level.SEVERE, "Error registering driver", e);
        }
    }
}

