/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.protocol.ssl;

import com.impossibl.postgres.protocol.ssl.ContextCallbackHandler;
import com.impossibl.postgres.system.Context;
import java.io.Console;
import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;

public class ConsolePasswordCallbackHandler
implements ContextCallbackHandler {
    private char[] password;

    @Override
    public void init(Context conn) {
        String password = (String)((Object)conn.getSetting("sslPassword", String.class));
        if (password != null) {
            this.password = password.toCharArray();
        }
    }

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        Console cons = System.console();
        if (cons == null && this.password == null) {
            throw new UnsupportedCallbackException(callbacks[0], "Console is not available");
        }
        for (int i = 0; i < callbacks.length; ++i) {
            if (callbacks[i] instanceof PasswordCallback) {
                PasswordCallback passwordCallback = (PasswordCallback)callbacks[i];
                if (this.password == null) {
                    passwordCallback.setPassword(cons.readPassword("%s", ((PasswordCallback)callbacks[i]).getPrompt()));
                    continue;
                }
                passwordCallback.setPassword(this.password);
                continue;
            }
            throw new UnsupportedCallbackException(callbacks[i]);
        }
    }
}

