/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.system.procs;

import com.impossibl.postgres.system.Context;
import com.impossibl.postgres.system.procs.BinaryDecoder;
import com.impossibl.postgres.system.procs.BinaryEncoder;
import com.impossibl.postgres.system.procs.SimpleProcProvider;
import com.impossibl.postgres.system.procs.TextDecoder;
import com.impossibl.postgres.system.procs.TextEncoder;
import com.impossibl.postgres.types.PrimitiveType;
import com.impossibl.postgres.types.Type;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.text.ParseException;

public class Moneys
extends SimpleProcProvider {
    public Moneys() {
        super((Type.Codec.Encoder)new TxtEncoder(), (Type.Codec.Decoder)new TxtDecoder(), (Type.Codec.Encoder)new BinEncoder(), (Type.Codec.Decoder)new BinDecoder(), "cash_");
    }

    static int getFractionalDigits(Context context) {
        Object val = context.getSetting("field.money.fractionalDigits");
        if (val == null) {
            return 2;
        }
        return (Integer)val;
    }

    static class TxtEncoder
    extends TextEncoder {
        TxtEncoder() {
        }

        @Override
        public Class<?> getInputType() {
            return BigDecimal.class;
        }

        @Override
        public PrimitiveType getOutputPrimitiveType() {
            return PrimitiveType.Money;
        }

        @Override
        public void encode(Type type, StringBuilder buffer, Object val, Context context) throws IOException {
            buffer.append(context.getCurrencyFormatter().format(val));
        }
    }

    static class TxtDecoder
    extends TextDecoder {
        TxtDecoder() {
        }

        @Override
        public PrimitiveType getInputPrimitiveType() {
            return PrimitiveType.Money;
        }

        @Override
        public Class<?> getOutputType() {
            return BigDecimal.class;
        }

        @Override
        public BigDecimal decode(Type type, Short typeLength, Integer typeModifier, CharSequence buffer, Context context) throws IOException {
            try {
                return (BigDecimal)context.getCurrencyFormatter().parse(buffer.toString());
            }
            catch (ParseException e) {
                throw new IOException(e);
            }
        }
    }

    static class BinEncoder
    extends BinaryEncoder {
        BinEncoder() {
        }

        @Override
        public Class<?> getInputType() {
            return BigDecimal.class;
        }

        @Override
        public PrimitiveType getOutputPrimitiveType() {
            return PrimitiveType.Money;
        }

        @Override
        public void encode(Type type, ByteBuf buffer, Object val, Context context) throws IOException {
            if (val == null) {
                buffer.writeInt(-1);
            } else {
                int fracDigits = Moneys.getFractionalDigits(context);
                BigDecimal dec = (BigDecimal)val;
                dec = dec.setScale(fracDigits, RoundingMode.HALF_UP);
                buffer.writeInt(8);
                buffer.writeLong(dec.unscaledValue().longValue());
            }
        }
    }

    static class BinDecoder
    extends BinaryDecoder {
        BinDecoder() {
        }

        @Override
        public PrimitiveType getInputPrimitiveType() {
            return PrimitiveType.Money;
        }

        @Override
        public Class<?> getOutputType() {
            return BigDecimal.class;
        }

        @Override
        public BigDecimal decode(Type type, Short typeLength, Integer typeModifier, ByteBuf buffer, Context context) throws IOException {
            int length = buffer.readInt();
            if (length == -1) {
                return null;
            }
            if (length != 8) {
                throw new IOException("invalid length");
            }
            long val = buffer.readLong();
            int fracDigits = Moneys.getFractionalDigits(context);
            return new BigDecimal(BigInteger.valueOf(val), fracDigits);
        }
    }
}

