/*
 * Decompiled with CFR 0.152.
 */
package de.undercouch.citeproc.csl;

import de.undercouch.citeproc.csl.CSLPropertiesBuilder;
import de.undercouch.citeproc.helper.json.JsonBuilder;
import de.undercouch.citeproc.helper.json.JsonObject;
import java.util.Map;

public class CSLProperties
implements JsonObject {
    private final Integer noteIndex;
    private final Boolean unsorted;

    public CSLProperties() {
        this.noteIndex = 0;
        this.unsorted = null;
    }

    public CSLProperties(Integer noteIndex, Boolean unsorted) {
        this.noteIndex = noteIndex;
        this.unsorted = unsorted;
    }

    public Integer getNoteIndex() {
        return this.noteIndex;
    }

    public Boolean getUnsorted() {
        return this.unsorted;
    }

    @Override
    public Object toJson(JsonBuilder builder) {
        if (this.noteIndex != null) {
            builder.add("noteIndex", this.noteIndex);
        }
        if (this.unsorted != null) {
            builder.add("unsorted", this.unsorted);
        }
        return builder.build();
    }

    public static CSLProperties fromJson(Map<String, Object> obj) {
        CSLPropertiesBuilder builder = new CSLPropertiesBuilder();
        Object v = obj.get("noteIndex");
        if (v != null) {
            Integer noteIndex = CSLProperties.toInt(v);
            builder.noteIndex(noteIndex);
        } else {
            builder.noteIndex(0);
        }
        v = obj.get("unsorted");
        if (v != null) {
            Boolean unsorted = CSLProperties.toBool(v);
            builder.unsorted(unsorted);
        }
        return builder.build();
    }

    private static boolean isFalsy(Object o) {
        if (o == null) {
            return true;
        }
        if (Boolean.FALSE.equals(o)) {
            return true;
        }
        if ("".equals(o)) {
            return true;
        }
        if (Integer.valueOf(0).equals(o)) {
            return true;
        }
        if (Long.valueOf(0L).equals(o)) {
            return true;
        }
        if (o instanceof Float && (Float.valueOf(0.0f).equals(o) || ((Float)o).isNaN())) {
            return true;
        }
        if (o instanceof Double && (Double.valueOf(0.0).equals(o) || ((Double)o).isNaN())) {
            return true;
        }
        if (Byte.valueOf((byte)0).equals(o)) {
            return true;
        }
        return Short.valueOf((short)0).equals(o);
    }

    private static int toInt(Object o) {
        if (o instanceof CharSequence) {
            return Integer.parseInt(o.toString());
        }
        return ((Number)o).intValue();
    }

    private static boolean toBool(Object o) {
        if (o instanceof String) {
            return Boolean.parseBoolean((String)o);
        }
        if (o instanceof Number) {
            return ((Number)o).intValue() != 0;
        }
        return (Boolean)o;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.noteIndex == null ? 0 : this.noteIndex.hashCode());
        result = 31 * result + (this.unsorted == null ? 0 : this.unsorted.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CSLProperties)) {
            return false;
        }
        CSLProperties other = (CSLProperties)obj;
        if (this.noteIndex == null ? other.noteIndex != null : !this.noteIndex.equals(other.noteIndex)) {
            return false;
        }
        return !(this.unsorted == null ? other.unsorted != null : !this.unsorted.equals(other.unsorted));
    }
}

