/*
 * Decompiled with CFR 0.152.
 */
package org.controlsfx.control.table;

import impl.org.controlsfx.skin.ExpandableTableRowSkin;
import java.util.HashMap;
import java.util.Map;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Skin;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableRow;
import javafx.util.Callback;

public final class TableRowExpanderColumn<S>
extends TableColumn<S, Boolean> {
    private static final String STYLE_CLASS = "expander-column";
    private static final String EXPANDER_BUTTON_STYLE_CLASS = "expander-button";
    private final Map<S, Node> expandedNodeCache = new HashMap<S, Node>();
    private final Map<S, BooleanProperty> expansionState = new HashMap<S, BooleanProperty>();
    private Callback<TableRowDataFeatures<S>, Node> expandedNodeCallback;

    public BooleanProperty getExpandedProperty(S item) {
        Object value = this.expansionState.get(item);
        if (value == null) {
            value = new SimpleBooleanProperty(item, "expanded", false){

                protected void invalidated() {
                    TableRowExpanderColumn.this.getTableView().refresh();
                    if (!this.getValue().booleanValue()) {
                        TableRowExpanderColumn.this.expandedNodeCache.remove(this.getBean());
                    }
                }
            };
            this.expansionState.put(item, (BooleanProperty)value);
        }
        return value;
    }

    public Node getOrCreateExpandedNode(TableRow<S> tableRow) {
        int index = tableRow.getIndex();
        if (index > -1 && index < this.getTableView().getItems().size()) {
            Object item = this.getTableView().getItems().get(index);
            Node node = this.expandedNodeCache.get(item);
            if (node == null) {
                node = (Node)this.expandedNodeCallback.call(new TableRowDataFeatures<Object>(tableRow, this, item));
                this.expandedNodeCache.put(item, node);
            }
            return node;
        }
        return null;
    }

    public Node getExpandedNode(S item) {
        return this.expandedNodeCache.get(item);
    }

    public TableRowExpanderColumn(Callback<TableRowDataFeatures<S>, Node> expandedNodeCallback) {
        this.expandedNodeCallback = expandedNodeCallback;
        this.getStyleClass().add((Object)STYLE_CLASS);
        this.setCellValueFactory(param2 -> this.getExpandedProperty(param2.getValue()));
        this.setCellFactory(param2 -> new ToggleCell());
        this.installRowFactoryOnTableViewAssignment();
    }

    private void installRowFactoryOnTableViewAssignment() {
        this.tableViewProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue != null) {
                this.getTableView().setRowFactory(param2 -> new TableRow<S>(){

                    protected Skin<?> createDefaultSkin() {
                        return new ExpandableTableRowSkin(this, TableRowExpanderColumn.this);
                    }
                });
            }
        });
    }

    public void toggleExpanded(int index) {
        BooleanProperty expanded;
        expanded.setValue(Boolean.valueOf((expanded = (BooleanProperty)this.getCellObservableValue(index)).getValue() == false));
    }

    public static final class TableRowDataFeatures<S> {
        private TableRow<S> tableRow;
        private TableRowExpanderColumn<S> tableColumn;
        private BooleanProperty expandedProperty;
        private S value;

        public TableRowDataFeatures(TableRow<S> tableRow, TableRowExpanderColumn<S> tableColumn, S value) {
            this.tableRow = tableRow;
            this.tableColumn = tableColumn;
            this.expandedProperty = (BooleanProperty)tableColumn.getCellObservableValue(tableRow.getIndex());
            this.value = value;
        }

        public TableRow<S> getTableRow() {
            return this.tableRow;
        }

        public TableRowExpanderColumn<S> getTableColumn() {
            return this.tableColumn;
        }

        public BooleanProperty expandedProperty() {
            return this.expandedProperty;
        }

        public void toggleExpanded() {
            BooleanProperty expanded;
            expanded.setValue(Boolean.valueOf((expanded = this.expandedProperty()).getValue() == false));
        }

        public Boolean isExpanded() {
            return this.expandedProperty().getValue();
        }

        public void setExpanded(Boolean expanded) {
            this.expandedProperty().setValue(expanded);
        }

        public S getValue() {
            return this.value;
        }
    }

    private final class ToggleCell
    extends TableCell<S, Boolean> {
        private Button button = new Button();

        public ToggleCell() {
            this.button.setFocusTraversable(false);
            this.button.getStyleClass().add((Object)TableRowExpanderColumn.EXPANDER_BUTTON_STYLE_CLASS);
            this.button.setPrefSize(16.0, 16.0);
            this.button.setPadding(new Insets(0.0));
            this.button.setOnAction(event -> TableRowExpanderColumn.this.toggleExpanded(this.getIndex()));
        }

        protected void updateItem(Boolean expanded, boolean empty) {
            super.updateItem((Object)expanded, empty);
            if (expanded == null || empty) {
                this.setGraphic(null);
            } else {
                this.button.setText(expanded != false ? "-" : "+");
                this.setGraphic((Node)this.button);
            }
        }
    }
}

