/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.collab;

import javax.swing.JComponent;
import javax.swing.JLabel;
import org.jabref.gui.BasePanel;
import org.jabref.gui.collab.ChangeViewModel;
import org.jabref.gui.groups.GroupTreeNodeViewModel;
import org.jabref.gui.groups.UndoableModifySubtree;
import org.jabref.gui.undo.NamedCompound;
import org.jabref.logic.bibtex.comparator.GroupDiff;
import org.jabref.logic.groups.DefaultGroupsFactory;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.database.BibDatabase;
import org.jabref.model.groups.GroupTreeNode;

class GroupChangeViewModel
extends ChangeViewModel {
    private final GroupTreeNode changedGroups;
    private final GroupTreeNode tmpGroupRoot;

    public GroupChangeViewModel(GroupDiff diff) {
        super(diff.getOriginalGroupRoot() == null ? Localization.lang("Removed all groups", new String[0]) : Localization.lang("Modified groups tree", new String[0]));
        this.changedGroups = diff.getOriginalGroupRoot();
        this.tmpGroupRoot = diff.getNewGroupRoot();
    }

    @Override
    public boolean makeChange(BasePanel panel, BibDatabase secondary, NamedCompound undoEdit) {
        GroupTreeNode root = panel.getBibDatabaseContext().getMetaData().getGroups().orElse(null);
        if (root == null) {
            root = new GroupTreeNode(DefaultGroupsFactory.getAllEntriesGroup());
            panel.getBibDatabaseContext().getMetaData().setGroups(root);
        }
        UndoableModifySubtree undo = new UndoableModifySubtree(new GroupTreeNodeViewModel(panel.getBibDatabaseContext().getMetaData().getGroups().orElse(null)), new GroupTreeNodeViewModel(root), Localization.lang("Modified groups", new String[0]));
        root.removeAllChildren();
        if (this.changedGroups == null) {
            root.setGroup(DefaultGroupsFactory.getAllEntriesGroup());
        } else {
            root.setGroup(this.changedGroups.getGroup());
            for (GroupTreeNode child : this.changedGroups.getChildren()) {
                ((GroupTreeNode)child.copySubtree()).moveTo(root);
            }
        }
        undoEdit.addEdit(undo);
        if (this.tmpGroupRoot != null) {
            this.tmpGroupRoot.removeAllChildren();
            if (this.changedGroups != null) {
                GroupTreeNode copied = (GroupTreeNode)this.changedGroups.copySubtree();
                this.tmpGroupRoot.setGroup(copied.getGroup());
                for (GroupTreeNode child : copied.getChildren()) {
                    ((GroupTreeNode)child.copySubtree()).moveTo(this.tmpGroupRoot);
                }
            }
        }
        return true;
    }

    @Override
    public JComponent description() {
        return new JLabel("<html>" + this.toString() + '.' + (this.changedGroups == null ? "" : ' ' + Localization.lang("Accepting the change replaces the complete groups tree with the externally modified groups tree.", new String[0])) + "</html>");
    }
}

