/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.collab;

import javax.swing.JComponent;
import javax.swing.JScrollPane;
import org.jabref.gui.BasePanel;
import org.jabref.gui.collab.ChangeViewModel;
import org.jabref.gui.collab.InfoPane;
import org.jabref.gui.undo.NamedCompound;
import org.jabref.logic.bibtex.comparator.MetaDataDiff;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.database.BibDatabase;
import org.jabref.model.metadata.MetaData;

class MetaDataChangeViewModel
extends ChangeViewModel {
    private final InfoPane infoPane = new InfoPane();
    private final JScrollPane sp = new JScrollPane(this.infoPane);
    private final MetaData originalMetaData;
    private final MetaData newMetaData;

    public MetaDataChangeViewModel(MetaData originalMetaData, MetaDataDiff metaDataDiff) {
        super(Localization.lang("Metadata change", new String[0]));
        this.originalMetaData = originalMetaData;
        this.newMetaData = metaDataDiff.getNewMetaData();
        this.infoPane.setText("<html>" + Localization.lang("Metadata change", new String[0]) + "</html>");
    }

    @Override
    public JComponent description() {
        return this.sp;
    }

    @Override
    public boolean makeChange(BasePanel panel, BibDatabase secondary, NamedCompound undoEdit) {
        panel.getBibDatabaseContext().setMetaData(this.newMetaData);
        return true;
    }
}

