/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.copyfiles;

import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import javafx.concurrent.Task;
import org.jabref.Globals;
import org.jabref.gui.copyfiles.CopyFilesAction;
import org.jabref.gui.copyfiles.CopyFilesResultItemViewModel;
import org.jabref.logic.l10n.Localization;
import org.jabref.logic.util.OS;
import org.jabref.logic.util.io.FileUtil;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.LinkedFile;
import org.jabref.model.util.OptionalUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CopyFilesTask
extends Task<List<CopyFilesResultItemViewModel>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CopyFilesAction.class);
    private static final String LOGFILE_PREFIX = "copyFileslog_";
    private static final String LOGFILE_EXT = ".log";
    private final BibDatabaseContext databaseContext;
    private final Path exportPath;
    private final String localizedSucessMessage = Localization.lang("Copied file successfully", new String[0]);
    private final String localizedErrorMessage = Localization.lang("Could not copy file", new String[0]) + ": " + Localization.lang("File exists", new String[0]);
    private final long totalFilesCount;
    private final List<BibEntry> entries;
    private final List<CopyFilesResultItemViewModel> results = new ArrayList<CopyFilesResultItemViewModel>();
    private Optional<Path> newPath = Optional.empty();
    private int numberSucessful;
    private int totalFilesCounter;
    private final BiFunction<Path, Path, Path> resolvePathFilename = (path, file) -> path.resolve(file.getFileName());

    public CopyFilesTask(BibDatabaseContext databaseContext, List<BibEntry> entries, Path path2) {
        this.databaseContext = databaseContext;
        this.entries = entries;
        this.exportPath = path2;
        this.totalFilesCount = entries.stream().flatMap(entry -> entry.getFiles().stream()).count();
    }

    protected List<CopyFilesResultItemViewModel> call() throws InterruptedException, IOException {
        this.updateMessage(Localization.lang("Copying files...", new String[0]));
        this.updateProgress(0L, this.totalFilesCount);
        LocalDateTime currentTime = LocalDateTime.now();
        String currentDate = currentTime.format(DateTimeFormatter.ofPattern("yyyy-MM-dd-HH-mm-ss"));
        try (BufferedWriter bw = Files.newBufferedWriter(this.exportPath.resolve(LOGFILE_PREFIX + currentDate + LOGFILE_EXT), StandardCharsets.UTF_8, new OpenOption[0]);){
            for (int i = 0; i < this.entries.size(); ++i) {
                List<LinkedFile> files = this.entries.get(i).getFiles();
                for (int j = 0; j < files.size(); ++j) {
                    this.updateMessage(Localization.lang("Copying file %0 of entry %1", Integer.toString(j + 1), Integer.toString(i + 1)));
                    LinkedFile fileName = files.get(j);
                    Optional<Path> fileToExport = fileName.findIn(this.databaseContext, Globals.prefs.getFileDirectoryPreferences());
                    this.newPath = OptionalUtil.combine(Optional.of(this.exportPath), fileToExport, this.resolvePathFilename);
                    this.newPath.ifPresent(newFile -> {
                        boolean success = FileUtil.copyFile((Path)fileToExport.get(), newFile, false);
                        this.updateProgress(this.totalFilesCounter++, this.totalFilesCount);
                        try {
                            Thread.sleep(300L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                        if (success) {
                            this.updateMessage(this.localizedSucessMessage);
                            ++this.numberSucessful;
                            this.writeLogMessage((Path)newFile, bw, this.localizedSucessMessage);
                            this.addResultToList((Path)newFile, success, this.localizedSucessMessage);
                        } else {
                            this.updateMessage(this.localizedErrorMessage);
                            this.writeLogMessage((Path)newFile, bw, this.localizedErrorMessage);
                            this.addResultToList((Path)newFile, success, this.localizedErrorMessage);
                        }
                    });
                }
            }
            this.updateMessage(Localization.lang("Finished copying", new String[0]));
            String sucessMessage = Localization.lang("Copied %0 files of %1 sucessfully to %2", Integer.toString(this.numberSucessful), Integer.toString(this.totalFilesCounter), this.newPath.map(Path::getParent).map(Path::toString).orElse(""));
            this.updateMessage(sucessMessage);
            bw.write(sucessMessage);
            List<CopyFilesResultItemViewModel> list = this.results;
            return list;
        }
    }

    private void writeLogMessage(Path newFile, BufferedWriter bw, String logMessage) {
        try {
            bw.write(logMessage + ": " + newFile);
            bw.write(OS.NEWLINE);
        }
        catch (IOException e) {
            LOGGER.error("error writing log file", e);
        }
    }

    private void addResultToList(Path newFile, boolean success, String logMessage) {
        CopyFilesResultItemViewModel result = new CopyFilesResultItemViewModel(newFile, success, logMessage);
        this.results.add(result);
    }
}

