/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.documentviewer;

import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ListProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleListProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.fxmisc.easybind.EasyBind;
import org.jabref.Globals;
import org.jabref.gui.AbstractViewModel;
import org.jabref.gui.StateManager;
import org.jabref.gui.documentviewer.DocumentViewModel;
import org.jabref.gui.documentviewer.PdfDocumentViewModel;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.LinkedFile;

public class DocumentViewerViewModel
extends AbstractViewModel {
    private StateManager stateManager;
    private ObjectProperty<DocumentViewModel> currentDocument = new SimpleObjectProperty();
    private ListProperty<LinkedFile> files = new SimpleListProperty();
    private BooleanProperty liveMode = new SimpleBooleanProperty();
    private ObjectProperty<Integer> currentPage = new SimpleObjectProperty();
    private IntegerProperty maxPages = new SimpleIntegerProperty();

    public DocumentViewerViewModel(StateManager stateManager) {
        this.stateManager = Objects.requireNonNull(stateManager);
        this.stateManager.getSelectedEntries().addListener(c -> {
            if (this.isLiveMode()) {
                this.setCurrentEntries((List<BibEntry>)this.stateManager.getSelectedEntries());
            }
        });
        this.liveMode.addListener((observable, oldValue, newValue) -> {
            if (oldValue != newValue && newValue.booleanValue()) {
                this.setCurrentEntries((List<BibEntry>)this.stateManager.getSelectedEntries());
            }
        });
        this.maxPages.bindBidirectional(EasyBind.monadic(this.currentDocument).selectProperty(DocumentViewModel::maxPagesProperty));
        this.setCurrentEntries((List<BibEntry>)this.stateManager.getSelectedEntries());
    }

    private int getCurrentPage() {
        return (Integer)this.currentPage.get();
    }

    public ObjectProperty<Integer> currentPageProperty() {
        return this.currentPage;
    }

    public IntegerProperty maxPagesProperty() {
        return this.maxPages;
    }

    private boolean isLiveMode() {
        return this.liveMode.get();
    }

    public ObjectProperty<DocumentViewModel> currentDocumentProperty() {
        return this.currentDocument;
    }

    public ListProperty<LinkedFile> filesProperty() {
        return this.files;
    }

    private void setCurrentEntries(List<BibEntry> entries) {
        if (!entries.isEmpty()) {
            BibEntry firstSelectedEntry = entries.get(0);
            this.setCurrentEntry(firstSelectedEntry);
        }
    }

    private void setCurrentEntry(BibEntry entry) {
        this.stateManager.getActiveDatabase().ifPresent(database -> {
            List<LinkedFile> linkedFiles = entry.getFiles();
            this.files.setValue(FXCollections.observableArrayList(linkedFiles));
        });
    }

    private void setCurrentDocument(Path path) {
        try {
            this.currentDocument.set((Object)new PdfDocumentViewModel(PDDocument.load(path.toFile())));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void switchToFile(LinkedFile file) {
        if (file != null) {
            this.stateManager.getActiveDatabase().ifPresent(database -> file.findIn((BibDatabaseContext)database, Globals.prefs.getFileDirectoryPreferences()).ifPresent(this::setCurrentDocument));
        }
    }

    public BooleanProperty liveModeProperty() {
        return this.liveMode;
    }

    public void showNextPage() {
        this.currentPage.set((Object)(this.getCurrentPage() + 1));
    }

    public void showPreviousPage() {
        this.currentPage.set((Object)(this.getCurrentPage() - 1));
    }
}

