/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.documentviewer;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Objects;
import javafx.embed.swing.SwingFXUtils;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.rendering.ImageType;
import org.apache.pdfbox.rendering.PDFRenderer;
import org.jabref.gui.documentviewer.DocumentPageViewModel;

public class PdfDocumentPageViewModel
extends DocumentPageViewModel {
    private final PDPage page;
    private final int pageNumber;
    private final PDDocument document;

    public PdfDocumentPageViewModel(PDPage page, int pageNumber, PDDocument document) {
        this.page = Objects.requireNonNull(page);
        this.pageNumber = pageNumber;
        this.document = document;
    }

    private static BufferedImage resize(BufferedImage img, int newWidth, int newHeight) {
        Image tmp = img.getScaledInstance(newWidth, newHeight, 4);
        BufferedImage dimg = new BufferedImage(newWidth, newHeight, 2);
        Graphics2D g2d = dimg.createGraphics();
        g2d.drawImage(tmp, 0, 0, null);
        g2d.dispose();
        return dimg;
    }

    @Override
    public javafx.scene.image.Image render(int width, int height) {
        PDFRenderer renderer = new PDFRenderer(this.document);
        try {
            int resolution = 96;
            BufferedImage image = renderer.renderImageWithDPI(this.pageNumber, 2 * resolution, ImageType.RGB);
            return SwingFXUtils.toFXImage((BufferedImage)PdfDocumentPageViewModel.resize(image, width, height), null);
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public int getPageNumber() {
        return this.pageNumber;
    }

    @Override
    public double getAspectRatio() {
        PDRectangle mediaBox = this.page.getMediaBox();
        return mediaBox.getWidth() / mediaBox.getHeight();
    }
}

