/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.entryeditor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jabref.Globals;

public final class EntryEditorTabList {
    private List<List<String>> list;
    private List<String> names;

    public EntryEditorTabList() {
        this.init();
    }

    private void init() {
        this.list = new ArrayList<List<String>>();
        this.names = new ArrayList<String>();
        int i = 0;
        if (Globals.prefs.hasKey("customTabName_0")) {
            while (Globals.prefs.hasKey("customTabName_" + i)) {
                String name = Globals.prefs.get("customTabName_" + i);
                List<String> entry = Arrays.asList(Globals.prefs.get("customTabFields_" + i).split(";"));
                this.names.add(name);
                this.list.add(entry);
                ++i;
            }
        } else {
            while (Globals.prefs.get("customTabName__def" + i) != null) {
                String name = Globals.prefs.get("customTabName__def" + i);
                List<String> entry = Arrays.asList(Globals.prefs.get("customTabFields__def" + i).split(";"));
                this.names.add(name);
                this.list.add(entry);
                ++i;
            }
        }
    }

    public int getTabCount() {
        return this.list.size();
    }

    public String getTabName(int tab) {
        return this.names.get(tab);
    }

    public List<String> getTabFields(int tab) {
        return this.list.get(tab);
    }
}

