/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.entryeditor;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javafx.scene.control.Tooltip;
import javax.swing.undo.UndoManager;
import org.jabref.Globals;
import org.jabref.gui.IconTheme;
import org.jabref.gui.autocompleter.SuggestionProviders;
import org.jabref.gui.entryeditor.FieldsEditorTab;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.EntryType;

public class OtherFieldsTab
extends FieldsEditorTab {
    public OtherFieldsTab(BibDatabaseContext databaseContext, SuggestionProviders suggestionProviders, UndoManager undoManager) {
        super(false, databaseContext, suggestionProviders, undoManager);
        this.setText(Localization.lang("Other fields", new String[0]));
        this.setTooltip(new Tooltip(Localization.lang("Show remaining fields", new String[0])));
        this.setGraphic(IconTheme.JabRefIcon.OPTIONAL.getGraphicNode());
    }

    @Override
    protected Collection<String> determineFieldsToShow(BibEntry entry, EntryType entryType) {
        List allKnownFields = entryType.getAllFields().stream().map(String::toLowerCase).collect(Collectors.toList());
        List<String> otherFields = entry.getFieldNames().stream().map(String::toLowerCase).filter(field2 -> !allKnownFields.contains(field2)).collect(Collectors.toList());
        otherFields.removeAll(entryType.getDeprecatedFields());
        otherFields.remove("bibtexkey");
        otherFields.removeAll(Globals.prefs.getCustomTabFieldNames());
        return otherFields;
    }
}

