/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.exporter;

import java.awt.Toolkit;
import java.awt.datatransfer.ClipboardOwner;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.JList;
import javax.swing.JOptionPane;
import org.jabref.Globals;
import org.jabref.gui.BasePanel;
import org.jabref.gui.JabRefFrame;
import org.jabref.gui.exporter.RtfTransferable;
import org.jabref.gui.worker.AbstractWorker;
import org.jabref.logic.exporter.Exporter;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.entry.BibEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExportToClipboardAction
extends AbstractWorker {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExportToClipboardAction.class);
    private final JabRefFrame frame;
    private String message;

    public ExportToClipboardAction(JabRefFrame frame) {
        this.frame = Objects.requireNonNull(frame);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        BasePanel panel = this.frame.getCurrentBasePanel();
        if (panel == null) {
            return;
        }
        if (panel.getSelectedEntries().isEmpty()) {
            this.message = Localization.lang("This operation requires one or more entries to be selected.", new String[0]);
            this.getCallBack().update();
            return;
        }
        List sortedExporters = Globals.exportFactory.getExporters().stream().sorted(Comparator.comparing(Exporter::getName)).collect(Collectors.toList());
        List<String> exportFormatDisplayNames = sortedExporters.stream().map(Exporter::getName).collect(Collectors.toList());
        JList<String> list = new JList<String>(exportFormatDisplayNames.toArray(new String[exportFormatDisplayNames.size()]));
        list.setBorder(BorderFactory.createEtchedBorder());
        list.setSelectionInterval(0, 0);
        list.setSelectionMode(0);
        int answer = JOptionPane.showOptionDialog(this.frame, list, Localization.lang("Select export format", new String[0]), 0, 3, null, new String[]{Localization.lang("Export", new String[0]), Localization.lang("Cancel", new String[0])}, Localization.lang("Export", new String[0]));
        if (answer == 1) {
            return;
        }
        Exporter exporter = (Exporter)sortedExporters.get(list.getSelectedIndex());
        Globals.prefs.fileDirForDatabase = this.frame.getCurrentBasePanel().getBibDatabaseContext().getFileDirectories(Globals.prefs.getFileDirectoryPreferences());
        File tmp = null;
        try {
            tmp = File.createTempFile("jabrefCb", ".tmp");
            tmp.deleteOnExit();
            List<BibEntry> entries = panel.getSelectedEntries();
            exporter.export(panel.getBibDatabaseContext(), tmp.toPath(), panel.getBibDatabaseContext().getMetaData().getEncoding().orElse(Globals.prefs.getDefaultEncoding()), entries);
            StringBuilder sb = new StringBuilder();
            try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(tmp), panel.getBibDatabaseContext().getMetaData().getEncoding().orElse(Globals.prefs.getDefaultEncoding()));){
                int s2;
                while ((s2 = ((Reader)reader).read()) != -1) {
                    sb.append((char)s2);
                }
            }
            ClipboardOwner owner = (clipboard, content) -> {};
            RtfTransferable rs = new RtfTransferable(sb.toString());
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(rs, owner);
            this.message = Localization.lang("Entries exported to clipboard", new String[0]) + ": " + entries.size();
        }
        catch (Exception e) {
            LOGGER.error("Error exporting to clipboard", e);
            this.message = Localization.lang("Error exporting to clipboard", new String[0]);
        }
        finally {
            if (tmp != null && !tmp.delete()) {
                LOGGER.info("Cannot delete temporary clipboard file");
            }
        }
    }

    @Override
    public void update() {
        this.frame.output(this.message);
    }
}

