/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.externalfiletype;

import java.util.Objects;
import javax.swing.Icon;
import javax.swing.JLabel;
import org.jabref.gui.IconTheme;
import org.jabref.gui.externalfiletype.ExternalFileTypes;

public class ExternalFileType
implements Comparable<ExternalFileType> {
    private String name;
    private String extension;
    private String openWith;
    private String iconName;
    private String mimeType;
    private Icon icon;
    private final JLabel label = new JLabel();

    public ExternalFileType(String name, String extension, String mimeType, String openWith, String iconName, Icon icon) {
        this.label.setText(null);
        this.name = name;
        this.label.setToolTipText(this.name);
        this.extension = extension;
        this.mimeType = mimeType;
        this.openWith = openWith;
        this.setIconName(iconName);
        this.setIcon(icon);
    }

    public static ExternalFileType buildFromArgs(String[] val) {
        String iconName;
        String openWith;
        String mimeType;
        if (val == null || val.length < 4 || val.length > 5) {
            throw new IllegalArgumentException("Cannot construct ExternalFileType without four elements in String[] argument.");
        }
        String name = val[0];
        String extension = val[1];
        if (val.length == 4) {
            mimeType = "";
            openWith = val[2];
            iconName = val[3];
        } else {
            mimeType = val[2];
            openWith = val[3];
            iconName = val[4];
        }
        Icon icon = IconTheme.JabRefIcon.FILE.getSmallIcon();
        for (ExternalFileType fileType : ExternalFileTypes.getDefaultExternalFileTypes()) {
            if (!fileType.getName().equals(name)) continue;
            icon = fileType.icon;
            break;
        }
        return new ExternalFileType(name, extension, mimeType, openWith, iconName, icon);
    }

    public String[] getStringArrayRepresentation() {
        return new String[]{this.name, this.extension, this.mimeType, this.openWith, this.iconName};
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this.label.setToolTipText(this.name);
    }

    public String getExtension() {
        if (this.extension == null) {
            return "";
        }
        return this.extension;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }

    public String getMimeType() {
        if (this.mimeType == null) {
            return "";
        }
        return this.mimeType;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public String getFieldName() {
        return this.extension;
    }

    public String getOpenWithApplication() {
        if (this.openWith == null) {
            return "";
        }
        return this.openWith;
    }

    public void setOpenWith(String openWith) {
        this.openWith = openWith;
    }

    public void setIconName(String name) {
        this.iconName = name;
    }

    public JLabel getIconLabel() {
        return this.label;
    }

    public String getIconName() {
        return this.iconName;
    }

    public Icon getIcon() {
        return this.icon;
    }

    public void setIcon(Icon icon) {
        this.icon = icon;
        this.label.setIcon(this.icon);
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public int compareTo(ExternalFileType o) {
        return this.getName().compareTo(o.getName());
    }

    public ExternalFileType copy() {
        return new ExternalFileType(this.name, this.extension, this.mimeType, this.openWith, this.iconName, this.icon);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.extension, this.mimeType, this.openWith, this.iconName);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof ExternalFileType) {
            ExternalFileType other = (ExternalFileType)object;
            return Objects.equals(this.name, other.name) && Objects.equals(this.extension, other.extension) && Objects.equals(this.mimeType, other.mimeType) && Objects.equals(this.openWith, other.openWith) && Objects.equals(this.iconName, other.iconName);
        }
        return false;
    }
}

