/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.mergeentries;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.Component;
import java.awt.Font;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import javafx.embed.swing.JFXPanel;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import org.jabref.Globals;
import org.jabref.gui.PreviewPanel;
import org.jabref.gui.customjfx.CustomJFXPanel;
import org.jabref.gui.util.component.DiffHighlightingTextPane;
import org.jabref.logic.bibtex.BibEntryWriter;
import org.jabref.logic.bibtex.LatexFieldFormatter;
import org.jabref.logic.formatter.casechanger.SentenceCaseFormatter;
import org.jabref.logic.l10n.Localization;
import org.jabref.logic.util.strings.DiffHighlighting;
import org.jabref.model.database.BibDatabaseMode;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.InternalBibtexFields;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MergeEntries {
    private static final Logger LOGGER = LoggerFactory.getLogger(MergeEntries.class);
    private static final String MARGIN = "10px";
    private static final List<JLabel> HEADING_LABELS = new ArrayList<JLabel>(6);
    private static final CellConstraints CELL_CONSTRAINTS = new CellConstraints();
    private static final String[] DIFF_MODES = new String[]{Localization.lang("Plain text", new String[0]), Localization.lang("Show diff", new String[0]) + " - " + Localization.lang("word", new String[0]), Localization.lang("Show diff", new String[0]) + " - " + Localization.lang("character", new String[0]), Localization.lang("Show symmetric diff", new String[0]) + " - " + Localization.lang("word", new String[0]), Localization.lang("Show symmetric diff", new String[0]) + " - " + Localization.lang("character", new String[0])};
    private final List<String> columnHeadings = Arrays.asList(Localization.lang("Field", new String[0]), Localization.lang("Left entry", new String[0]), Localization.lang("Left", new String[0]), Localization.lang("None", new String[0]), Localization.lang("Right", new String[0]), Localization.lang("Right entry", new String[0]));
    private final Set<String> identicalFields = new HashSet<String>();
    private final Set<String> differentFields = new HashSet<String>();
    private final BibEntry mergedEntry = new BibEntry();
    private final BibEntry leftEntry;
    private final BibEntry rightEntry;
    private final BibDatabaseMode databaseType;
    private JScrollPane scrollPane;
    private JTextArea sourceView;
    private PreviewPanel entryPreview;
    private Boolean doneBuilding;
    private Boolean identicalTypes;
    private List<JRadioButton> typeRadioButtons;
    private final Set<String> allFields = new TreeSet<String>();
    private final JComboBox<String> diffMode = new JComboBox();
    private final Map<String, JTextPane> leftTextPanes = new HashMap<String, JTextPane>();
    private final Map<String, JTextPane> rightTextPanes = new HashMap<String, JTextPane>();
    private final Map<String, List<JRadioButton>> radioButtons = new HashMap<String, List<JRadioButton>>();
    private final JPanel mainPanel = new JPanel();

    public MergeEntries(BibEntry entryLeft, BibEntry entryRight, BibDatabaseMode type) {
        this.leftEntry = entryLeft;
        this.rightEntry = entryRight;
        this.databaseType = type;
        this.initialize();
    }

    public MergeEntries(BibEntry entryLeft, BibEntry entryRight, String headingLeft, String headingRight, BibDatabaseMode type) {
        this.columnHeadings.set(1, headingLeft);
        this.columnHeadings.set(5, headingRight);
        this.leftEntry = entryLeft;
        this.rightEntry = entryRight;
        this.databaseType = type;
        this.initialize();
    }

    private void initialize() {
        this.doneBuilding = false;
        this.setupFields();
        this.fillDiffModes();
        String colSpecMain = "left:pref, 5px, center:3cm:grow, 5px, center:pref, 3px, center:pref, 3px, center:pref, 5px, center:3cm:grow";
        String colSpecMerge = "left:pref, 5px, fill:3cm:grow, 5px, center:pref, 3px, center:pref, 3px, center:pref, 5px, fill:3cm:grow";
        String rowSpec = "pref, pref, 10px, fill:5cm:grow, 10px, pref, 10px, fill:3cm:grow";
        StringBuilder rowBuilder = new StringBuilder("");
        for (int i = 0; i < this.allFields.size(); ++i) {
            rowBuilder.append("pref, 2dlu, ");
        }
        rowBuilder.append("pref");
        JPanel mergePanel = new JPanel();
        FormLayout mainLayout = new FormLayout(colSpecMain, rowSpec);
        FormLayout mergeLayout = new FormLayout(colSpecMerge, rowBuilder.toString());
        this.mainPanel.setLayout(mainLayout);
        mergePanel.setLayout(mergeLayout);
        this.setupHeadingRows();
        this.mainPanel.add((Component)new JSeparator(), CELL_CONSTRAINTS.xyw(1, 3, 11));
        this.setupEntryTypeRow(mergePanel);
        int maxLabelWidth = this.setupFieldRows(mergePanel);
        this.scrollPane = new JScrollPane(mergePanel, 20, 31);
        this.scrollPane.setBorder(BorderFactory.createEmptyBorder());
        this.updateTextPanes(this.allFields);
        this.mainPanel.add((Component)this.scrollPane, CELL_CONSTRAINTS.xyw(1, 4, 11));
        this.mainPanel.add((Component)new JSeparator(), CELL_CONSTRAINTS.xyw(1, 5, 11));
        this.synchronizeColumnWidths(mainLayout, mergeLayout, maxLabelWidth);
        this.mainPanel.add((Component)this.boldFontLabel(Localization.lang("Merged entry", new String[0])), CELL_CONSTRAINTS.xyw(1, 6, 6));
        this.entryPreview = new PreviewPanel(null, null);
        this.entryPreview.setEntry(this.mergedEntry);
        JFXPanel container = CustomJFXPanel.wrap(new Scene((Parent)this.entryPreview));
        this.mainPanel.add((Component)container, CELL_CONSTRAINTS.xyw(1, 8, 6));
        this.mainPanel.add((Component)this.boldFontLabel(Localization.lang("Merged BibTeX source code", new String[0])), CELL_CONSTRAINTS.xyw(8, 6, 4));
        this.sourceView = new JTextArea();
        this.sourceView.setLineWrap(true);
        this.sourceView.setFont(new Font("Monospaced", 0, Globals.prefs.getInt("fontSize")));
        this.mainPanel.add((Component)new JScrollPane(this.sourceView), CELL_CONSTRAINTS.xyw(8, 8, 4));
        this.sourceView.setEditable(false);
        mainLayout.appendRow(RowSpec.decode(MARGIN));
        mainLayout.appendColumn(ColumnSpec.decode(MARGIN));
        mainLayout.insertRow(1, RowSpec.decode(MARGIN));
        mainLayout.insertColumn(1, ColumnSpec.decode(MARGIN));
        this.doneBuilding = true;
        this.updateAll();
        this.mainPanel.setVisible(true);
        SwingUtilities.invokeLater(() -> this.scrollPane.getVerticalScrollBar().setValue(0));
    }

    private int setupFieldRows(JPanel mergePanel) {
        int row = 2;
        int maxLabelWidth = -1;
        for (String field2 : this.allFields) {
            DiffHighlightingTextPane tf;
            JLabel label = this.boldFontLabel(new SentenceCaseFormatter().format(field2));
            mergePanel.add((Component)label, CELL_CONSTRAINTS.xy(1, 2 * row - 1, "left, top"));
            Optional<String> leftString = this.leftEntry.getField(field2);
            Optional<String> rightString = this.rightEntry.getField(field2);
            if (leftString.equals(rightString)) {
                this.identicalFields.add(field2);
            } else {
                this.differentFields.add(field2);
            }
            maxLabelWidth = Math.max(maxLabelWidth, label.getPreferredSize().width);
            if (leftString.isPresent()) {
                tf = new DiffHighlightingTextPane();
                mergePanel.add((Component)tf, CELL_CONSTRAINTS.xy(3, 2 * row - 1, "f, f"));
                this.leftTextPanes.put(field2, tf);
            }
            if (this.identicalFields.contains(field2)) {
                this.mergedEntry.setField(field2, leftString.get());
            } else {
                ButtonGroup group = new ButtonGroup();
                ArrayList<JRadioButton> list = new ArrayList<JRadioButton>(3);
                for (int k = 0; k < 3; ++k) {
                    JRadioButton button = new JRadioButton();
                    group.add(button);
                    mergePanel.add((Component)button, CELL_CONSTRAINTS.xy(5 + k * 2, 2 * row - 1));
                    button.addChangeListener(e -> this.updateAll());
                    list.add(button);
                }
                this.radioButtons.put(field2, list);
                if (leftString.isPresent()) {
                    ((JRadioButton)list.get(0)).setSelected(true);
                    if (!rightString.isPresent()) {
                        ((JRadioButton)list.get(2)).setEnabled(false);
                    }
                } else {
                    ((JRadioButton)list.get(0)).setEnabled(false);
                    ((JRadioButton)list.get(2)).setSelected(true);
                }
            }
            if (rightString.isPresent()) {
                tf = new DiffHighlightingTextPane();
                mergePanel.add((Component)tf, CELL_CONSTRAINTS.xy(11, 2 * row - 1, "f, f"));
                this.rightTextPanes.put(field2, tf);
            }
            ++row;
        }
        return maxLabelWidth;
    }

    private void setupEntryTypeRow(JPanel mergePanel) {
        mergePanel.add((Component)this.boldFontLabel(Localization.lang("Entry type", new String[0])), CELL_CONSTRAINTS.xy(1, 1));
        DiffHighlightingTextPane leftTypeDisplay = new DiffHighlightingTextPane();
        leftTypeDisplay.setText("<html><body>" + this.leftEntry.getType() + "</body></html>");
        mergePanel.add((Component)leftTypeDisplay, CELL_CONSTRAINTS.xy(3, 1));
        if (this.leftEntry.getType().equals(this.rightEntry.getType())) {
            this.identicalTypes = true;
        } else {
            this.identicalTypes = false;
            ButtonGroup group = new ButtonGroup();
            this.typeRadioButtons = new ArrayList<JRadioButton>(2);
            for (int k = 0; k < 3; k += 2) {
                JRadioButton button = new JRadioButton();
                this.typeRadioButtons.add(button);
                group.add(button);
                mergePanel.add((Component)button, CELL_CONSTRAINTS.xy(5 + k * 2, 1));
                button.addChangeListener(e -> this.updateAll());
            }
            this.typeRadioButtons.get(0).setSelected(true);
        }
        DiffHighlightingTextPane rightTypeDisplay = new DiffHighlightingTextPane();
        rightTypeDisplay.setText("<html><body>" + this.rightEntry.getType() + "</body></html>");
        mergePanel.add((Component)rightTypeDisplay, CELL_CONSTRAINTS.xy(11, 1));
    }

    private void setupHeadingRows() {
        this.mainPanel.add((Component)this.boldFontLabel(Localization.lang("Use", new String[0])), CELL_CONSTRAINTS.xyw(4, 1, 7, "center, bottom"));
        this.mainPanel.add(this.diffMode, CELL_CONSTRAINTS.xy(11, 1, "right, bottom"));
        for (int i = 0; i < 6; ++i) {
            HEADING_LABELS.add(this.boldFontLabel(this.columnHeadings.get(i)));
            this.mainPanel.add((Component)HEADING_LABELS.get(i), CELL_CONSTRAINTS.xy(1 + i * 2, 2));
        }
    }

    private void fillDiffModes() {
        for (String diffText : DIFF_MODES) {
            this.diffMode.addItem(diffText);
        }
        this.diffMode.setSelectedIndex(Math.min(Globals.prefs.getInt("mergeEntriesDiffMode"), this.diffMode.getItemCount() - 1));
        this.diffMode.addActionListener(e -> {
            this.updateTextPanes(this.differentFields);
            this.storePreference();
        });
    }

    private void synchronizeColumnWidths(FormLayout mainLayout, FormLayout mergeLayout, int maxLabelWidth) {
        int k;
        String[] rbAlign = new String[]{"right", "center", "left"};
        mainLayout.setColumnSpec(1, ColumnSpec.decode(Integer.toString(maxLabelWidth) + "px"));
        Integer maxRBWidth = -1;
        for (k = 2; k < 5; ++k) {
            maxRBWidth = Math.max(maxRBWidth, MergeEntries.HEADING_LABELS.get((int)k).getPreferredSize().width);
        }
        for (k = 0; k < 3; ++k) {
            mergeLayout.setColumnSpec(5 + k * 2, ColumnSpec.decode(rbAlign[k] + ":" + maxRBWidth + "px"));
        }
    }

    private JLabel boldFontLabel(String text) {
        JLabel label = new JLabel(text);
        Font font = label.getFont();
        label.setFont(font.deriveFont(font.getStyle() | 1));
        return label;
    }

    private void storePreference() {
        Globals.prefs.putInt("mergeEntriesDiffMode", this.diffMode.getSelectedIndex());
    }

    private void setupFields() {
        this.allFields.addAll(this.leftEntry.getFieldNames());
        this.allFields.addAll(this.rightEntry.getFieldNames());
        TreeSet<String> toberemoved = new TreeSet<String>();
        for (String field2 : this.allFields) {
            if (!InternalBibtexFields.isInternalField(field2)) continue;
            toberemoved.add(field2);
        }
        this.allFields.removeAll(toberemoved);
    }

    private void updateTextPanes(Collection<String> fields) {
        int oldScrollPaneValue = this.scrollPane.getVerticalScrollBar().getValue();
        for (String field2 : fields) {
            String leftString = this.leftEntry.getField(field2).orElse("");
            String rightString = this.rightEntry.getField(field2).orElse("");
            switch (this.diffMode.getSelectedIndex()) {
                case 0: {
                    break;
                }
                case 1: {
                    rightString = DiffHighlighting.generateDiffHighlighting(leftString, rightString, " ");
                    break;
                }
                case 2: {
                    rightString = DiffHighlighting.generateDiffHighlighting(leftString, rightString, "");
                    break;
                }
                case 3: {
                    String tmpLeftString = DiffHighlighting.generateSymmetricHighlighting(leftString, rightString, " ");
                    rightString = DiffHighlighting.generateSymmetricHighlighting(rightString, leftString, " ");
                    leftString = tmpLeftString;
                    break;
                }
                case 4: {
                    String tmpLeftString = DiffHighlighting.generateSymmetricHighlighting(leftString, rightString, "");
                    rightString = DiffHighlighting.generateSymmetricHighlighting(rightString, leftString, "");
                    leftString = tmpLeftString;
                    break;
                }
            }
            if (leftString != null && this.leftTextPanes.containsKey(field2)) {
                this.leftTextPanes.get(field2).setText("<html><body>" + leftString + "</body></html>");
            }
            if (rightString == null || !this.rightTextPanes.containsKey(field2)) continue;
            this.rightTextPanes.get(field2).setText("<html><body>" + rightString + "</body></html>");
        }
        SwingUtilities.invokeLater(() -> this.scrollPane.getVerticalScrollBar().setValue(Math.min(this.scrollPane.getVerticalScrollBar().getMaximum(), oldScrollPaneValue)));
    }

    public BibEntry getMergeEntry() {
        return this.mergedEntry;
    }

    public JPanel getMergeEntryPanel() {
        return this.mainPanel;
    }

    private void updateAll() {
        if (!this.doneBuilding.booleanValue()) {
            return;
        }
        if (!this.identicalTypes.booleanValue() && this.typeRadioButtons.get(0).isSelected()) {
            this.mergedEntry.setType(this.leftEntry.getType());
        } else {
            this.mergedEntry.setType(this.rightEntry.getType());
        }
        for (String field2 : this.differentFields) {
            if (this.radioButtons.get(field2).get(0).isSelected()) {
                this.mergedEntry.setField(field2, this.leftEntry.getField(field2).get());
                continue;
            }
            if (this.radioButtons.get(field2).get(2).isSelected()) {
                this.mergedEntry.setField(field2, this.rightEntry.getField(field2).get());
                continue;
            }
            this.mergedEntry.clearField(field2);
        }
        this.entryPreview.setEntry(this.mergedEntry);
        StringWriter writer = new StringWriter();
        try {
            new BibEntryWriter(new LatexFieldFormatter(Globals.prefs.getLatexFieldFormatterPreferences()), false).write(this.mergedEntry, writer, this.databaseType);
        }
        catch (IOException ex) {
            LOGGER.error("Error in entry", ex);
        }
        this.sourceView.setText(writer.getBuffer().toString());
        this.sourceView.setCaretPosition(0);
    }
}

