/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.util;

import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.Tooltip;
import javafx.scene.input.MouseEvent;
import javafx.util.Callback;
import org.jabref.model.strings.StringUtil;

public class ValueTableCellFactory<S, T>
implements Callback<TableColumn<S, T>, TableCell<S, T>> {
    private Callback<T, String> toText;
    private Callback<T, Node> toGraphic;
    private Callback<T, EventHandler<? super MouseEvent>> toOnMouseClickedEvent;
    private Callback<T, String> toTooltip;

    public ValueTableCellFactory<S, T> withText(Callback<T, String> toText) {
        this.toText = toText;
        return this;
    }

    public ValueTableCellFactory<S, T> withGraphic(Callback<T, Node> toGraphic) {
        this.toGraphic = toGraphic;
        return this;
    }

    public ValueTableCellFactory<S, T> withTooltip(Callback<T, String> toTooltip) {
        this.toTooltip = toTooltip;
        return this;
    }

    public ValueTableCellFactory<S, T> withOnMouseClickedEvent(Callback<T, EventHandler<? super MouseEvent>> toOnMouseClickedEvent) {
        this.toOnMouseClickedEvent = toOnMouseClickedEvent;
        return this;
    }

    public TableCell<S, T> call(TableColumn<S, T> param2) {
        return new TableCell<S, T>(){

            protected void updateItem(T item, boolean empty) {
                super.updateItem(item, empty);
                if (empty || item == null) {
                    this.setText(null);
                    this.setGraphic(null);
                    this.setOnMouseClicked(null);
                    this.setTooltip(null);
                } else {
                    String tooltipText;
                    if (ValueTableCellFactory.this.toText != null) {
                        this.setText((String)ValueTableCellFactory.this.toText.call(item));
                    }
                    if (ValueTableCellFactory.this.toGraphic != null) {
                        this.setGraphic((Node)ValueTableCellFactory.this.toGraphic.call(item));
                    }
                    if (ValueTableCellFactory.this.toTooltip != null && StringUtil.isNotBlank(tooltipText = (String)ValueTableCellFactory.this.toTooltip.call(item))) {
                        this.setTooltip(new Tooltip(tooltipText));
                    }
                    if (ValueTableCellFactory.this.toOnMouseClickedEvent != null) {
                        this.setOnMouseClicked((EventHandler)ValueTableCellFactory.this.toOnMouseClickedEvent.call(item));
                    }
                }
            }
        };
    }
}

