/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.autosaveandbackup;

import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.database.event.AutosaveEvent;
import org.jabref.model.database.event.BibDatabaseContextChangedEvent;
import org.jabref.model.database.event.CoarseChangeFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutosaveManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(AutosaveManager.class);
    private static Set<AutosaveManager> runningInstances = new HashSet<AutosaveManager>();
    private final BibDatabaseContext bibDatabaseContext;
    private final BlockingQueue<Runnable> workerQueue;
    private final ExecutorService executor;
    private final EventBus eventBus;
    private final CoarseChangeFilter changeFilter;

    private AutosaveManager(BibDatabaseContext bibDatabaseContext) {
        this.bibDatabaseContext = bibDatabaseContext;
        this.workerQueue = new ArrayBlockingQueue<Runnable>(1);
        this.executor = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.SECONDS, this.workerQueue);
        this.eventBus = new EventBus();
        this.changeFilter = new CoarseChangeFilter(bibDatabaseContext);
        this.changeFilter.registerListener(this);
    }

    @Subscribe
    public synchronized void listen(BibDatabaseContextChangedEvent event) {
        try {
            this.executor.submit(() -> this.eventBus.post(new AutosaveEvent()));
        }
        catch (RejectedExecutionException e) {
            LOGGER.debug("Rejecting autosave while another save process is already running.");
        }
    }

    private void shutdown() {
        this.changeFilter.unregisterListener(this);
        this.changeFilter.shutdown();
        this.executor.shutdown();
    }

    public static AutosaveManager start(BibDatabaseContext bibDatabaseContext) {
        AutosaveManager autosaver = new AutosaveManager(bibDatabaseContext);
        runningInstances.add(autosaver);
        return autosaver;
    }

    public static void shutdown(BibDatabaseContext bibDatabaseContext) {
        runningInstances.stream().filter(instance -> instance.bibDatabaseContext == bibDatabaseContext).findAny().ifPresent(instance -> {
            instance.shutdown();
            runningInstances.remove(instance);
        });
    }

    public void registerListener(Object listener) {
        this.eventBus.register(listener);
    }

    public void unregisterListener(Object listener) {
        try {
            this.eventBus.unregister(listener);
        }
        catch (IllegalArgumentException e) {
            LOGGER.debug("Proble, unregistering", e);
        }
    }
}

